package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.nest.NESTDataNodeClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTSubWorkflowNodeClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTTaskNodeClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTWorkflowNodeClass;
import de.uni_trier.wi2.procake.data.model.nest.controlflowNode.NESTControlflowNodeClass;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTSequenceNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import java.util.List;
import java.util.Map;

// is registered listening for mxEvent.CONNECT events on mxConnectionHandler in CustomGraphComponent


public class CellConnectListener implements mxEventSource.mxIEventListener {

  private final Map<List<String>, EdgeInserter> nodeTypesToEdgeInserterMapping =
      Map.ofEntries(
          // workflow -> x

          // subworkflow -> x
          Map.entry(
              List.of(NESTSubWorkflowNodeClass.CLASS_NAME, NESTWorkflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewPartOfEdge(pre, post, null)),
          Map.entry(
              List.of(NESTSubWorkflowNodeClass.CLASS_NAME, NESTSubWorkflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewPartOfEdge(pre, post, null)),

          // task -> x
          Map.entry(
              List.of(NESTTaskNodeClass.CLASS_NAME, NESTWorkflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewPartOfEdge(pre, post, null)),
          Map.entry(
              List.of(NESTTaskNodeClass.CLASS_NAME, NESTSubWorkflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewPartOfEdge(pre, post, null)),
          Map.entry(
              List.of(NESTTaskNodeClass.CLASS_NAME, NESTTaskNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewControlflowEdge(
                          (NESTSequenceNodeObject) pre, (NESTSequenceNodeObject) post, null)),
          Map.entry(
              List.of(NESTTaskNodeClass.CLASS_NAME, NESTDataNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewDataflowEdge(pre, post, null)),
          Map.entry(
              List.of(NESTTaskNodeClass.CLASS_NAME, NESTControlflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewControlflowEdge(
                          (NESTSequenceNodeObject) pre, (NESTSequenceNodeObject) post, null)),

          // data -> x
          Map.entry(
              List.of(NESTDataNodeClass.CLASS_NAME, NESTWorkflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewPartOfEdge(pre, post, null)),
          Map.entry(
              List.of(NESTDataNodeClass.CLASS_NAME, NESTSubWorkflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewPartOfEdge(pre, post, null)),
          Map.entry(
              List.of(NESTDataNodeClass.CLASS_NAME, NESTTaskNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewDataflowEdge(pre, post, null)),
          Map.entry(
              List.of(NESTDataNodeClass.CLASS_NAME, NESTDataNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewConstraintEdge(pre, post, null)),

          // controlflow -> x
          Map.entry(
              List.of(NESTControlflowNodeClass.CLASS_NAME, NESTWorkflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewPartOfEdge(pre, post, null)),
          Map.entry(
              List.of(NESTControlflowNodeClass.CLASS_NAME, NESTSubWorkflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewPartOfEdge(pre, post, null)),
          Map.entry(
              List.of(NESTControlflowNodeClass.CLASS_NAME, NESTTaskNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewControlflowEdge(
                          (NESTSequenceNodeObject) pre, (NESTSequenceNodeObject) post, null)),
          Map.entry(
              List.of(NESTControlflowNodeClass.CLASS_NAME, NESTControlflowNodeClass.CLASS_NAME),
              (pre, post) ->
                  ((NESTWorkflowObject) pre.getGraph())
                      .getModifier()
                      .insertNewControlflowEdge(
                          (NESTSequenceNodeObject) pre, (NESTSequenceNodeObject) post, null)));
  private mxGraph mxGraph;

  public CellConnectListener(mxGraph mxGraph) {
    this.mxGraph = mxGraph;
  }

  @Override
  public void invoke(Object sender, mxEventObject mxEventObject) {
    mxCell edgeCell = (mxCell) mxEventObject.getProperty("cell");
    NESTNodeObject pre = (NESTNodeObject) edgeCell.getSource().getValue();
    NESTNodeObject post = (NESTNodeObject) edgeCell.getTarget().getValue();

    try {
      NESTEdgeObject insertedEdge = this.insertSuitableEdge(pre, post);
      edgeCell.setValue(insertedEdge);
      ((NESTWorkflowEditor.CustomGraph) this.mxGraph).setCellId(edgeCell, insertedEdge.getId());
      this.mxGraph
          .getModel()
          .setStyle(
              edgeCell,
              (NESTWorkflowEditor.CellStyle.get(
                  insertedEdge))); // style is only rendered in the view when set via the model,
      // directly setting it on the cell does not work

      if (((NESTWorkflowEditor.CustomGraph) this.mxGraph).getLayout().isExecuteOnEdgeInsertion()) {
        ((NESTWorkflowEditor.CustomGraph) this.mxGraph).executeLayout();
      }

    } catch (NullPointerException npe) {
      System.err.println(
          "No suitable edge class for node connection of type "
              + pre.getDataClass().getName()
              + " -> "
              + post.getDataClass().getName()
              + " found.");
      this.mxGraph.removeCells(
          new Object[]{
              edgeCell
          }); // edgeCell.getParent().remove(edgeCell) leaves a green marker for the deleted edge
      // behind which does not happen when removing the edge via the mxGraph
    }
  }

  private NESTEdgeObject insertSuitableEdge(NESTNodeObject pre, NESTNodeObject post) {
    List<String> key = List.of(pre.getDataClass().getName(), post.getDataClass().getName());
    return this.nodeTypesToEdgeInserterMapping.get(key).insert(pre, post);
  }

  interface EdgeInserter {

    NESTEdgeObject insert(NESTNodeObject pre, NESTNodeObject post);
  }
}
