package de.uni_trier.wi2.procake.gui.objecteditor.label;

import de.uni_trier.wi2.procake.data.model.nest.NESTGraphItemClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.utils.composition.XMLConfiguration.AbstractParameter;

public class NESTGraphItemObjectLabelProvider extends LabelProvider {

  @Override
  public void preInit(AbstractParameter[] parameters) {
    super.preInit(parameters);

    if (DATA_CLASS_NAME.getValue() == null) {
      DATA_CLASS_NAME.setValue(NESTGraphItemClass.CLASS_NAME);
    }
  }

  @Override
  public String getLabel(DataObject dataObject) {
    String label = super.getLabel(dataObject);
    if (label != null) {
      return label;
    }

    if (dataObject == null) {
      return "";
    }

    return LabelProviderFactory.getLabel(
        ((NESTGraphItemObject) dataObject).getSemanticDescriptor());
  }


}
