package de.uni_trier.wi2.procake.gui.objecteditor.label;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.base.AggregateClass;
import de.uni_trier.wi2.procake.data.model.base.AtomicClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTGraphItemClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.utils.composition.Factory;
import java.util.HashMap;
import java.util.Map;

public class LabelProviderFactory implements Factory {


  private static final Map<String, LabelProvider> providers = new HashMap<>();

  static {
    //add default label providers
    providers.put(NESTGraphItemClass.CLASS_NAME, new NESTGraphItemObjectLabelProvider());
    providers.put(AtomicClass.CLASS_NAME, new AtomicObjectLabelProvider());
    providers.put(AggregateClass.CLASS_NAME, new AggregateObjectLabelProvider());
  }



  @SuppressWarnings("unchecked")
  public static <T extends LabelProvider> T getProvider(DataClass dataClass) {
    DataClass tmp = dataClass;
    T provider;
    while (tmp != null) {
      provider = (T) providers.get(tmp.getName());
      if (provider != null) {
        return provider;
      }
      tmp = tmp.getSuperClass();
    }

    return null;
  }

  public static String getLabel(DataObject dataObject) {
    if (dataObject == null) {
      return "";
    }
    LabelProvider provider = getProvider(dataObject.getDataClass());
    if (provider == null) {
      return "";
    }
    return provider.getLabel(dataObject);
  }


  @Override
  public boolean bind(Object implementation) {
    if (implementation instanceof LabelProvider provider) {
      providers.put(provider.getDataClassName(), provider);
      return true;
    }
    return false;
  }

  @Override
  public boolean unbind(Object implementation) {
    if (implementation instanceof LabelProvider provider
        && providers.containsKey(provider.getDataClassName())) {
      providers.remove(provider.getDataClassName());
      return true;
    }
    return false;
  }

  @Override
  public void reset() {
    providers.clear();
  }
}
