package de.uni_trier.wi2.procake.gui.objecteditor.label;

import de.uni_trier.wi2.procake.data.PropertyTreeNode;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.utils.composition.FactoryObjectImplementation;
import de.uni_trier.wi2.procake.utils.composition.Parameter;
import de.uni_trier.wi2.procake.utils.composition.XMLConfiguration.AbstractParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LabelProvider extends FactoryObjectImplementation {

  protected final Parameter DATA_CLASS_NAME = new Parameter("dataClassName", false,
      null);

  private final String MULTI_LABEL_DELIMITER_NEW_LINE_VALUE = "newline";
  protected final Parameter MULTI_LABEL_DELIMITER = new Parameter(
      "multiLabelDelimiter", false,
      MULTI_LABEL_DELIMITER_NEW_LINE_VALUE);

  protected final Parameter DISPLAY_PROPERTIES = new Parameter("displayProperties", false,
      null);

  protected List<Parameter> parameterList = new ArrayList<>();

  @Override
  public List<Parameter> getParameters() {
    return new ArrayList<>(parameterList);
  }

  @Override
  public void preInit(AbstractParameter[] parameters) {
    for (AbstractParameter parameter : parameters) {
      if (parameter.getKey().equals(DATA_CLASS_NAME.getName())) {
        DATA_CLASS_NAME.setValues(parameter.getValue());
        parameterList.add(DATA_CLASS_NAME);
      } else if (parameter.getKey().equals(MULTI_LABEL_DELIMITER.getName())) {
        if (parameter.getValue().equals(MULTI_LABEL_DELIMITER_NEW_LINE_VALUE)) {
          MULTI_LABEL_DELIMITER.setValue("\n");
        } else {
          MULTI_LABEL_DELIMITER.setValue(parameter.getValue());
        }
        parameterList.add(MULTI_LABEL_DELIMITER);
      } else if (parameter.getKey().equals(DISPLAY_PROPERTIES.getName())) {
        DISPLAY_PROPERTIES.setValues(parameter.getValue());
        parameterList.add(DISPLAY_PROPERTIES);
      }
    }
  }

  @Override
  public void postInit() {
    // not needed
  }

  public String getLabel(DataObject dataObject) {
    if (dataObject == null) {
      return null;
    }

    if (DISPLAY_PROPERTIES.getValue() != null && dataObject.getPropertyRootNode() != null) {
      return DISPLAY_PROPERTIES.getValues().stream()
          .map(propName -> {
            for (PropertyTreeNode property : dataObject.getPropertyRootNode()) {
              if (property.getName().equals(propName)) {
                return property.getValue();
              }
            }
            return null;
          })
          .filter(Objects::nonNull)
          .collect(Collectors.joining(MULTI_LABEL_DELIMITER.getValue()));
    }

    return null;
  }

  public String getDataClassName() {
    return DATA_CLASS_NAME.getValue();
  }

}
