package de.uni_trier.wi2.procake.gui.objecteditor.label;

import de.uni_trier.wi2.procake.data.model.base.AtomicClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.utils.composition.XMLConfiguration.AbstractParameter;
import java.util.Objects;

public class AtomicObjectLabelProvider extends LabelProvider {

  @Override
  public void preInit(AbstractParameter[] parameters) {
    super.preInit(parameters);

    if (DATA_CLASS_NAME.getValue() == null) {
      DATA_CLASS_NAME.setValue(AtomicClass.CLASS_NAME);
    }
  }

  public String getLabel(DataObject dataObject) {
    String label = super.getLabel(dataObject);
    if (label != null) {
      return label;
    }

    if (dataObject == null) {
      return "";
    }

    return Objects.toString(((AtomicObject) dataObject).getNativeObject());
  }
}
