package de.uni_trier.wi2.procake.gui.objecteditor.label;

import de.uni_trier.wi2.procake.data.model.base.AggregateClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import de.uni_trier.wi2.procake.utils.composition.Parameter;
import de.uni_trier.wi2.procake.utils.composition.XMLConfiguration.AbstractParameter;
import de.uni_trier.wi2.procake.utils.exception.InvalidParameterException;
import java.util.Objects;
import java.util.stream.Collectors;

public class AggregateObjectLabelProvider extends LabelProvider {

  private final Parameter DISPLAY_ATTRIBUTE_NAME = new Parameter(
      "displayAttributeName", false,
      "true");

  private final String DISPLAY_ATTRIBUTES_ALL_VALUE = "**all**";
  private final Parameter DISPLAY_ATTRIBUTES = new Parameter(
      "displayAttributes", false,
      DISPLAY_ATTRIBUTES_ALL_VALUE);

  private boolean includeNullAttributes = false;
  private boolean includeAllAttributes = false;

  @Override
  public void preInit(AbstractParameter[] parameters) {
    super.preInit(parameters);

    if (DATA_CLASS_NAME.getValue() == null) {
      DATA_CLASS_NAME.setValue(AggregateClass.CLASS_NAME);
    }

    for (AbstractParameter parameter : parameters) {
      if (parameter.getKey().equals(DISPLAY_ATTRIBUTE_NAME.getName())) {
        if (!parameter.getValue().equals("true") && !parameter.getValue().equals("false")) {
          throw new InvalidParameterException(
              "Invalid parameter value \"" + parameter.getValue()
                  + "\". Boolean expected.");
        }
        DISPLAY_ATTRIBUTE_NAME.setValue(parameter.getValue());
        parameterList.add(DISPLAY_ATTRIBUTE_NAME);
      } else if (parameter.getKey().equals(DISPLAY_ATTRIBUTES.getName())) {
        DISPLAY_ATTRIBUTES.setValues(parameter.getValue());
        parameterList.add(DISPLAY_ATTRIBUTES);
      }
    }

  }

  public String getLabel(DataObject dataObject) {
    String label = super.getLabel(dataObject);
    if (label != null) {
      return label;
    }

    if (dataObject == null) {
      return "";
    }

    AggregateObject aggregateObject = (AggregateObject) dataObject;

    if (DISPLAY_ATTRIBUTES.getValue() != null) {
      if (DISPLAY_ATTRIBUTES.getValue().equals(DISPLAY_ATTRIBUTES_ALL_VALUE)
          || includeAllAttributes) {
        return Utils.aggregateToPaddedTable(aggregateObject, includeNullAttributes);
      } else if (DISPLAY_ATTRIBUTES.getValues().size() > 0) {
        return DISPLAY_ATTRIBUTES.getValues().stream()
            .map(
                attributeName -> {
                  DataObject attributeValue = aggregateObject.getAttributeValue(attributeName);
                  if (attributeValue != null) {
                    return (Boolean.parseBoolean(DISPLAY_ATTRIBUTE_NAME.getValue()) ? attributeName
                        + ": " : "")
                        + LabelProviderFactory.getLabel(attributeValue);
                  }
                  return null;
                })
            .filter(Objects::nonNull)
            .collect(Collectors.joining(MULTI_LABEL_DELIMITER.getValue()));
      }
    }

    return Objects.toString(aggregateObject);

  }

  public boolean isIncludeNullAttributes() {
    return includeNullAttributes;
  }

  public void setIncludeNullAttributes(boolean includeNullAttributes) {
    this.includeNullAttributes = includeNullAttributes;
  }

  public boolean isIncludeAllAttributes() {
    return includeAllAttributes;
  }

  public void setIncludeAllAttributes(boolean includeAllAttributes) {
    this.includeAllAttributes = includeAllAttributes;
  }
}
