package de.uni_trier.wi2.procake.gui.objecteditor;

import java.awt.*;
import java.util.Arrays;
import javax.swing.*;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

class TreeSelectionPathBar extends JPanel implements TreeSelectionListener {

  private final ObjectEditor objectEditor;
  private ObjectJTree tree;

  public TreeSelectionPathBar(ObjectEditor objectEditor, ObjectJTree tree) {
    super();
    this.objectEditor = objectEditor;
    this.tree = tree;
    this.setLayout(new FlowLayout(FlowLayout.LEADING));
    tree.getTree().addTreeSelectionListener(this);
    this.add(new JLabel(" "));

    // reserve height in top bar by adding dummy button
    JButton dummy = new JButton(" ");
    dummy.setMargin(new Insets(5, 2, 5, 2));
    dummy.setBorderPainted(false);
    dummy.setFocusPainted(false);
    this.add(dummy);
  }

  @Override
  public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    TreePath selectionPath = tree.getTree().getSelectionPath();
    if (selectionPath == null) {
      return;
    }

    this.removeAll();

    for (int i = 0; i < selectionPath.getPathCount(); i++) {
      JButton clickableLabel =
          new JButton(objectEditor.getLabel(selectionPath.getPathComponent(i)));
      clickableLabel.setMargin(new Insets(5, 2, 5, 2));
      clickableLabel.setFocusPainted(false);
      clickableLabel.setBorderPainted(false);

      int finalI = i;
      clickableLabel.addActionListener(
          e -> {
            TreePath path =
                new TreePath(Arrays.copyOfRange(selectionPath.getPath(), 0, finalI + 1));
            tree.getTree().setSelectionPath(path);
            tree.getTree().scrollPathToVisible(path);
          });

      this.add(clickableLabel);

      // add arrow bracket if not last element
      if (i < selectionPath.getPathCount() - 1) {
        JLabel bracket = new JLabel("〉");
        Font font = bracket.getFont();
        bracket.setFont(font.deriveFont(font.getStyle() | Font.BOLD));
        this.add(bracket);
      }
    }

    this.revalidate();
    this.repaint();
  }
}
