package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.gui.objecteditor.FilterableObjectPoolTreeModel.FilterStatus;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;

class PoolFilterBar extends JPanel {

  private final ObjectEditor editor;
  JTextField filterInput = new JTextField();
  JPanel functionalityButtons = new JPanel(new BorderLayout());
  JCheckBox filterCheckbox = new JCheckBox("in context");
  JButton filterButton = new JButton("Filter");
  JPanel nextPathButtons = new JPanel(new BorderLayout());
  JButton nextBtn = new JButton("Next");
  JButton backBtn = new JButton("Back");
  JTextField counterPaths = new JTextField("0/0");

  public PoolFilterBar(ObjectEditor editor) {
    this.editor = editor;
    this.setLayout(new BorderLayout());
    buildFilterLayout();
    addActionListeners();
  }

  private void buildFilterLayout() {
    counterPaths.setEditable(false);
    nextPathButtons.add(backBtn, BorderLayout.LINE_START);
    nextPathButtons.add(nextBtn, BorderLayout.CENTER);
    nextPathButtons.add(counterPaths, BorderLayout.LINE_END);

    functionalityButtons.add(filterButton, BorderLayout.LINE_START);
    functionalityButtons.add(filterCheckbox, BorderLayout.CENTER);
    functionalityButtons.add(nextPathButtons, BorderLayout.LINE_END);
    this.add(functionalityButtons, BorderLayout.LINE_START);
    this.add(filterInput, BorderLayout.CENTER);
  }

  private <T extends DataObject> void addActionListeners() {
    ActionListener filterAction =
        e -> {
          String filterOptions = "Filter";

          Object source = e.getSource();
          if (source instanceof JButton) {
            JButton clickedButton = (JButton) source;
            filterOptions = clickedButton.getText();
          }

          FilterStatus procFilterInput = ((FilterableObjectPoolTreeModel<T>) editor.getTree()
              .getModel())
              .setFilter(filterInput.getText(), filterCheckbox.isSelected(), filterOptions);
          updateFilterTextField(procFilterInput);
        };

    filterInput.addActionListener(filterAction);
    filterButton.addActionListener(filterAction);
    nextBtn.addActionListener(filterAction);
    backBtn.addActionListener(filterAction);
  }

  private void updateFilterTextField(FilterStatus procFilterInput) {
    if (procFilterInput.isFilterSuccess()) {
      filterInput.setBackground(Color.WHITE);
      editor.updateTreeView();

      counterPaths.setText((procFilterInput.getFilteredPaths() == null || procFilterInput.getFilteredPaths().size() == 0) ? "0/0" :
          procFilterInput.getOldFilterPos() + 1 + "/" + procFilterInput.getFilteredPaths().size());
    } else {
      filterInput.setBackground(new Color(255, 170, 166));
      counterPaths.setText("0/" + procFilterInput.getFilteredPaths().size());
    }
    filterInput.setText(procFilterInput.getProcTargetText());
  }
}
