package de.uni_trier.wi2.procake.gui.objecteditor;

import javax.swing.*;

public class ObjectJTree {

  private final ObjectEditor objectEditor;
  private JTree tree;

  public ObjectJTree(ObjectEditor objectEditor) {
    this.objectEditor = objectEditor;
    tree = new JTree() {
      @Override
      public String convertValueToText(Object value, boolean selected, boolean expanded,
          boolean leaf,
          int row, boolean hasFocus) {
        if (objectEditor == null) {
          return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        }

        return objectEditor.getLabel(value);
      }
    };
  }

  public JTree getTree() {
    return tree;
  }
}