package de.uni_trier.wi2.procake.gui.objecteditor;

import java.awt.event.KeyEvent;
import javax.swing.*;

/**
 * {@link JMenuBar} for the view of {@link ObjectEditor}
 */
public class ObjectEditorMenuBar extends JMenuBar {

  public ObjectEditorMenuBar(final ObjectEditor<?> editor) {
    JMenu menu;
    JMenuItem item;

    // Creates the file menu
    menu = this.add(new JMenu("File"));
    item = menu.add(new ObjectEditorActions.OpenPoolXMLFileAction(editor));
    item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, KeyEvent.CTRL_DOWN_MASK));

    // Creates save in object menu
    item = menu.add(new ObjectEditorActions.SaveInObjectAction(editor));
    item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, KeyEvent.CTRL_DOWN_MASK));

    // Creates export as XML-File menu
    item = menu.add(new ObjectEditorActions.ExportAsAction(editor));
    item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, KeyEvent.CTRL_DOWN_MASK));

    menu.addSeparator();

    // Creates refresh from original object menu
    item = menu.add(new ObjectEditorActions.RefreshObjectPoolAction(editor));
    item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0));

    // Creates the view menu
    menu = this.add(new JMenu("View"));
    item = menu.add(new ObjectEditorActions.OpenNewEditorWindowAction(editor));
    item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, KeyEvent.CTRL_DOWN_MASK));
  }
}