package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.Model;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorActions.AddNewDataAction;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorActions.DeleteDataAction;
import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class AddDataPanel<T> extends JPanel {

  private final ObjectEditor objectEditor;

  public AddDataPanel(ObjectEditor objectEditor) {
    super(new BorderLayout());
    this.objectEditor = objectEditor;

    if (objectEditor.getDataObject() != null && !objectEditor.getDataObject().isCollection()) {
      return;
    }

    Model model = ModelFactory.getDefaultModel();
    List<DataClass> possibleClasses = model.getClasses().stream()
        .filter(DataClass::isInstantiable).collect(Collectors.toList());
    objectEditor.newDataObjectClassSelector = new JComboBox<>(
        possibleClasses.toArray(DataClass[]::new));

    if (objectEditor.getPool() != null) {
      WriteableObjectPool pool = objectEditor.getPool();
      Stream poolCollection = pool.getCollection().stream();
      Map<DataClass, List<T>> groupedPool = (Map<DataClass, List<T>>) poolCollection.collect(Collectors.groupingBy(DataObject::getDataClass));
      List<T> mostTypeObjects = groupedPool.values().stream()
          .max(Comparator.comparing(List::size)).orElse(new ArrayList<>());

      if (mostTypeObjects.size() > 0) {
        objectEditor.newDataObjectClassSelector.setSelectedItem(
            mostTypeObjects.iterator().next().getClass());
      }
    }

    objectEditor.newDataObjectClassSelector.setMinimumSize(
        new Dimension(0, objectEditor.newDataObjectClassSelector.getHeight()));

    this.add(objectEditor.newDataObjectClassSelector, BorderLayout.CENTER);
    JButton addButton = new JButton(
        new AddNewDataAction(
            objectEditor, objectEditor.newDataObjectClassSelector));

    JButton deleteButton = new JButton(
        new DeleteDataAction(objectEditor));
    deleteButton.setMnemonic(KeyEvent.VK_DELETE);

    this.add(addButton, BorderLayout.LINE_END);
    this.add(deleteButton, BorderLayout.AFTER_LAST_LINE);
  }

}
