package de.uni_trier.wi2.procake.gui.nestworkflow;

import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.impl.NESTWorkflowVisualizerImpl;
import java.awt.*;
import javax.swing.*;

public class NESTWorkflowGUIVisualizerImpl extends NESTWorkflowVisualizerImpl<NESTWorkflowObject> {

  private JFrame frame;
  private MxGraphPanel mxGraphPanel;

  // This constructor is automatically called by the CompositionManager
  public NESTWorkflowGUIVisualizerImpl() {
  }

  public NESTWorkflowGUIVisualizerImpl(NESTWorkflowObject graph) {
    super(graph);
    frame = new JFrame("Visualization of " + graph.getId());
  }

  @Override
  public void visualize() {
    mxGraphPanel = new MxGraphPanel(this);
    mxGraphPanel.setGraph(this.graph);
    mxGraphPanel.init();

    frame.setContentPane(mxGraphPanel);
    //        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setSize(new Dimension(1000, 700));
    frame.setLocationRelativeTo(null);
    frame.setVisible(true);
  }

  /**
   * @return SVG as XML string
   */
  @Override
  public String getVisualization() {
    if (mxGraphPanel == null) {
      mxGraphPanel = new MxGraphPanel(this);
      mxGraphPanel.setGraph(this.graph);
      mxGraphPanel.init();
    }
    return mxGraphPanel.getVisualization();
  }

  @Override
  public NESTWorkflowVisualizerImpl copy(NESTWorkflowObject graph) {
    NESTWorkflowGUIVisualizerImpl copy = new NESTWorkflowGUIVisualizerImpl(graph);
    copy.initParametersBasedOn(this);
    return copy;
  }
}
