package de.uni_trier.wi2.procake.gui.nestworkflow;

import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.impl.NESTWorkflowVisualizerImpl;
import de.uni_trier.wi2.procake.data.objectpool.DataObjectIterator;
import javax.swing.*;

public class MxGraphPanelWithPoolComboBox extends MxGraphPanel {

  protected JComboBox<NESTWorkflowObject> cbGraphPool;

  public MxGraphPanelWithPoolComboBox(NESTWorkflowVisualizerImpl visualizer) {
    super(visualizer);
  }

  public NESTWorkflowObject getGraph() {
    return graph;
  }

  public void setGraph(NESTWorkflowObject graph) {
    this.graph = graph;
    this.init();
    mxGraph.repaint();
  }

  @Override
  public void init() {
    super.init();

    this.cbGraphPool = new JComboBox<>();

    this.cbGraphPool.setRenderer(new NESTWorkflowListCellRenderer());

    DataObjectIterator<NESTWorkflowObject> iterator = this.graphPool.iterator();
    while (iterator.hasNext()) {
      this.cbGraphPool.addItem(iterator.nextDataObject());
    }

    this.cbGraphPool.setSelectedItem(this.graph);
    this.cbGraphPool.addActionListener(
        e -> {
          JComboBox<NESTWorkflowObject> cb = (JComboBox<NESTWorkflowObject>) e.getSource();
          NESTWorkflowObject graph = (NESTWorkflowObject) cb.getSelectedItem();
          setGraph(graph);
          if (this.mxGraphPanel != null) {
            this.mxGraphPanel.setQueryGraph(graph);
          }
        });

    this.menubar.add(cbGraphPool);
  }

  public JComboBox<NESTWorkflowObject> getCbGraphPool() {
    return this.cbGraphPool;
  }
}
