package de.uni_trier.wi2.procake.gui.nestworkflow;

import static com.mxgraph.util.mxConstants.EDGESTYLE_ORTHOGONAL;
import static com.mxgraph.util.mxConstants.FONT_BOLD;
import static com.mxgraph.util.mxConstants.SHAPE_ELLIPSE;
import static com.mxgraph.util.mxConstants.SHAPE_RHOMBUS;
import static com.mxgraph.util.mxConstants.STYLE_DASHED;
import static com.mxgraph.util.mxConstants.STYLE_EDGE;
import static com.mxgraph.util.mxConstants.STYLE_FILLCOLOR;
import static com.mxgraph.util.mxConstants.STYLE_FONTCOLOR;
import static com.mxgraph.util.mxConstants.STYLE_FONTSTYLE;
import static com.mxgraph.util.mxConstants.STYLE_PORT_CONSTRAINT;
import static com.mxgraph.util.mxConstants.STYLE_ROUNDED;
import static com.mxgraph.util.mxConstants.STYLE_SHAPE;
import static com.mxgraph.util.mxConstants.STYLE_STROKECOLOR;
import static com.mxgraph.util.mxConstants.STYLE_STROKEWIDTH;
import static com.mxgraph.util.mxConstants.STYLE_WHITE_SPACE;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxCellRenderer.CanvasFactory;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTDataNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTSequenceNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.impl.NESTWorkflowVisualizerImpl;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class MxGraphPanel extends JPanel {

  public static final String DATA_NODE_STYLE = "DATA_NODE_STYLE";
  public static final String TASK_NODE_STYLE = "TASK_NODE_STYLE";
  public static final String CONTROL_FLOW_NODE_STYLE = "CONTROL_FLOW_NODE_STYLE";
  public static final String DATA_FLOW_EDGE_STYLE = "DATA_FLOW_EDGE_STYLE";
  public static final String CONTROL_FLOW_EDGE_STYLE = "CONTROL_FLOW_EDGE_STYLE";
  protected static final int VERTEX_WIDTH = 90;
  protected static final int VERTEX_HEIGHT = 40;
  protected static final int X_SPACING = 40 + VERTEX_WIDTH;
  protected static final int Y_SPACING = 40 + VERTEX_HEIGHT;
  private final NESTWorkflowVisualizerImpl visualizer;
  protected JPanel menubar;
  // font sizes of specific components
  protected float fSizeTextArea = ((Font) UIManager.get("TextArea.font")).getSize2D();
  // Parameters for allowing to change a graph and save it
  protected WriteableObjectPool<NESTWorkflowObject> graphPool;
  protected NESTWorkflowObject originalGraph;
  /* SIDEBAR */
  protected JPanel sbPanel;
  protected JLabel sbPanelTopLabel;
  protected JPanel sbPanelBottom;
  protected JScrollPane sbScrollPane;
  protected JPanel sbPanelCenter;
  // some flags
  protected boolean sidebarWritable = true;
  protected boolean sidebarEnabled = true;
  /*  *****  */
  protected boolean showNodeIDs = false;
  protected boolean showDataNodes = true;
  protected mxGraph mxGraph;
  protected mxGraphComponent graphComponent;
  protected Object parent;
  protected HashMap<String, Object> vertices = new HashMap<>();
  protected HashMap<Object, NESTGraphItemObject> mapCellToNESTItem = new HashMap<>();
  protected Set<Object> dataVertices = new HashSet<>();
  protected Set<Object> dataFlowEdges = new HashSet<>();
  // for positioning of vertices
  protected int x = -X_SPACING;
  protected int xMax = x;
  protected int y = 0;
  protected int yMax = y;
  protected Stack<readMode> modes = new Stack<>();
  // to be changed
  protected NESTWorkflowObject queryGraph;
  //
  protected MxGraphPanel mxGraphPanel;
  // data (graph, casebase, etc [if needed])
  protected NESTWorkflowObject graph;

  public MxGraphPanel(NESTWorkflowVisualizerImpl visualizer) {
    super();
    this.visualizer = visualizer;
  }

  public MxGraphPanel getMxGraphPanel() {
    return mxGraphPanel;
  }

  public void setMxGraphPanel(MxGraphPanel mxGraphPanel) {
    this.mxGraphPanel = mxGraphPanel;
  }

  public NESTWorkflowObject getGraph() {
    return graph;
  }

  public void setGraph(NESTWorkflowObject graph) {
    this.graph = graph;
  }

  protected void createGraph() {

    resetGraph();

    // create styles
    setStyleSheet();

    // edges overlapped by vertices
    mxGraph.setKeepEdgesInBackground(true);

    // build mxGraph
    mxGraph.getModel().beginUpdate();
    try {
      // place sequence nodes
      Set<NESTSequenceNodeObject> startNodes = graph.getStartNodes();
      for (NESTSequenceNodeObject startNode : startNodes) {
        modes.clear();
        modes.push(readMode.SEQ);
        drawNode(startNode);
      }

      // place data nodes
      y = yMax + 2 * Y_SPACING;
      x = 0;
      for (NESTDataNodeObject dataNode : graph.getExtractor().extractOrderedDataNodes()) {
        insertNode(dataNode);
        x += X_SPACING;
      }

      // place edges
      y += Y_SPACING;
      x = 0;
      for (NESTEdgeObject edge : graph.getGraphEdges()) {
        if (edge.isNESTPartOfEdge()) {
          continue;
        }

        String preNodeId = edge.getPre().getId();
        String postNodeId = edge.getPost().getId();

        Object addedEdge;

        if (!vertices.containsKey(preNodeId)) {
          // should not happen
          vertices.put(
              preNodeId,
              mxGraph.insertVertex(
                  parent,
                  null,
                  getNodeLabel(edge.getPre()),
                  x += X_SPACING,
                  y,
                  VERTEX_WIDTH,
                  VERTEX_HEIGHT));
        }

        if (!vertices.containsKey(postNodeId)) {
          // should not happen
          vertices.put(
              postNodeId,
              mxGraph.insertVertex(
                  parent,
                  null,
                  getNodeLabel(edge.getPost()),
                  x += X_SPACING,
                  y,
                  VERTEX_WIDTH,
                  VERTEX_HEIGHT));
        }

        if (edge.isNESTControlflowEdge()) {
          addedEdge =
              mxGraph.insertEdge(
                  parent,
                  null,
                  "",
                  vertices.get(preNodeId),
                  vertices.get(postNodeId),
                  CONTROL_FLOW_EDGE_STYLE);

        } else if (edge.isNESTDataflowEdge()) {
          Object[] edges =
              mxGraph.getEdgesBetween(vertices.get(postNodeId), vertices.get(preNodeId));
          if (edges.length > 0) {
            mxGraph.getModel().remove(edges[0]);
            addedEdge =
                mxGraph.insertEdge(
                    parent,
                    null,
                    "",
                    vertices.get(preNodeId),
                    vertices.get(postNodeId),
                    DATA_FLOW_EDGE_STYLE + ";startArrow=classic");
            dataFlowEdges.add(addedEdge);
          } else {
            addedEdge =
                mxGraph.insertEdge(
                    parent,
                    null,
                    "",
                    vertices.get(preNodeId),
                    vertices.get(postNodeId),
                    DATA_FLOW_EDGE_STYLE);
            dataFlowEdges.add(addedEdge);
          }
        } else {
          // use default edge style
          addedEdge =
              mxGraph.insertEdge(
                  parent, null, "", vertices.get(preNodeId), vertices.get(postNodeId));
        }

        if (addedEdge != null) {
          this.mapCellToNESTItem.put(addedEdge, edge);
        }
      }

      // mxHierarchicalLayout layout = new mxHierarchicalLayout(mxGraph, SwingConstants.WEST);
      // layout.setInterRankCellSpacing(40);
      // layout.setIntraCellSpacing(40);
      // layout.setParallelEdgeSpacing(20);
      // layout.setFineTuning(true);
      // layout.setDisableEdgeStyle(true);
      // layout.execute(parent);
    } finally {
      mxGraph.getModel().endUpdate();
    }

    // hide data nodes
    showDataNodes(showDataNodes);
  }

  protected void showDataNodes(boolean showDataNodes) {
    for (Object object : dataVertices) {
      mxGraph.getModel().setVisible(object, showDataNodes);
    }
    for (Object object : dataFlowEdges) {
      mxGraph.getModel().setVisible(object, showDataNodes);
    }
  }

  protected void resetGraph() {
    // reset position variables
    x = -X_SPACING;
    xMax = x;
    y = 0;
    yMax = y;

    mxGraph = new mxGraph();
    parent = mxGraph.getDefaultParent();
    vertices.clear();
    dataVertices.clear();
    dataFlowEdges.clear();
    this.mapCellToNESTItem.clear();
    mxGraph.setCellsEditable(false);
    mxGraph.setCellsBendable(false);
    mxGraph.setCellsDisconnectable(false);
    mxGraph.setCellsMovable(false);
    mxGraph.setCellsResizable(false);
  }

  protected void drawNode(NESTSequenceNodeObject node) {

    // increase x
    x += X_SPACING;

    if (node.isNESTTaskNode()) {
      insertNode(node);
      for (NESTSequenceNodeObject currNode : node.getNextNodes()) {
        drawNode(currNode);
      }

    } else if (node.isNESTControlflowNode()) {
      NESTControlflowNodeObject controlflow = (NESTControlflowNodeObject) node;

      if (controlflow.isAndStartNode() || controlflow.isXorStartNode()) {
        // Controlflow Type is and_split or xor_split
        insertNode(node);

        int seqCnt = 1;
        int numOfSeq = controlflow.getNextNodes().size();

        for (NESTSequenceNodeObject currNode : controlflow.getNextNodes()) {

          if (seqCnt == numOfSeq) {
            modes.push(readMode.SEQ);
          } else {
            modes.push(readMode.AND_OR);
          }

          int currX = x;
          drawNode(currNode);
          x = currX;

          if (seqCnt++ < numOfSeq) {
            y += Y_SPACING;
          }
        }

      } else if (controlflow.isLoopStartNode()) {
        // Controlflow Type is loop_join
        insertNode(node);

        for (NESTSequenceNodeObject currNode : controlflow.getNextNodes()) {
          drawNode(currNode);
        }

      } else if (controlflow.isAndEndNode() || controlflow.isXorEndNode()) {
        // Controlflow Type is and_join, xor_join
        if (x > xMax) {
          xMax = x;
        }

        if (modes.pop() == readMode.SEQ) {
          // visited all branches
          // set x according to longest branch
          x = xMax;

          // set y according to number of branches
          yMax = y;
          // y = (int) (y - Math.round(Y_SPACING * ((double) controlflow.getNumberOfBranches() - 1)
          // / 2));

          insertNode(node, CONTROL_FLOW_NODE_STYLE + ";portConstraint=eastwestsouthnorth");

          for (NESTSequenceNodeObject currNode : node.getNextNodes()) {
            drawNode(currNode);
          }
        }

      } else if (controlflow.isLoopEndNode()) {
        // Controlflow Type is loop_split
        insertNode(node);
        for (NESTSequenceNodeObject currNode : node.getNextNodes()) {
          // if the next node is also a NESTControlflowNode then check if its the loop's start node
          // (loop-join)
          if (currNode.isNESTControlflowNode()) {
            if (!node.getId().contains(currNode.getId())) {
              drawNode(currNode);
            }
          } else {
            drawNode(currNode);
          }
        }
      }
    }
  }

  protected void insertNode(NESTNodeObject node) {
    if (node.isNESTDataNode()) {
      insertNode(node, DATA_NODE_STYLE);
      dataVertices.add(vertices.get(node.getId()));

    } else if (node.isNESTControlflowNode()) {
      insertNode(node, CONTROL_FLOW_NODE_STYLE);
    } else {
      // use default style
      insertNode(node, TASK_NODE_STYLE);
    }
  }

  protected void insertNode(NESTNodeObject node, String style) {
    // use specific style
    Object cell =
        mxGraph.insertVertex(
            parent, null, getNodeLabel(node), x, y, VERTEX_WIDTH, VERTEX_HEIGHT, style);
    vertices.put(node.getId(), cell);
    this.mapCellToNESTItem.put(cell, node);
  }

  protected void setStyleSheet() {
    mxStylesheet stylesheet = mxGraph.getStylesheet();
    Map<String, Object> defaultEdgeStyle = mxGraph.getStylesheet().getDefaultEdgeStyle();
    Map<String, Object> defaultVertexStyle = mxGraph.getStylesheet().getDefaultVertexStyle();
    //        defaultVertexStyle.put(STYLE_FONTSIZE, 20);
    defaultVertexStyle.put("HTML", 1);
    Map<String, Object> style;

    // task node style
    style = new HashMap<String, Object>(defaultVertexStyle);
    style.put(STYLE_PORT_CONSTRAINT, "eastwest");
    style.put(STYLE_STROKEWIDTH, 0);
    style.put(STYLE_FILLCOLOR, "#0074d9");
    style.put(STYLE_FONTCOLOR, "#ffffff");
    style.put(STYLE_FONTSTYLE, FONT_BOLD);
    style.put(STYLE_WHITE_SPACE, "wrap");
    stylesheet.putCellStyle(TASK_NODE_STYLE, style);

    // data node style
    style = new HashMap<String, Object>(defaultVertexStyle);
    style.put(STYLE_SHAPE, SHAPE_ELLIPSE);
    style.put(STYLE_STROKEWIDTH, 0);
    style.put(STYLE_FILLCOLOR, "#ff851b");
    style.put(STYLE_FONTCOLOR, "#ffffff");
    style.put(STYLE_FONTSTYLE, FONT_BOLD);
    style.put(STYLE_WHITE_SPACE, "wrap");
    stylesheet.putCellStyle(DATA_NODE_STYLE, style);

    // controlflow node style
    style = new HashMap<String, Object>(defaultVertexStyle);
    style.put(STYLE_SHAPE, SHAPE_RHOMBUS);
    style.put(STYLE_STROKEWIDTH, 0);
    style.put(STYLE_FILLCOLOR, "#2ecc40");
    style.put(STYLE_FONTCOLOR, "#ffffff");
    style.put(STYLE_FONTSTYLE, FONT_BOLD);
    style.put(STYLE_WHITE_SPACE, "wrap");
    stylesheet.putCellStyle(CONTROL_FLOW_NODE_STYLE, style);

    // dataflow edge style
    style = new HashMap<String, Object>(defaultEdgeStyle);
    style.put(STYLE_DASHED, "1");
    style.put(STYLE_STROKEWIDTH, 2);
    style.put(STYLE_STROKECOLOR, "#cecece");
    // style.put(mxConstants.STYLE_OPACITY, 50);
    stylesheet.putCellStyle(DATA_FLOW_EDGE_STYLE, style);

    // controlflow edge style
    style = new HashMap<String, Object>(defaultEdgeStyle);
    style.put(STYLE_STROKEWIDTH, 2);
    style.put(STYLE_STROKECOLOR, "#000000");
    style.put(STYLE_ROUNDED, true);
    // style.put(mxConstants.STYLE_EDGE, mxConstants.EDGESTYLE_SIDETOSIDE);
    style.put(STYLE_EDGE, EDGESTYLE_ORTHOGONAL);
    stylesheet.putCellStyle(CONTROL_FLOW_EDGE_STYLE, style);
  }

  protected String getNodeLabel(NESTNodeObject node) {
    return visualizer.getLabel(node) + (showNodeIDs ? " (" + node.getId() + ")" : "");
  }

  public void init() {
    this.originalGraph = (NESTWorkflowObject) this.graph.copy();

    createGraph();

    this.removeAll();
    this.revalidate();
    this.setLayout(new BorderLayout());

    // Creates a control in a scrollpane
    this.graphComponent = new mxGraphComponent(mxGraph);
    graphComponent.setConnectable(false);
    // graphComponent.setToolTips(true);     Tooltips are not needed anymore. However, they might be
    // used in future.
    //        graphComponent.setEnabled(false);
    graphComponent.setBorder(new EmptyBorder(20, 20, 20, 20));
    //        graphComponent.getGraphControl().addMouseMotionListener(new MouseInputAdapter() {
    //            @Override
    //            public void mouseMoved(MouseEvent e) {
    //                Object cell = graphComponent.getCellAt(e.getX(), e.getY());
    //                System.out.println("mouse moved");
    //
    //                System.out.println("Is edge? => " + mxGraph.getModel().isEdge(cell));
    //                System.out.println("Is vertex? => " + mxGraph.getModel().isVertex(cell));
    //
    //                if (cell != null) {
    //                    System.out.println(mxGraph.getLabel(cell));
    //                    NESTGraphItemObject item = mapCellToNESTItem.get(cell);
    //                    System.out.println("Graphitemid: " + item.getId());
    //                }
    //            }
    //        });
    graphComponent
        .getGraphControl()
        .addMouseListener(
            new MouseInputAdapter() {
              //            @Override
              //            public void mouseEntered(MouseEvent e) {
              //                System.out.println("mouse entered");
              //            }
              //
              //            @Override
              //            public void mouseExited(MouseEvent e) {
              //                System.out.println("mouse exited");
              //            }

              //            @Override     // does not work in "addMouseListener"; instead, it works
              // in addMouseMotionListener
              //            public void mouseMoved(MouseEvent e) {
              //                Object cell = graphComponent.getCellAt(e.getX(), e.getY());
              //                System.out.println("mouse moved");
              //
              //                if (cell != null) {
              //                    System.out.println(mxGraph.getLabel(cell));
              //                }
              //            }

              @Override
              public void mouseClicked(MouseEvent e) {
                Object cell = graphComponent.getCellAt(e.getX(), e.getY());
                if (cell != null) {
                  NESTGraphItemObject item = mapCellToNESTItem.get(cell);

                  showAggregateValuesOfItem(item);
                }
              }
            });
    //        JScrollPane scrollPane = new JScrollPane(graphComponent);
    //        scrollPane.setAutoscrolls(true);
    graphComponent.setAutoscrolls(true);

    // Puts the control into the frame
    //        this.add(scrollPane, BorderLayout.CENTER);
    this.add(graphComponent, BorderLayout.CENTER);

    /* Create and add sidebar */
    this.sbPanel = new JPanel();

    this.sbPanel.setLayout(new BorderLayout());

    // TOP
    this.sbPanelTopLabel = new JLabel();
    this.sbPanel.add(this.sbPanelTopLabel, BorderLayout.PAGE_START);

    // CENTER
    this.sbScrollPane = new JScrollPane();
    this.sbPanel.add(this.sbScrollPane, BorderLayout.CENTER);

    this.sbPanelCenter = new JPanel();
    //        this.sbGridLayout = new GridLayout(0, 2, 0, 1);
    //        sbPanelCenter.setLayout(this.sbGridLayout);
    //        sbPanelCenter.add(new JLabel("[Key 1]"));
    //        sbPanelCenter.add(new JTextArea("[Value 1]"));
    //        sbPanelCenter.add(new JLabel("[Key 1]"));
    //        sbPanelCenter.add(new JTextArea("[Value 2]"));
    //        sbPanelCenter.add(new JLabel("[Key 3]"));
    //        sbPanelCenter.add(new JTextArea("[Value 3]"));

    GridBagLayout sbGridBagLayout = new GridBagLayout();
    this.sbPanelCenter.setLayout(sbGridBagLayout);

    JPanel jPanel = new JPanel();
    jPanel.setLayout(new FlowLayout());
    jPanel.add(sbPanelCenter);

    this.sbScrollPane.setViewportView(jPanel);
    // BOTTOM
    this.sbPanelBottom = new JPanel();
    this.sbPanelBottom.add(new JButton("[SAVE]"));
    this.sbPanelBottom.add(new JButton("[RESET]"));
    this.sbPanel.add(sbPanelBottom, BorderLayout.PAGE_END);

    this.add(sbPanel, BorderLayout.LINE_END);
    /* **** */

    // top-Menubar
    menubar = new JPanel(new FlowLayout(FlowLayout.LEFT));
    JCheckBox chkBoxShowData = new JCheckBox("show data objects", showDataNodes);
    chkBoxShowData.addActionListener(
        new ActionListener() {
          @Override
          public void actionPerformed(ActionEvent e) {
            showDataNodes = !showDataNodes;
            mxGraph.getModel().beginUpdate();
            try {
              showDataNodes(showDataNodes);
            } finally {
              mxGraph.getModel().endUpdate();
            }
            mxGraph.repaint();
          }
        });
    menubar.add(chkBoxShowData);

    // show data node ids
    JCheckBox chkBoxShowNodeIds = new JCheckBox("show node ids", showNodeIDs);
    chkBoxShowNodeIds.addActionListener(
        new ActionListener() {
          @Override
          public void actionPerformed(ActionEvent e) {
            showNodeIDs = !showNodeIDs;
            try {
              mxGraph.getModel().beginUpdate();
              for (String key : vertices.keySet()) {
                mxCellState state = mxGraph.getView().getState(vertices.get(key));
                // Bugfix; If we disable data nodes, there is no mapping from the NEST object to a
                // state object.
                // In this case, the state is null. Hence, we can't set a label:
                if (state != null) {
                  state.setLabel(getNodeLabel(graph.getGraphNode(key)));
                }
              }
            } finally {
              mxGraph.getModel().endUpdate();
            }
            mxGraph.repaint();
          }
        });
    menubar.add(chkBoxShowNodeIds);
    this.add(menubar, BorderLayout.NORTH);

    // zoom function
    //        JButton jbZoomPlus = new JButton("+");
    //        jbZoomPlus.addActionListener(e -> {
    //            this.changeFontZoom(this, 1.0f);
    ////            for (Map<String, Object> specificeStyle :
    // this.mxGraph.getStylesheet().getStyles().values()) {
    ////                int oldFontSize = (Integer) specificeStyle.getOrDefault(STYLE_FONTSIZE, 11);
    ////                //specificeStyle.put(STYLE_FONTSIZE, oldFontSize+1);
    ////            }
    ////            graphComponent.refresh();
    ////            for (Object cell : vertices.values()) {
    ////                //mxGraph.updateCellSize(cell, true);
    ////            }
    ////            graphComponent.refresh();
    //        });
    //        menubar.add(jbZoomPlus);

    //        JButton jbZoomMinus = new JButton("-");
    //        jbZoomMinus.addActionListener(e -> {
    //            this.changeFontZoom(this, -1.0f);
    ////            for (Map<String, Object> specificeStyle :
    // this.mxGraph.getStylesheet().getStyles().values()) {
    ////                int oldFontSize = (Integer) specificeStyle.getOrDefault(STYLE_FONTSIZE, 11);
    ////                specificeStyle.put(STYLE_FONTSIZE, oldFontSize-1);
    ////                }
    ////            graphComponent.refresh();
    ////            for (Object cell : vertices.values()) {
    ////                mxGraph.updateCellSize(cell, true);
    ////            }
    ////            graphComponent.refresh();
    //        });
    //        menubar.add(jbZoomMinus);

    // zoom-buttons
    JButton jbZoomPlusGraph = new JButton("+");
    jbZoomPlusGraph.addActionListener(
        e -> {
          double oldScale = mxGraph.getView().getScale();
          mxGraph.getView().setScale(oldScale + 0.2);
          graphComponent.refresh();
        });
    menubar.add(jbZoomPlusGraph);

    JButton jbZoomMinusGraph = new JButton("-");
    jbZoomMinusGraph.addActionListener(
        e -> {
          double oldScale = mxGraph.getView().getScale();
          mxGraph.getView().setScale(oldScale - 0.2);
          graphComponent.refresh();
        });
    menubar.add(jbZoomMinusGraph);

    // show workflow node info
    JButton jbWorkflowNodeInfo = new JButton("Workflow node info");
    jbWorkflowNodeInfo.addActionListener(
        e -> {
          this.showAggregateValuesOfItem(this.graph.getWorkflowNode());
        });
    menubar.add(jbWorkflowNodeInfo);

    // graphComponent.getGraphControl().addMouseListener(new MouseAdapter() {
    // public void mouseReleased(MouseEvent e) {
    // Object cell = graphComponent.getCellAt(e.getX(), e.getY());
    //
    // if (cell != null) {
    // System.out.println("cell=" + mxGraph.getLabel(cell));
    // }
    // }
    // });

    this.getInputMap(WHEN_IN_FOCUSED_WINDOW)
        .put(KeyStroke.getKeyStroke(KeyEvent.VK_PLUS, InputEvent.CTRL_DOWN_MASK), "zoomPlus");
    this.getActionMap()
        .put(
            "zoomPlus",
            new AbstractAction() {
              @Override
              public void actionPerformed(ActionEvent e) {
                double oldScale = mxGraph.getView().getScale();
                mxGraph.getView().setScale(oldScale + 0.2);
                graphComponent.refresh();
              }
            });

    this.getInputMap(WHEN_IN_FOCUSED_WINDOW)
        .put(KeyStroke.getKeyStroke(KeyEvent.VK_MINUS, InputEvent.CTRL_DOWN_MASK), "zoomMinus");
    this.getActionMap()
        .put(
            "zoomMinus",
            new AbstractAction() {
              @Override
              public void actionPerformed(ActionEvent e) {
                double oldScale = mxGraph.getView().getScale();
                mxGraph.getView().setScale(oldScale - 0.2);
                graphComponent.refresh();
              }
            });

    setEnableSidebar(this.sidebarEnabled);
    setSidebarWriteable(this.sidebarWritable);

    this.showAggregateValuesOfItem(this.graph.getWorkflowNode());
  }

  protected void showAggregateValuesOfItem(NESTGraphItemObject item) {
    if (item == null) {
      return;
    }
    this.sbPanelTopLabel.setText("graphItemId: " + item.getId());
    boolean hasSemanticDescription = (item.getSemanticDescriptor() != null);
    if (!hasSemanticDescription) {
    } else {
      int gridY = 0;
      sbPanelCenter.removeAll();

      this.showAggregateKeyValue((AggregateObject) item.getSemanticDescriptor(), gridY, 0);

      sbPanelCenter.revalidate();
      sbPanelCenter.repaint();
    }
  }

  protected int showAggregateKeyValue(AggregateObject aggregateObject, int gridY, int recDepth) {
    for (String attributeName : aggregateObject.getAggregateClass().getAttributeNames()) {

      StringBuffer blankSpacePrefix = new StringBuffer(recDepth);
      for (int i = 0; i < recDepth; i++) {
        blankSpacePrefix.append("    ");
      }

      GridBagConstraints constraints = new GridBagConstraints();
      constraints.insets = new Insets(1, 2, 2, 2);
      constraints.weightx = 0.0;
      constraints.weighty = 0.0;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridx = 0;
      constraints.gridy = gridY;
      JLabel keyLabel = new JLabel(blankSpacePrefix + attributeName);
      Font oldFont = keyLabel.getFont();
      Font newFont = oldFont.deriveFont(this.fSizeTextArea);
      keyLabel.setFont(newFont);
      sbPanelCenter.add(keyLabel, constraints);

      // check, if aggregate value is also an aggregate object (if so, we have nested aggregates =>
      // recursion)
      if (aggregateObject.hasAttributeValue(attributeName)) {
        DataObject dObject = aggregateObject.getAttributeValue(attributeName);
        if (dObject.isAggregate()) {
          gridY++;
          recDepth++;
          this.showAggregateKeyValue((AggregateObject) dObject, gridY, recDepth);
        } else {
          constraints.anchor = GridBagConstraints.EAST;
          constraints.gridx = 1;
          constraints.gridy = gridY;
          JTextArea valueTextArea;
          if (dObject.isAtomic()) {
            valueTextArea = new JTextArea(((AtomicObject) dObject).getNativeObject().toString());
          } else {
            valueTextArea = new JTextArea(dObject.toString());
          }
          oldFont = valueTextArea.getFont();
          newFont = oldFont.deriveFont(this.fSizeTextArea);
          valueTextArea.setFont(newFont);
          valueTextArea.setEditable(this.sidebarWritable);
          if (valueTextArea.getText().length() > 20) {
            valueTextArea.setColumns(20);
            valueTextArea.setLineWrap(true);
          }
          sbPanelCenter.add(valueTextArea, constraints);
        }
      } else {
        constraints.anchor = GridBagConstraints.EAST;
        constraints.gridx = 1;
        constraints.gridy = gridY;
        JTextArea valueTextArea = new JTextArea("<null>");
        oldFont = valueTextArea.getFont();
        newFont = oldFont.deriveFont(this.fSizeTextArea);
        valueTextArea.setFont(newFont);
        valueTextArea.setEditable(this.sidebarWritable);
        sbPanelCenter.add(valueTextArea, constraints);
      }

      gridY++;
    }

    return gridY;
  }

  protected void changeFontZoom(Component component, float deltaFontSize) {
    this.fSizeTextArea += deltaFontSize;

    this.changeFontZoomRecursively(component, deltaFontSize);
  }

  protected void changeFontZoomRecursively(Component component, float deltaFontSize) {
    Font oldFont = component.getFont();
    Font newFont = oldFont.deriveFont(oldFont.getSize2D() + deltaFontSize);

    component.setFont(newFont);

    if (component instanceof Container) {
      Container container = (Container) component;

      for (Component c : container.getComponents()) {
        this.changeFontZoomRecursively(c, deltaFontSize);
      }
    }
  }

  /**
   * @return SVG as XML string
   */
  public String getVisualization() {
    createGraph();

    mxSvgCanvas canvas =
        (mxSvgCanvas)
            mxCellRenderer.drawCells(
                mxGraph,
                null,
                1,
                null,
                new CanvasFactory() {
                  public mxICanvas createCanvas(int width, int height) {
                    mxSvgCanvas canvas =
                        new mxSvgCanvas(mxDomUtils.createSvgDocument(width, height));
                    canvas.setEmbedded(true);
                    return canvas;
                  }
                });

    return mxXmlUtils.getXml(canvas.getDocument());
  }

  public void setQueryGraph(NESTWorkflowObject graph) {
    // empty
  }

  public void setEnableSidebar(boolean enable) {
    this.sbPanel.setVisible(enable);
  }

  public void setSidebarWriteable(boolean enable) {
    this.sidebarWritable = enable;

    for (Component component : this.sbPanelCenter.getComponents()) {
      if (component instanceof JTextArea) {
        ((JTextArea) component).setEditable(this.sidebarWritable);
      }
    }

    this.sbPanelBottom.setVisible(this.sidebarWritable);
  }

  public WriteableObjectPool<NESTWorkflowObject> getGraphPool() {
    return graphPool;
  }

  public void setGraphPool(WriteableObjectPool<NESTWorkflowObject> graphPool) {
    this.graphPool = graphPool;
  }

  protected enum readMode {
    SEQ,
    AND_OR
  }
}
