/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.objectpooleditor;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.base.AggregateClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.objectpool.ReadableObjectPool;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import net.openhft.compiler.CompilerUtils;

@Deprecated(since="3.0.0", forRemoval=true)
public class PoolFilter {
    private static int classCounter = 0;
    private static String UUID = "Od762cdd03bb4b8c95eac22239266c45A";
    private static String PACKAGE_NAME = "cake.utils.objectpooleditor";

    public static Class getFilterClass(ReadableObjectPool<? extends DataObject> pool, String filterExpression) throws ClassNotFoundException {
        JavaSourceFromString filterClassSource = PoolFilter.generateFilterClassSource(pool, filterExpression);
        Class filterClass = CompilerUtils.CACHED_COMPILER.loadFromJava(filterClassSource.getClassName(), filterClassSource.getCode());
        return filterClass;
    }

    private static JavaSourceFromString generateFilterClassSource(ReadableObjectPool<? extends DataObject> pool, String filterExpression) {
        String className = "PoolFilter" + UUID + classCounter++;
        Set<AggregateClass> aggregateClassesInPool = pool.getCollection().stream().map(DataObject::getDataClass).filter(DataClass::isAggregate).map(AggregateClass.class::cast).collect(Collectors.toSet());
        StringBuilder builder = new StringBuilder();
        builder.append("package " + PACKAGE_NAME + ";");
        builder.append("import de.uni_trier.wi2.procake.data.object.base.AggregateObject;");
        builder.append("import de.uni_trier.wi2.procake.data.object.base.AtomicObject;");
        builder.append("public class " + className + " {");
        builder.append(PoolFilter.generateFilterMethodsSource(aggregateClassesInPool, filterExpression));
        builder.append("}");
        return new JavaSourceFromString(PACKAGE_NAME + "." + className, builder.toString());
    }

    private static String generateFilterMethodsSource(Set<AggregateClass> dataClasses, String filterExpression) {
        return dataClasses.stream().map(dataClass -> {
            StringBuilder builder = new StringBuilder();
            builder.append("public static boolean filter" + dataClass.getName() + "(AggregateObject aggregate) {");
            dataClass.getAttributeNames().forEach(attributeName -> {
                DataClass attributeType = dataClass.getAttributeType(attributeName);
                String getAttributeValueString = "aggregate.getAttributeValue(\"" + attributeName + "\")";
                String attributeTypeString = "DataObject";
                if (attributeType.isString()) {
                    attributeTypeString = "String";
                } else if (attributeType.isDouble()) {
                    attributeTypeString = "Double";
                } else if (attributeType.isInteger()) {
                    attributeTypeString = "Integer";
                }
                builder.append(attributeTypeString + " " + attributeName + " =  ");
                if (attributeType.isAtomic()) {
                    builder.append("(" + attributeTypeString + ") ((AtomicObject) " + getAttributeValueString + ").getNativeObject(); ");
                } else {
                    builder.append(attributeTypeString + " " + attributeName + " = aggregate.getAttributeValue(\"" + attributeName + "\"); ");
                }
            });
            builder.append("return " + filterExpression + ";");
            builder.append("}");
            return builder.toString();
        }).collect(Collectors.joining(" "));
    }

    static class JavaSourceFromString
    extends SimpleJavaFileObject {
        final String code;
        String className;

        JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.className = name;
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }

        public String getClassName() {
            return this.className;
        }

        public String getCode() {
            return this.code;
        }
    }
}

