/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.objectpooleditor;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.Model;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.data.object.base.CollectionObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.objectpool.ReadableObjectPool;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.FilterableObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProviderFactory;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.DataObjectEditorSaveable;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.FieldCopier;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import de.uni_trier.wi2.procake.gui.objecteditor.objectpooleditor.EditorActions;
import de.uni_trier.wi2.procake.gui.objecteditor.objectpooleditor.EditorMenuBar;
import de.uni_trier.wi2.procake.gui.objecteditor.objectpooleditor.PoolFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="3.0.0", forRemoval=true)
public class ObjectPoolEditor<T extends DataObject>
extends JFrame
implements TreeSelectionListener,
TreeModelListener {
    protected static final Logger logger = LoggerFactory.getLogger(ObjectPoolEditor.class);
    private static final Object windowCloseLock = new Object();
    private WriteableObjectPool<T> pool;
    private WriteableObjectPool<T> originalPool;
    private File currentFile;
    private JSplitPane mainSplitPane;
    private ObjectPoolJTree tree;

    public ObjectPoolEditor(FilterableObjectPoolTreeModel<T> treeModel) {
        this(treeModel.getRoot());
        this.setTreeModel(treeModel);
    }

    public ObjectPoolEditor(FilterableObjectPoolTreeModel<T> treeModel, TreePath selectionPath) {
        this(treeModel);
        this.tree.scrollPathToVisible(selectionPath);
        this.tree.setSelectionPath(selectionPath);
    }

    public ObjectPoolEditor(WriteableObjectPool<T> pool) {
        this(pool, false);
    }

    public ObjectPoolEditor(WriteableObjectPool<T> pool, boolean blockThreadUntilEditorWindowClosed) {
        this.setLookAndFeel();
        super.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/objecteditor/nestworkfloweditor/images/ProCAKE_Icon.png")));
        super.setDefaultCloseOperation(2);
        super.setLayout(new BorderLayout());
        super.setJMenuBar(new EditorMenuBar(this));
        this.tree = new ObjectPoolJTree();
        this.tree.addMouseListener(new TreeRightClickListener());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JPanel leftPanel = new JPanel(new BorderLayout());
        JScrollPane treeScrollPane = new JScrollPane();
        leftPanel.add((Component)treeScrollPane, "Center");
        leftPanel.setMinimumSize(new Dimension(250, 0));
        treeScrollPane.setViewportView(this.tree);
        this.mainSplitPane = new JSplitPane(1);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setLeftComponent(leftPanel);
        this.mainSplitPane.setDividerSize(12);
        this.add((Component)this.mainSplitPane, "Center");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new TreeSelectionPathBar(this.tree), "First");
        topPanel.add((Component)new PoolFilterBar(), "Last");
        this.add((Component)topPanel, "First");
        this.loadPool(pool);
        leftPanel.add((Component)new AddNewDataObjectToPoolPanel(), "Last");
        this.pack();
        this.setExtendedState(this.getExtendedState() | 6);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent arg0) {
                Object object = windowCloseLock;
                synchronized (object) {
                    ObjectPoolEditor.this.setVisible(false);
                    windowCloseLock.notify();
                }
            }
        });
        if (blockThreadUntilEditorWindowClosed) {
            this.waitUntilEditorWindowClosed();
        }
    }

    void writeChangesToOriginalPool() {
        FieldCopier.instance().copyFields(this.getPool(), this.getOriginalPool());
    }

    String getAppTitle() {
        return "ObjectPoolEditor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilEditorWindowClosed() {
        try {
            while (!this.isVisible()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object object = windowCloseLock;
        synchronized (object) {
            while (this.isVisible()) {
                try {
                    windowCloseLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setTreeModel(FilterableObjectPoolTreeModel<T> treeModel) {
        treeModel.addTreeModelListener(this);
        this.tree.setModel(treeModel);
    }

    public void loadPool(WriteableObjectPool<T> pool) {
        this.tree.getModel().removeTreeModelListener(this);
        this.originalPool = pool;
        this.pool = pool.copy();
        this.setTitle(pool.getId() + " - " + this.getAppTitle());
        FilterableObjectPoolTreeModel<T> newModel = new FilterableObjectPoolTreeModel<T>(this.pool);
        newModel.addTreeModelListener(this);
        this.tree.setModel(newModel);
        this.mainSplitPane.setRightComponent(new JPanel());
    }

    protected String getTreeNodeLabel(Object object) {
        try {
            if (object == null) {
                return "null";
            }
            if (object instanceof AtomicObject) {
                return this.getTreeNodeLabel((AtomicObject)object);
            }
            if (object instanceof AggregateObject) {
                return this.getTreeNodeLabel((AggregateObject)object);
            }
            if (object instanceof NESTWorkflowObject) {
                return this.getTreeNodeLabel((NESTWorkflowObject)object);
            }
            if (object instanceof Map.Entry) {
                return this.getTreeNodeLabel((Map.Entry)object);
            }
            if (object instanceof CollectionObject) {
                return this.getTreeNodeLabel((CollectionObject)object);
            }
            if (object instanceof NESTEdgeObject) {
                return this.getTreeNodeLabel((NESTEdgeObject)object);
            }
            if (object instanceof NESTNodeObject) {
                return this.getTreeNodeLabel((NESTNodeObject)object);
            }
            if (object instanceof ReadableObjectPool) {
                return this.getTreeNodeLabel((ReadableObjectPool)object);
            }
            if (object instanceof DataObject) {
                return this.getTreeNodeLabel((DataObject)object);
            }
        }
        catch (RuntimeException e) {
            logger.error("Could not get label for object: {}", object);
            logger.error("Exception: ", (Throwable)e);
        }
        return Objects.toString(object);
    }

    protected String getTreeNodeLabel(DataObject dataObject) {
        return dataObject.getId();
    }

    protected String getTreeNodeLabel(ReadableObjectPool<T> pool) {
        return pool.getId();
    }

    protected String getTreeNodeLabel(Map.Entry<String, Object> attribute) {
        return attribute.getKey() + " = " + this.getTreeNodeLabel(attribute.getValue());
    }

    protected String getTreeNodeLabel(AtomicObject atomicObject) {
        return atomicObject.getNativeObject().toString();
    }

    protected String getTreeNodeLabel(AggregateObject aggregateObject) {
        Object labelProvider = LabelProviderFactory.getProvider(aggregateObject.getDataClass());
        return labelProvider == null ? aggregateObject.getId() : ((LabelProvider)((Object)labelProvider)).getLabel((DataObject)aggregateObject);
    }

    protected String getTreeNodeLabel(CollectionObject collectionObject) {
        return collectionObject.getDataClass() + " of " + collectionObject.size() + " " + collectionObject.getCollectionClass().getElementClass().getName();
    }

    protected String getTreeNodeLabel(NESTEdgeObject nestEdgeObject) {
        return nestEdgeObject.getDataClass().getName() + ": " + nestEdgeObject.toString();
    }

    protected String getTreeNodeLabel(NESTNodeObject nestNodeObject) {
        return nestNodeObject.getDataClass().getName() + ": " + nestNodeObject.getId();
    }

    protected String getTreeNodeLabel(NESTWorkflowObject nestGraphObject) {
        return nestGraphObject.getId();
    }

    private JPanel createSaveableDataObjectEditorPanel(DataObject dataObject) {
        JPanel panel = new JPanel(new BorderLayout());
        DataObjectEditorSaveable dataObjectEditor = new DataObjectEditorSaveable(dataObject);
        panel.add((Component)dataObjectEditor, "Center");
        JButton saveButton = new JButton("Save changes");
        saveButton.addActionListener(e -> {
            dataObjectEditor.saveChanges();
            this.updateTreeView(this.tree.getSelectionPath().getPath());
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(saveButton);
        panel.add((Component)buttonPanel, "First");
        return panel;
    }

    void updateTreeView(Object[] path) {
        TreePath selectionPath = this.tree.getSelectionPath();
        ((ObjectPoolTreeModel)this.tree.getModel()).fireTreeStructureChanged(path);
        this.tree.scrollPathToVisible(selectionPath);
        this.tree.setSelectionPath(selectionPath);
    }

    void updateTreeView() {
        TreePath selectionPath = this.tree.getSelectionPath();
        ((ObjectPoolTreeModel)this.tree.getModel()).fireTreeStructureChanged(new Object[]{this.getPool()});
        this.tree.scrollPathToVisible(selectionPath);
        this.tree.setSelectionPath(selectionPath);
    }

    public void setLookAndFeel() {
        ObjectPoolEditor frame = this;
        if (frame != null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                Utils.setDefaultFontSize(11.5f);
                SwingUtilities.updateComponentTreeUI(frame);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        Object[] path = selectionPath.getPath();
        Object selectedElement = path[path.length - 1];
        DataObject dataObject = null;
        if (selectedElement instanceof DataObject) {
            dataObject = (DataObject)selectedElement;
        } else if (selectedElement instanceof Map.Entry && (dataObject = (DataObject)((Map.Entry)selectedElement).getValue()) == null) {
            this.mainSplitPane.setRightComponent(new JLabel("Creation and deletion of aggregate attributes have to be done in the editor of the corresponding aggregate object."));
            return;
        }
        if (dataObject != null) {
            if (dataObject.isNESTWorkflow()) {
                NESTWorkflowEditor nestGraphEditor = new NESTWorkflowEditor((NESTAbstractWorkflowObject)((NESTWorkflowObject)dataObject), true, false);
                nestGraphEditor.addGraphSaveListener(l -> this.updateTreeView());
                this.mainSplitPane.setRightComponent(nestGraphEditor);
            } else if (dataObject.isNESTEdge() || dataObject.isNESTNode()) {
                NESTGraphItemObject graphItemObject = (NESTGraphItemObject)dataObject;
                if (graphItemObject.getSemanticDescriptor() != null) {
                    this.mainSplitPane.setRightComponent(new JScrollPane(this.createSaveableDataObjectEditorPanel(graphItemObject.getSemanticDescriptor())));
                }
            } else {
                this.mainSplitPane.setRightComponent(new JScrollPane(this.createSaveableDataObjectEditorPanel(dataObject)));
            }
        } else {
            this.mainSplitPane.setRightComponent(new JLabel(""));
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File file) {
        this.currentFile = file;
        this.updateTitle();
    }

    public ObjectPoolJTree getTree() {
        return this.tree;
    }

    public WriteableObjectPool<? extends DataObject> getPool() {
        return this.pool;
    }

    public void setPool(WriteableObjectPool<T> pool) {
        this.pool = pool;
    }

    public WriteableObjectPool<T> getOriginalPool() {
        return this.originalPool;
    }

    public void setOriginalPool(WriteableObjectPool<T> originalPool) {
        this.originalPool = originalPool;
    }

    private void updateTitle() {
        this.setTitle(this.pool.getId() + (String)(this.currentFile != null ? " - file: " + this.currentFile.getAbsolutePath() : "") + " - " + this.getAppTitle());
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        Object[] changedPath = treeModelEvent.getPath();
        Object changedNode = changedPath[changedPath.length - 1];
        if (changedNode instanceof WriteableObjectPool) {
            return;
        }
        DataObject changedDataObject = changedNode instanceof Map.Entry ? (DataObject)((Map.Entry)changedNode).getValue() : (DataObject)changedNode;
        Object[] selectedPath = this.tree.getSelectionPath().getPath();
        Object selectedNode = this.tree.getSelectionPath().getLastPathComponent();
        if (!(selectedNode instanceof DataObject)) {
            return;
        }
        DataObject selectedDataObject = (DataObject)selectedNode;
        if (Arrays.stream(selectedPath).anyMatch(pathElement -> pathElement == changedDataObject) || Utils.containsChild(selectedDataObject, changedDataObject)) {
            this.valueChanged(null);
        }
    }

    class ObjectPoolJTree
    extends JTree {
        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return ObjectPoolEditor.this.getTreeNodeLabel(value);
        }
    }

    class TreeRightClickListener
    extends MouseAdapter {
        TreeRightClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            int clickedRow = ObjectPoolEditor.this.tree.getRowForLocation(e.getX(), e.getY());
            TreePath clickedPath = ObjectPoolEditor.this.tree.getPathForLocation(e.getX(), e.getY());
            if (clickedRow != -1) {
                ObjectPoolEditor.this.tree.setSelectionPath(clickedPath);
                this.createRightClickMenu(clickedPath).show(ObjectPoolEditor.this.tree, e.getX(), e.getY());
            }
        }

        private JPopupMenu createRightClickMenu(TreePath clickedPath) {
            Object clickedElement = clickedPath.getLastPathComponent();
            DataObject clickedDataObject = clickedElement instanceof Map.Entry ? (DataObject)((Map.Entry)clickedElement).getValue() : (clickedElement instanceof DataObject ? (DataObject)clickedElement : null);
            Object insertionParent = this.getCakeParentWithInsertionSupportFromTreePath(clickedPath.getPath());
            JPopupMenu menu = new JPopupMenu();
            if (clickedDataObject != null && (!(clickedDataObject instanceof NESTGraphItemObject) || clickedElement instanceof ReadableObjectPool)) {
                menu.add(new EditorActions.ExportAsAction(ObjectPoolEditor.this, () -> clickedElement));
            }
            if (insertionParent != null) {
                menu.add(new EditorActions.ReplaceWithDataObjectFromXMLFileAction(ObjectPoolEditor.this, clickedElement, insertionParent));
            }
            if (this.isValidInsertionTarget(clickedElement)) {
                menu.add(new EditorActions.AddDataObjectFromXMLFileAction(ObjectPoolEditor.this, clickedElement));
            }
            if (menu.getSubElements().length > 0) {
                menu.addSeparator();
            }
            if (clickedDataObject != null && !(clickedDataObject instanceof NESTGraphItemObject)) {
                menu.add(new EditorActions.StoreDataObjectInClipboardAction(clickedDataObject));
            }
            if (insertionParent != null) {
                menu.add(new EditorActions.ReplaceWithDataObjectFromClipboardAction(ObjectPoolEditor.this, clickedElement, insertionParent));
            }
            if (this.isValidInsertionTarget(clickedElement)) {
                menu.add(new EditorActions.AddDataObjectFromClipboardAction(ObjectPoolEditor.this, clickedElement));
            }
            if (clickedPath.getPathCount() == 2) {
                menu.addSeparator();
                menu.add(new EditorActions.DeleteDataObjectFromPoolAction(ObjectPoolEditor.this, (DataObject)clickedElement));
            }
            if (clickedDataObject != null) {
                if (menu.getSubElements().length > 0) {
                    menu.addSeparator();
                }
                menu.add(new EditorActions.SetDataObjectIdAction(ObjectPoolEditor.this, clickedDataObject));
            }
            return menu;
        }

        private boolean isValidInsertionTarget(Object target) {
            if (target instanceof Map.Entry) {
                target = ((Map.Entry)target).getValue();
            }
            return target instanceof WriteableObjectPool || target instanceof CollectionObject;
        }

        private Object getCakeParentWithInsertionSupportFromTreePath(Object[] treePath) {
            if (treePath.length > 1) {
                Object parentObject = treePath[treePath.length - 2];
                if (parentObject instanceof Map.Entry) {
                    parentObject = ((Map.Entry)parentObject).getValue();
                }
                if (parentObject instanceof NESTGraphItemObject) {
                    parentObject = ((NESTGraphItemObject)parentObject).getSemanticDescriptor();
                }
                if (parentObject instanceof CollectionObject || parentObject instanceof AggregateObject || parentObject instanceof WriteableObjectPool) {
                    return parentObject;
                }
            }
            return null;
        }
    }

    class TreeSelectionPathBar
    extends JPanel
    implements TreeSelectionListener {
        private ObjectPoolJTree tree;

        public TreeSelectionPathBar(ObjectPoolJTree tree) {
            this.tree = tree;
            this.setLayout(new FlowLayout(3));
            tree.addTreeSelectionListener(this);
            this.add(new JLabel(" "));
            JButton dummy = new JButton(" ");
            dummy.setMargin(new Insets(5, 2, 5, 2));
            dummy.setBorderPainted(false);
            dummy.setFocusPainted(false);
            this.add(dummy);
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath selectionPath = this.tree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            this.removeAll();
            for (int i = 0; i < selectionPath.getPathCount(); ++i) {
                JButton clickableLabel = new JButton(ObjectPoolEditor.this.getTreeNodeLabel(selectionPath.getPathComponent(i)));
                clickableLabel.setMargin(new Insets(5, 2, 5, 2));
                clickableLabel.setFocusPainted(false);
                clickableLabel.setBorderPainted(false);
                int finalI = i;
                clickableLabel.addActionListener(e -> {
                    TreePath path = new TreePath(Arrays.copyOfRange(selectionPath.getPath(), 0, finalI + 1));
                    this.tree.setSelectionPath(path);
                    this.tree.scrollPathToVisible(path);
                });
                this.add(clickableLabel);
                if (i >= selectionPath.getPathCount() - 1) continue;
                JLabel bracket = new JLabel("\u232a");
                Font font = bracket.getFont();
                bracket.setFont(font.deriveFont(font.getStyle() | 1));
                this.add(bracket);
            }
            this.revalidate();
            this.repaint();
        }
    }

    class PoolFilterBar
    extends JPanel {
        public PoolFilterBar() {
            this.setLayout(new BorderLayout());
            JTextField filterInput = new JTextField();
            JButton filterButton = new JButton("Filter: ");
            ActionListener filterAction = e -> {
                try {
                    filterInput.setBackground(Color.WHITE);
                    ((FilterableObjectPoolTreeModel)ObjectPoolEditor.this.tree.getModel()).setFilter(filterInput.getText().isEmpty() ? null : PoolFilter.getFilterClass(ObjectPoolEditor.this.pool, filterInput.getText()));
                    ObjectPoolEditor.this.updateTreeView();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    filterInput.setBackground(new Color(255, 170, 166));
                }
            };
            filterInput.addActionListener(filterAction);
            filterButton.addActionListener(filterAction);
            this.add((Component)filterButton, "Before");
            this.add((Component)filterInput, "Center");
        }
    }

    class AddNewDataObjectToPoolPanel
    extends JPanel {
        public AddNewDataObjectToPoolPanel() {
            super(new BorderLayout());
            Model model = ModelFactory.getDefaultModel();
            List possibleClasses = model.getClasses().stream().filter(DataClass::isInstantiable).collect(Collectors.toList());
            JComboBox<DataClass> newDataObjectClassSelector = new JComboBox<DataClass>((DataClass[])possibleClasses.toArray(DataClass[]::new));
            List mostTypeObjects = ObjectPoolEditor.this.pool.getCollection().stream().collect(Collectors.groupingBy(DataObject::getDataClass)).values().stream().max(Comparator.comparing(List::size)).orElse(new ArrayList());
            if (mostTypeObjects.size() > 0) {
                newDataObjectClassSelector.setSelectedItem(((DataObject)mostTypeObjects.iterator().next()).getDataClass());
            }
            newDataObjectClassSelector.setMinimumSize(new Dimension(0, newDataObjectClassSelector.getHeight()));
            this.add(newDataObjectClassSelector, "Center");
            JButton addButton = new JButton(new EditorActions.StoreNewDataObjectInPoolAction(ObjectPoolEditor.this, newDataObjectClassSelector));
            this.add((Component)addButton, "After");
        }
    }
}

