/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.objectpooleditor;

import com.mxgraph.util.mxResources;
import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.CollectionObject;
import de.uni_trier.wi2.procake.data.object.base.ListObject;
import de.uni_trier.wi2.procake.data.object.base.SetObject;
import de.uni_trier.wi2.procake.data.object.base.StringObject;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.FilterableObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.BasicGraphEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.DefaultFileFilter;
import de.uni_trier.wi2.procake.gui.objecteditor.objectpooleditor.ObjectPoolEditor;
import de.uni_trier.wi2.procake.utils.exception.ProCAKEInvalidTypeException;
import de.uni_trier.wi2.procake.utils.io.IOUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

@Deprecated(since="3.0.0", forRemoval=true)
public class EditorActions {

    public static class SaveInObjectAction
    extends AbstractAction {
        private ObjectPoolEditor editor;

        public SaveInObjectAction(ObjectPoolEditor editor) {
            super("Save", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/save.gif")));
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.editor.writeChangesToOriginalPool();
        }
    }

    public static class StoreNewDataObjectInPoolAction
    extends AbstractAction {
        private ObjectPoolEditor editor;
        private JComboBox<DataClass> newDataObjectClassSelector;

        public StoreNewDataObjectInPoolAction(ObjectPoolEditor editor, JComboBox<DataClass> newDataObjectClassSelector) {
            super("Add");
            this.editor = editor;
            this.newDataObjectClassSelector = newDataObjectClassSelector;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataClass selectedDataClass = (DataClass)this.newDataObjectClassSelector.getSelectedItem();
            DataObject newDataObject = selectedDataClass.newObject();
            this.editor.getPool().store(newDataObject);
            this.editor.updateTreeView();
            TreePath pathToNewObject = new TreePath(new Object[]{this.editor.getPool(), newDataObject});
            this.editor.getTree().scrollPathToVisible(pathToNewObject);
            this.editor.getTree().setSelectionPath(pathToNewObject);
        }
    }

    public static class OpenNewEditorWindowAction<T extends DataObject>
    extends AbstractAction {
        private ObjectPoolEditor<T> editor;

        public OpenNewEditorWindowAction(ObjectPoolEditor<T> editor) {
            super("Open new editor window");
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Constructor<?> constructor = this.editor.getClass().getDeclaredConstructor(WriteableObjectPool.class);
                constructor.setAccessible(true);
                ObjectPoolEditor newInstance = (ObjectPoolEditor)constructor.newInstance(this.editor.getPool());
                FilterableObjectPoolTreeModel model = (FilterableObjectPoolTreeModel)this.editor.getTree().getModel();
                newInstance.setTreeModel(model);
                model.addTreeModelListener(newInstance);
                newInstance.setPool(this.editor.getPool());
                newInstance.setOriginalPool(this.editor.getOriginalPool());
                TreePath selectionPath = this.editor.getTree().getSelectionPath();
                newInstance.getTree().scrollPathToVisible(selectionPath);
                newInstance.getTree().setSelectionPath(selectionPath);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                JOptionPane.showMessageDialog(this.editor, exception.toString(), mxResources.get((String)"error"), 0);
            }
        }
    }

    public static class ExportAsAction
    extends AbstractAction {
        protected String lastDir = null;
        private ObjectPoolEditor editor;
        private Supplier<Object> objectToSaveSupplier;

        public ExportAsAction(ObjectPoolEditor editor, Supplier<Object> objectToSaveSupplier) {
            super("Export to XML", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/saveas.gif")));
            this.editor = editor;
            this.objectToSaveSupplier = objectToSaveSupplier;
        }

        public ExportAsAction(ObjectPoolEditor editor) {
            this(editor, editor::getPool);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object filename;
            if (this.editor.getCurrentFile() == null) {
                String workingDir = this.lastDir != null ? this.lastDir : (this.editor.getCurrentFile() != null ? this.editor.getCurrentFile().getParent() : System.getProperty("user.dir"));
                JFileChooser fileChooser = new JFileChooser(workingDir);
                DefaultFileFilter defaultFileFilter = new DefaultFileFilter(".xml", "XML File (.xml)");
                fileChooser.addChoosableFileFilter(defaultFileFilter);
                fileChooser.setFileFilter(defaultFileFilter);
                int rc = fileChooser.showDialog(this.editor, "Save");
                if (rc != 0) {
                    return;
                }
                this.lastDir = fileChooser.getSelectedFile().getParent();
                filename = fileChooser.getSelectedFile().getAbsolutePath();
                FileFilter selectedFilter = fileChooser.getFileFilter();
                if (selectedFilter instanceof DefaultFileFilter) {
                    String ext = ((DefaultFileFilter)selectedFilter).getExtension();
                    if (!((String)filename).toLowerCase().endsWith(ext)) {
                        filename = (String)filename + ext;
                    }
                }
                if (new File((String)filename).exists() && JOptionPane.showConfirmDialog(this.editor, "Overwrite existing file?") != 0) {
                    return;
                }
            } else {
                filename = this.editor.getCurrentFile().getAbsolutePath();
            }
            try {
                boolean writeSuccess;
                boolean bl = writeSuccess = IOUtil.writeFile((Object)this.objectToSaveSupplier.get(), (String)filename) != null;
                if (!writeSuccess) {
                    throw new IOException("XML serialization failed. Check stacktrace for details.");
                }
                this.editor.setCurrentFile(new File((String)filename));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.editor, ex.toString(), "Error", 0);
            }
        }
    }

    public static class SetDataObjectIdAction
    extends AbstractAction {
        private DataObject dataObject;
        private ObjectPoolEditor editor;

        public SetDataObjectIdAction(ObjectPoolEditor editor, DataObject dataObject) {
            super("Set ID", null);
            this.dataObject = dataObject;
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String newId = JOptionPane.showInputDialog(this.editor, "Enter ID:", this.dataObject.getId());
            if (newId == null) {
                return;
            }
            if (newId.equals("")) {
                JOptionPane.showMessageDialog(this.editor, "Please enter an ID", "Error - empty ID", 0);
                this.actionPerformed(actionEvent);
            } else if (this.editor.getPool().getCollection().contains(this.dataObject)) {
                if (this.editor.getPool().getObject(newId) != this.dataObject && this.editor.getPool().getObject(newId) != null) {
                    JOptionPane.showMessageDialog(this.editor, "ID already in use", "Error - ID already in use", 0);
                    this.actionPerformed(actionEvent);
                } else {
                    this.editor.getPool().remove(this.dataObject);
                    this.dataObject.setId(newId);
                    this.editor.getPool().store(this.dataObject);
                    this.editor.updateTreeView();
                }
            } else {
                this.dataObject.setId(newId);
                this.editor.updateTreeView();
            }
        }
    }

    public static class DeleteDataObjectFromPoolAction
    extends AbstractAction {
        private DataObject objectToDelete;
        private WriteableObjectPool pool;
        private ObjectPoolEditor editor;

        public DeleteDataObjectFromPoolAction(ObjectPoolEditor editor, DataObject objectToDelete) {
            super("Delete", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/delete.gif")));
            this.pool = editor.getPool();
            this.objectToDelete = objectToDelete;
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.pool.remove(this.objectToDelete);
            this.editor.updateTreeView();
        }
    }

    public static class StoreDataObjectInClipboardAction
    extends AbstractAction {
        public static DataObject clipboardObject;
        private DataObject objectToStore;

        public StoreDataObjectInClipboardAction(DataObject dataObject) {
            super("Copy", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/copy.gif")));
            this.objectToStore = dataObject;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            clipboardObject = this.objectToStore.copy();
        }
    }

    public static class AddDataObjectFromClipboardAction
    extends AddDataObjectFromXMLFileAction {
        public AddDataObjectFromClipboardAction(ObjectPoolEditor editor, Object target) {
            super(editor, target);
            this.putValue("Name", "Add clipboard object");
            this.putValue("SmallIcon", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/paste.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StoreDataObjectInClipboardAction.clipboardObject == null) {
                JOptionPane.showMessageDialog(this.editor, "Clipboard is empty.", "Error", 0);
            } else {
                this.consumeLoadedDataObject(StoreDataObjectInClipboardAction.clipboardObject.copy());
            }
        }
    }

    public static class AddDataObjectFromXMLFileAction
    extends LoadDataObjectFromXMLFileAction {
        public AddDataObjectFromXMLFileAction(ObjectPoolEditor editor, Object target) {
            super(editor, "Add from XML import", target, null);
        }

        @Override
        void consumeLoadedDataObject(DataObject dataObject) {
            if (this.target instanceof Map.Entry) {
                this.target = ((Map.Entry)this.target).getValue();
            }
            try {
                if (this.target instanceof WriteableObjectPool) {
                    WriteableObjectPool targetPool = (WriteableObjectPool)this.target;
                    try {
                        targetPool.store(dataObject);
                    }
                    catch (RuntimeException e) {
                        dataObject.setId(null);
                        targetPool.store(dataObject);
                    }
                } else if (this.target instanceof CollectionObject) {
                    CollectionObject targetCollection = (CollectionObject)this.target;
                    targetCollection.addValue(dataObject);
                } else {
                    throw new ProCAKEInvalidTypeException("Invalid target object. Only collections and pools are supported.", new String[]{this.target.toString(), dataObject.getId()});
                }
                this.editor.updateTreeView();
            }
            catch (ProCAKEInvalidTypeException e) {
                JOptionPane.showMessageDialog(this.editor, "Import failed due to invalid type of data object.", "Error", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.editor, "Import failed: " + e.getMessage(), "Error", 0);
            }
        }
    }

    public static class ReplaceWithDataObjectFromClipboardAction
    extends ReplaceWithDataObjectFromXMLFileAction {
        public ReplaceWithDataObjectFromClipboardAction(ObjectPoolEditor editor, Object target, Object parent) {
            super(editor, target, parent);
            this.putValue("Name", "Replace by clipboard object");
            this.putValue("SmallIcon", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/paste.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StoreDataObjectInClipboardAction.clipboardObject == null) {
                JOptionPane.showMessageDialog(this.editor, "Clipboard is empty.", "Error", 0);
            } else {
                this.consumeLoadedDataObject(StoreDataObjectInClipboardAction.clipboardObject.copy());
            }
        }
    }

    public static class ReplaceWithDataObjectFromXMLFileAction
    extends LoadDataObjectFromXMLFileAction {
        public ReplaceWithDataObjectFromXMLFileAction(ObjectPoolEditor editor, Object target, Object parent) {
            super(editor, "Replace by XML import", target, parent);
        }

        @Override
        void consumeLoadedDataObject(DataObject dataObject) {
            try {
                if (this.parent instanceof WriteableObjectPool) {
                    WriteableObjectPool parentPool = (WriteableObjectPool)this.parent;
                    parentPool.remove((DataObject)this.target);
                    try {
                        parentPool.store(dataObject);
                    }
                    catch (RuntimeException e) {
                        dataObject.setId(null);
                        parentPool.store(dataObject);
                    }
                } else if (this.parent instanceof SetObject) {
                    SetObject parentSet = (SetObject)this.parent;
                    parentSet.removeValue((DataObject)this.target);
                    parentSet.addValue(dataObject);
                } else if (this.parent instanceof ListObject) {
                    ListObject parentList = (ListObject)this.parent;
                    parentList.insertAt(dataObject, parentList.indexOf((DataObject)this.target));
                    parentList.removeValue((DataObject)this.target);
                } else if (this.parent instanceof AggregateObject) {
                    AggregateObject parentAggregate = (AggregateObject)this.parent;
                    Map.Entry target = (Map.Entry)this.target;
                    if (parentAggregate.getAggregateClass().getAttributeType((String)target.getKey()) == ModelFactory.getDefaultModel().getStringSystemClass()) {
                        StringObject stringObject = (StringObject)ModelFactory.getDefaultModel().getStringSystemClass().newObject();
                        stringObject.setNativeString(((StringObject)dataObject).getNativeString());
                        parentAggregate.setAttributeValue((String)target.getKey(), (DataObject)stringObject);
                    } else {
                        parentAggregate.setAttributeValue((String)target.getKey(), dataObject);
                    }
                } else {
                    throw new ProCAKEInvalidTypeException("Invalid parent type. Only collections, pools and aggregates are supported.", new String[]{this.target.toString(), dataObject.getId()});
                }
                this.editor.updateTreeView();
            }
            catch (ProCAKEInvalidTypeException e) {
                JOptionPane.showMessageDialog(this.editor, "Import failed due to invalid type of data object.", "Error", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.editor, "Import failed: " + e.getMessage(), "Error", 0);
            }
        }
    }

    public static abstract class LoadDataObjectFromXMLFileAction
    extends OpenXMLFileAction {
        static String lastDirPath;
        Object target;
        Object parent;

        public LoadDataObjectFromXMLFileAction(ObjectPoolEditor editor, String actionTitle, Object target, Object parent) {
            super(lastDirPath, actionTitle);
            this.target = target;
            this.parent = parent;
            this.editor = editor;
        }

        @Override
        void consumeSelectedFile(File selectedFile) {
            Object parsedObject = IOUtil.readFile((String)selectedFile.getAbsolutePath(), (String)"ObjectSaxParser");
            if (!(parsedObject instanceof DataObject)) {
                JOptionPane.showMessageDialog(this.editor, "Chosen file does not contain a data object definition or the definition is invalid for the current CakeInstance.", "Error", 0);
            } else {
                lastDirPath = selectedFile.getAbsolutePath();
                this.consumeLoadedDataObject((DataObject)parsedObject);
                this.editor.updateTreeView();
            }
        }

        abstract void consumeLoadedDataObject(DataObject var1);
    }

    public static class OpenPoolXMLFileAction
    extends OpenXMLFileAction {
        public OpenPoolXMLFileAction(ObjectPoolEditor editor) {
            super(editor);
        }

        @Override
        void consumeSelectedFile(File selectedFile) {
            Object parsedObject = IOUtil.readFile((String)selectedFile.getAbsolutePath(), (String)"ObjectPoolParser");
            if (!(parsedObject instanceof WriteableObjectPool)) {
                JOptionPane.showMessageDialog(this.editor, "Chosen file does not contain a pool definition or the definition is invalid for the current CakeInstance.", "Error", 0);
            } else {
                this.editor.setCurrentFile(selectedFile);
                this.editor.loadPool((WriteableObjectPool)parsedObject);
            }
        }
    }

    public static abstract class OpenXMLFileAction
    extends AbstractAction {
        protected String lastDir;
        protected ObjectPoolEditor editor;

        public OpenXMLFileAction(String lastDir, String actionTitle) {
            super(actionTitle, new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/open.gif")));
            this.lastDir = lastDir;
        }

        public OpenXMLFileAction(String lastDir) {
            this(lastDir, "Open File");
        }

        public OpenXMLFileAction(ObjectPoolEditor editor) {
            this(editor.getCurrentFile() != null ? editor.getCurrentFile().getAbsolutePath() : null);
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
            JFileChooser fc = new JFileChooser(wd);
            DefaultFileFilter defaultFilter = new DefaultFileFilter(".xml", "XML File (.xml)");
            fc.addChoosableFileFilter(defaultFilter);
            fc.setFileFilter(defaultFilter);
            int rc = fc.showDialog(null, "Open File");
            if (rc == 0) {
                this.lastDir = fc.getSelectedFile().getParent();
                this.consumeSelectedFile(fc.getSelectedFile());
            }
        }

        abstract void consumeSelectedFile(File var1);
    }

    public static class RefreshObjectPoolAction
    extends AbstractAction {
        private ObjectPoolEditor editor;

        public RefreshObjectPoolAction(ObjectPoolEditor editor) {
            super("Reload ObjectPool from reference");
            this.putValue("ShortDescription", "<html><p width='300'>Copies the ObjectPool from the reference given on instantiation of the editor and loads this copy into the editor. Be aware that any unsaved changes made to the pool will be lost.</p></html>");
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(() -> this.editor.loadPool(this.editor.getOriginalPool()));
        }
    }
}

