/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.mxgraph;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxStencilShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class mxSvgCanvasWithStencilSupport
extends mxSvgCanvas {
    public mxSvgCanvasWithStencilSupport(Document svgDocument) {
        super(svgDocument);
    }

    public Element drawShape(int x, int y, int w, int h, Map<String, Object> style) {
        mxIShape shape = new mxGraphics2DCanvas().getShape(style);
        if (shape instanceof mxStencilShape) {
            String fillColor = mxUtils.getString(style, (String)mxConstants.STYLE_FILLCOLOR, (String)"none");
            String gradientColor = mxUtils.getString(style, (String)mxConstants.STYLE_GRADIENTCOLOR, (String)"none");
            float opacity = mxUtils.getFloat(style, (String)mxConstants.STYLE_OPACITY, (float)100.0f);
            float fillOpacity = mxUtils.getFloat(style, (String)mxConstants.STYLE_FILL_OPACITY, (float)100.0f);
            float strokeOpacity = mxUtils.getFloat(style, (String)mxConstants.STYLE_STROKE_OPACITY, (float)100.0f);
            mxStencilShape stencilShape = (mxStencilShape)shape;
            double widthRatio = (double)w / stencilShape.getBoundingBox().getWidth();
            double heightRatio = (double)h / stencilShape.getBoundingBox().getHeight();
            try {
                Field rootField = mxStencilShape.class.getDeclaredField("root");
                rootField.setAccessible(true);
                Node root = (Node)rootField.get(shape);
                Element elem = this.document.createElement("g");
                Node backgroundNode = this.getBackgroundElement(root);
                Element background = null;
                elem.setAttribute("transform", "translate(" + x + ", " + y + ") scale(" + widthRatio + ", " + heightRatio + ")");
                NodeList childNodes = root.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = this.document.importNode(childNodes.item(i), true);
                    if (childNodes.item(i) == backgroundNode) {
                        background = (Element)childNode;
                    }
                    elem.appendChild(childNode);
                }
                double rotation = mxUtils.getDouble(style, (String)mxConstants.STYLE_ROTATION);
                int cx = x + w / 2;
                int cy = y + h / 2;
                Element bg = background;
                if (bg == null) {
                    bg = elem;
                }
                if (!bg.getNodeName().equalsIgnoreCase("use") && !bg.getNodeName().equalsIgnoreCase("image")) {
                    if (!fillColor.equalsIgnoreCase("none") && !gradientColor.equalsIgnoreCase("none")) {
                        String direction = mxUtils.getString(style, (String)mxConstants.STYLE_GRADIENT_DIRECTION);
                        Element gradient = this.getGradientElement(fillColor, gradientColor, direction);
                        if (gradient != null) {
                            bg.setAttribute("fill", "url(#" + gradient.getAttribute("id") + ")");
                        }
                    } else {
                        bg.setAttribute("fill", fillColor);
                    }
                    Element shadowElement = null;
                    if (mxUtils.isTrue(style, (String)mxConstants.STYLE_SHADOW, (boolean)false) && !fillColor.equals("none")) {
                        shadowElement = (Element)bg.cloneNode(true);
                        shadowElement.setAttribute("transform", mxConstants.SVG_SHADOWTRANSFORM);
                        shadowElement.setAttribute("fill", mxConstants.W3C_SHADOWCOLOR);
                        shadowElement.setAttribute("stroke", mxConstants.W3C_SHADOWCOLOR);
                        if (rotation != 0.0) {
                            shadowElement.setAttribute("transform", "rotate(" + rotation + "," + cx + "," + cy + ") " + mxConstants.SVG_SHADOWTRANSFORM);
                        }
                        if (opacity != 100.0f) {
                            String value = String.valueOf(opacity / 100.0f);
                            shadowElement.setAttribute("fill-opacity", value);
                            shadowElement.setAttribute("stroke-opacity", value);
                        }
                        this.appendSvgElement(shadowElement);
                    }
                }
                if (rotation != 0.0) {
                    elem.setAttribute("transform", elem.getAttribute("transform") + " rotate(" + rotation + "," + cx + "," + cy + ")");
                }
                if (opacity != 100.0f || fillOpacity != 100.0f || strokeOpacity != 100.0f) {
                    String fillValue = String.valueOf(opacity * fillOpacity / 10000.0f);
                    String strokeValue = String.valueOf(opacity * strokeOpacity / 10000.0f);
                    elem.setAttribute("fill-opacity", fillValue);
                    elem.setAttribute("stroke-opacity", strokeValue);
                }
                if (mxUtils.isTrue(style, (String)mxConstants.STYLE_DASHED)) {
                    String pattern = mxUtils.getString(style, (String)mxConstants.STYLE_DASH_PATTERN, (String)"3, 3");
                    elem.setAttribute("stroke-dasharray", pattern);
                }
                this.appendSvgElement(elem);
                return elem;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return super.drawShape(x, y, w, h, style);
    }

    private Node getBackgroundElement(Node root) {
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("svg:path") && !child.getNodeName().equals("path") && !child.getNodeName().equals("svg:polygon") && !child.getNodeName().equals("polygon")) continue;
            return child;
        }
        return null;
    }

    public Element drawLine(List<mxPoint> pts, Map<String, Object> style) {
        if (pts.size() >= 2) {
            mxPoint firstPoint = pts.get(0);
            mxPoint secondPoint = pts.get(1);
            if ((int)firstPoint.getX() == (int)secondPoint.getX() && (int)firstPoint.getY() == (int)secondPoint.getY()) {
                pts.remove(1);
            }
        }
        if (pts.size() >= 2) {
            mxPoint lastPoint = pts.get(pts.size() - 1);
            mxPoint nextToLastPoint = pts.get(pts.size() - 2);
            if ((int)lastPoint.getX() == (int)nextToLastPoint.getX() && (int)lastPoint.getY() == (int)nextToLastPoint.getY()) {
                pts.remove(pts.size() - 2);
            }
        }
        return super.drawLine(pts, style);
    }

    public Object drawText(String text, int x, int y, int w, int h, Map<String, Object> style) {
        Element elem = null;
        String fontColor = mxUtils.getString(style, (String)mxConstants.STYLE_FONTCOLOR, (String)"black");
        String fontFamily = mxUtils.getString(style, (String)mxConstants.STYLE_FONTFAMILY, (String)mxConstants.DEFAULT_FONTFAMILIES);
        int fontSize = (int)((double)mxUtils.getInt(style, (String)mxConstants.STYLE_FONTSIZE, (int)mxConstants.DEFAULT_FONTSIZE) * this.scale);
        if (text != null && text.length() > 0) {
            float strokeWidth = (float)((double)mxUtils.getFloat(style, (String)mxConstants.STYLE_STROKEWIDTH, (float)1.0f) * this.scale);
            float opacity = mxUtils.getFloat(style, (String)mxConstants.STYLE_TEXT_OPACITY, (float)100.0f);
            String bg = mxUtils.getString(style, (String)mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
            String border = mxUtils.getString(style, (String)mxConstants.STYLE_LABEL_BORDERCOLOR);
            String transform = null;
            if (!mxUtils.isTrue(style, (String)mxConstants.STYLE_HORIZONTAL, (boolean)true)) {
                double cx = x + w / 2;
                double cy = y + h / 2;
                transform = "rotate(270 " + cx + " " + cy + ")";
            }
            if (bg != null || border != null) {
                Element background = this.document.createElement("rect");
                background.setAttribute("x", String.valueOf(x));
                background.setAttribute("y", String.valueOf(y));
                background.setAttribute("width", String.valueOf(w));
                background.setAttribute("height", String.valueOf(h));
                if (bg != null) {
                    background.setAttribute("fill", bg);
                } else {
                    background.setAttribute("fill", "none");
                }
                if (border != null) {
                    background.setAttribute("stroke", border);
                } else {
                    background.setAttribute("stroke", "none");
                }
                background.setAttribute("stroke-width", String.valueOf(strokeWidth));
                if (opacity != 100.0f) {
                    String value = String.valueOf(opacity / 100.0f);
                    background.setAttribute("fill-opacity", value);
                    background.setAttribute("stroke-opacity", value);
                }
                if (transform != null) {
                    background.setAttribute("transform", transform);
                }
                this.appendSvgElement(background);
            }
            elem = this.document.createElement("text");
            int fontStyle = mxUtils.getInt(style, (String)mxConstants.STYLE_FONTSTYLE);
            String weight = (fontStyle & 1) == 1 ? "bold" : "normal";
            elem.setAttribute("font-weight", weight);
            String uline = (fontStyle & 4) == 4 ? "underline" : "none";
            elem.setAttribute("font-decoration", uline);
            if ((fontStyle & 2) == 2) {
                elem.setAttribute("font-style", "italic");
            }
            elem.setAttribute("font-size", String.valueOf(fontSize));
            elem.setAttribute("font-family", fontFamily);
            elem.setAttribute("fill", fontColor);
            if (opacity != 100.0f) {
                String value = String.valueOf(opacity / 100.0f);
                elem.setAttribute("fill-opacity", value);
                elem.setAttribute("stroke-opacity", value);
            }
            int swingFontStyle = (fontStyle & 1) == 1 ? 1 : 0;
            swingFontStyle += (fontStyle & 2) == 2 ? 2 : 0;
            String[] lines = text.split("\n");
            y += fontSize + (h - lines.length * (fontSize + mxConstants.LINESPACING)) / 2 - 2;
            String align = mxUtils.getString(style, (String)mxConstants.STYLE_ALIGN, (String)"center");
            String anchor = "start";
            if (align.equals("right")) {
                anchor = "end";
                x = (int)((double)x + ((double)w - (double)mxConstants.LABEL_INSET * this.scale));
            } else if (align.equals("center")) {
                anchor = "middle";
                x += w / 2;
            } else {
                x = (int)((double)x + (double)mxConstants.LABEL_INSET * this.scale);
            }
            elem.setAttribute("text-anchor", anchor);
            for (int i = 0; i < lines.length; ++i) {
                Element tspan = this.document.createElement("tspan");
                tspan.setAttribute("x", String.valueOf(x));
                tspan.setAttribute("y", String.valueOf(y));
                tspan.setAttribute("xml:space", "preserve");
                tspan.appendChild(this.document.createTextNode(lines[i]));
                elem.appendChild(tspan);
                y += fontSize + mxConstants.LINESPACING;
            }
            if (transform != null) {
                elem.setAttribute("transform", transform);
            }
            this.appendSvgElement(elem);
        }
        return elem;
    }
}

