/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.model.mxICell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import de.uni_trier.wi2.procake.data.model.nest.NESTWorkflowClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.BasicGraphEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorActions;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;

public class EditorToolBar
extends JToolBar {
    private static final long serialVersionUID = -8015443128436394471L;
    private boolean ignoreZoomChange = false;

    public EditorToolBar(int orientation) {
        super(orientation);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15), this.getBorder()));
        this.setFloatable(false);
    }

    public EditorToolBar(final BasicGraphEditor editor, int orientation) {
        super(orientation);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 4, 3), this.getBorder()));
        this.setFloatable(false);
        if (!editor.frameless) {
            Action newAction = editor.bind("New", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            }, "/objecteditor/nestworkfloweditor/images/new.gif");
            newAction.putValue("ShortDescription", mxResources.get((String)"newNESTWorkflow"));
            JButton newNESTWorkflowButton = this.add(newAction);
            newNESTWorkflowButton.addActionListener(e -> {
                JPopupMenu nestWorkflowClassSelectionMenu = new JPopupMenu();
                Utils.getNESTWorkflowClasses().forEach(nestWorkflowClass -> nestWorkflowClassSelectionMenu.add(editor.bind(nestWorkflowClass.getName(), new EditorActions.NewNESTWorkflowAction((NESTWorkflowClass)nestWorkflowClass))));
                nestWorkflowClassSelectionMenu.show(newNESTWorkflowButton, newNESTWorkflowButton.getWidth(), 0);
            });
            this.add(editor.bind("Open", new EditorActions.OpenAction(), "/objecteditor/nestworkfloweditor/images/open.gif"));
        }
        this.add(editor.bind("Save", new EditorActions.SaveInObjectAction(), "/objecteditor/nestworkfloweditor/images/save.gif"));
        this.add(editor.bind(mxResources.get((String)"exportAs"), new EditorActions.ExportAsAction(true), "/objecteditor/nestworkfloweditor/images/saveas.gif"));
        this.addSeparator();
        this.add(editor.bind("Print", new EditorActions.PrintAction(), "/objecteditor/nestworkfloweditor/images/print.gif"));
        this.addSeparator();
        Action copyAction = editor.bind("Copy", TransferHandler.getCopyAction(), "/objecteditor/nestworkfloweditor/images/copy.gif");
        copyAction.putValue("ShortDescription", mxResources.get((String)"copy"));
        final JButton copyButton = this.add(copyAction);
        copyButton.setEnabled(false);
        editor.getGraphComponent().getGraph().getSelectionModel().addListener("change", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                copyButton.setEnabled(Arrays.stream(editor.getGraphComponent().getGraph().getSelectionModel().getCells()).map(mxICell.class::cast).map(mxICell::getValue).filter(NESTGraphItemObject.class::isInstance).map(NESTGraphItemObject.class::cast).anyMatch(DataObject::isNESTNode));
            }
        });
        Action pasteAction = editor.bind("Paste", TransferHandler.getPasteAction(), "/objecteditor/nestworkfloweditor/images/paste.gif");
        pasteAction.putValue("ShortDescription", mxResources.get((String)"paste"));
        this.add(pasteAction);
        this.addSeparator();
        Action deleteAction = editor.bind("Delete", mxGraphActions.getDeleteAction(), "/objecteditor/nestworkfloweditor/images/delete.gif");
        deleteAction.putValue("ShortDescription", mxResources.get((String)"delete"));
        this.add(deleteAction);
        this.addSeparator();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<String> fonts = new ArrayList<String>();
        fonts.addAll(Arrays.asList("Helvetica", "Verdana", "Times New Roman", "Garamond", "Courier New", "-"));
        fonts.addAll(Arrays.asList(env.getAvailableFontFamilyNames()));
        final JComboBox<Object> fontCombo = new JComboBox<Object>(fonts.toArray());
        fontCombo.setEditable(true);
        fontCombo.setMinimumSize(new Dimension(120, 0));
        fontCombo.setPreferredSize(new Dimension(120, 0));
        fontCombo.setMaximumSize(new Dimension(120, 100));
        this.add(fontCombo);
        fontCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String font = fontCombo.getSelectedItem().toString();
                if (font != null && !font.equals("-")) {
                    mxGraph graph = editor.getGraphComponent().getGraph();
                    graph.setCellStyles(mxConstants.STYLE_FONTFAMILY, font);
                }
            }
        });
        final JComboBox<Object> sizeCombo = new JComboBox<Object>(new Object[]{"6pt", "8pt", "9pt", "10pt", "12pt", "14pt", "18pt", "24pt", "30pt", "36pt", "48pt", "60pt"});
        sizeCombo.setEditable(true);
        sizeCombo.setMinimumSize(new Dimension(65, 0));
        sizeCombo.setPreferredSize(new Dimension(65, 0));
        sizeCombo.setMaximumSize(new Dimension(65, 100));
        this.add(sizeCombo);
        sizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mxGraph graph = editor.getGraphComponent().getGraph();
                graph.setCellStyles(mxConstants.STYLE_FONTSIZE, sizeCombo.getSelectedItem().toString().replace("pt", ""));
            }
        });
        this.addSeparator();
        this.add(editor.bind("Bold", new EditorActions.FontStyleAction(true), "/objecteditor/nestworkfloweditor/images/bold.gif"));
        this.add(editor.bind("Italic", new EditorActions.FontStyleAction(false), "/objecteditor/nestworkfloweditor/images/italic.gif"));
        this.addSeparator();
        this.add(editor.bind("Left", new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "left"), "/objecteditor/nestworkfloweditor/images/left.gif"));
        this.add(editor.bind("Center", new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "center"), "/objecteditor/nestworkfloweditor/images/center.gif"));
        this.add(editor.bind("Right", new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "right"), "/objecteditor/nestworkfloweditor/images/right.gif"));
        this.addSeparator();
        this.add(editor.bind("Font", new EditorActions.ColorAction("Font", mxConstants.STYLE_FONTCOLOR), "/objecteditor/nestworkfloweditor/images/fontcolor.gif"));
        this.add(editor.bind("Stroke", new EditorActions.ColorAction("Stroke", mxConstants.STYLE_STROKECOLOR), "/objecteditor/nestworkfloweditor/images/linecolor.gif"));
        this.add(editor.bind("Fill", new EditorActions.ColorAction("Fill", mxConstants.STYLE_FILLCOLOR), "/objecteditor/nestworkfloweditor/images/fillcolor.gif"));
        this.addSeparator();
        final mxGraphView view = editor.getGraphComponent().getGraph().getView();
        final JComboBox<Object> zoomCombo = new JComboBox<Object>(new Object[]{"400%", "200%", "150%", "100%", "75%", "50%", mxResources.get((String)"page"), mxResources.get((String)"width"), mxResources.get((String)"actualSize")});
        zoomCombo.setEditable(true);
        zoomCombo.setMinimumSize(new Dimension(75, 0));
        zoomCombo.setPreferredSize(new Dimension(75, 0));
        zoomCombo.setMaximumSize(new Dimension(75, 100));
        zoomCombo.setMaximumRowCount(9);
        this.add(zoomCombo);
        mxEventSource.mxIEventListener scaleTracker = new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                EditorToolBar.this.ignoreZoomChange = true;
                try {
                    zoomCombo.setSelectedItem((int)Math.round(100.0 * view.getScale()) + "%");
                }
                finally {
                    EditorToolBar.this.ignoreZoomChange = false;
                }
            }
        };
        view.getGraph().getView().addListener("scale", scaleTracker);
        view.getGraph().getView().addListener("scaleAndTranslate", scaleTracker);
        scaleTracker.invoke(null, null);
        zoomCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mxGraphComponent graphComponent = editor.getGraphComponent();
                if (!EditorToolBar.this.ignoreZoomChange) {
                    String zoom = zoomCombo.getSelectedItem().toString();
                    if (zoom.equals(mxResources.get((String)"page"))) {
                        graphComponent.setPageVisible(true);
                        graphComponent.setZoomPolicy(1);
                    } else if (zoom.equals(mxResources.get((String)"width"))) {
                        graphComponent.setPageVisible(true);
                        graphComponent.setZoomPolicy(2);
                    } else if (zoom.equals(mxResources.get((String)"actualSize"))) {
                        graphComponent.zoomActual();
                    } else {
                        try {
                            zoom = zoom.replace("%", "");
                            double scale = Math.min(16.0, Math.max(0.01, Double.parseDouble(zoom) / 100.0));
                            graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(editor, ex.getMessage());
                        }
                    }
                }
            }
        });
    }
}

