/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.util.mxResources;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorActions;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.BasicGridLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.misc.DocumentAdapter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorControlsPanel
extends JPanel {
    protected static final Logger logger = LoggerFactory.getLogger(EditorControlsPanel.class);
    private NESTWorkflowEditor.CustomGraph graph;
    private NESTWorkflowLayout layout;

    public EditorControlsPanel(NESTWorkflowEditor.CustomGraph graph) {
        this.graph = graph;
        this.layout = graph.getLayout();
        this.setBorder(new EmptyBorder(10, 10, 0, 0));
        this.setLayout(new BasicGridLayout(0, 1, 2, 10));
        this.addNodeVisibilitySection();
        this.addLayoutConfigSection();
        this.addCellLabelsSection();
        this.addMiscSection();
    }

    private void addNodeVisibilitySection() {
        this.add(new JLabel("<html><b>Node visibility</b></html>"));
        this.add(new JSeparator(0));
        this.add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleWorkflowNodeVisibilityAction.class)));
        this.add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleDataNodeVisibilityAction.class)));
        this.add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleSequenceNodeVisibilityAction.class)));
        this.add(new JLabel("<html><b> </b></html>"));
    }

    private void addLayoutConfigSection() {
        JLabel spacer = new JLabel("");
        spacer.setBorder(new EmptyBorder(0, 15, 0, 0));
        this.add(new JLabel("<html><b>Layout configuration</b></html>"));
        this.add(new JSeparator(0));
        JPanel routeDataflowEdges = new JPanel(new BasicGridLayout(2, 1));
        JPanel indent = new JPanel(new BasicGridLayout(1, 2));
        indent.add(spacer);
        JPanel routedEdgesParametersPanel = new JPanel(new BasicGridLayout(2, 2));
        JLabel label = new JLabel("Edge to edge spacing: ");
        label.setToolTipText(mxResources.get((String)"dataflowEdgeToEdgeSpacingTooltip"));
        label.setBorder(new EmptyBorder(0, 15, 0, 0));
        routedEdgesParametersPanel.add(label);
        final JTextField idealNudgingDistanceInput = new JTextField(2);
        idealNudgingDistanceInput.setText("" + this.layout.getLayoutConfig().getIdealNudgingDistance());
        idealNudgingDistanceInput.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                try {
                    EditorControlsPanel.this.graph.getLayout().getLayoutConfig().setIdealNudgingDistance(Integer.parseInt(idealNudgingDistanceInput.getText()));
                }
                catch (NumberFormatException exception) {
                    logger.error("Number format error", (Throwable)exception);
                }
            }
        });
        routedEdgesParametersPanel.add(idealNudgingDistanceInput);
        label = new JLabel("Edge to node spacing: ");
        label.setToolTipText(mxResources.get((String)"dataflowEdgeToNodeSpacingTooltip"));
        label.setBorder(new EmptyBorder(0, 15, 0, 0));
        routedEdgesParametersPanel.add(label);
        final JTextField shapeBufferDistanceInput = new JTextField(2);
        shapeBufferDistanceInput.setText("" + this.layout.getLayoutConfig().getShapeBufferDistance());
        shapeBufferDistanceInput.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                try {
                    EditorControlsPanel.this.graph.getLayout().getLayoutConfig().setShapeBufferDistance(Integer.parseInt(shapeBufferDistanceInput.getText()));
                }
                catch (NumberFormatException exception) {
                    logger.error("Number format error", (Throwable)exception);
                }
            }
        });
        routedEdgesParametersPanel.add(shapeBufferDistanceInput);
        indent.add(routedEdgesParametersPanel);
        routeDataflowEdges.add(indent);
        this.add(routeDataflowEdges);
        JPanel placeDataNodesNearTaskNodes = new JPanel(new BasicGridLayout(2, 1));
        JCheckBox dataNodesNearTaskNodesCheckBox = new JCheckBox("<html><p style ='font-size:0.9583em'>Place data nodes vertically close <br>to their task nodes</p></html>");
        dataNodesNearTaskNodesCheckBox.setToolTipText(mxResources.get((String)"dataNodesCloseToTaskNodesTooltip"));
        dataNodesNearTaskNodesCheckBox.setSelected(this.layout.getLayoutConfig().isPlaceDataNodesVerticallyNearTaskNodes());
        dataNodesNearTaskNodesCheckBox.addActionListener(e -> this.graph.getLayout().getLayoutConfig().setPlaceDataNodesVerticallyNearTaskNodes(dataNodesNearTaskNodesCheckBox.isSelected()));
        placeDataNodesNearTaskNodes.add(dataNodesNearTaskNodesCheckBox);
        JPanel indent2 = new JPanel(new BasicGridLayout(0, 2));
        indent2.add(spacer);
        JCheckBox alsoPlaceAboveTaskNodesCheckBox = new JCheckBox("Additionally place above task nodes");
        alsoPlaceAboveTaskNodesCheckBox.setToolTipText(mxResources.get((String)"additionallyPlaceDataNodesAboveTaskNodesTooltip"));
        alsoPlaceAboveTaskNodesCheckBox.setSelected(this.layout.getLayoutConfig().isAlsoPlaceDataNodesAboveTaskNodes());
        alsoPlaceAboveTaskNodesCheckBox.addActionListener(e -> this.graph.getLayout().getLayoutConfig().setAlsoPlaceDataNodesAboveTaskNodes(alsoPlaceAboveTaskNodesCheckBox.isSelected()));
        indent2.add(alsoPlaceAboveTaskNodesCheckBox);
        placeDataNodesNearTaskNodes.add(indent2);
        this.add(placeDataNodesNearTaskNodes);
        JPanel layoutParametersPanel = new JPanel(new BasicGridLayout(2, 2));
        JLabel sequenceNodeVerticalSpacing = new JLabel("Vertical spacing for seq. nodes: ");
        layoutParametersPanel.add(sequenceNodeVerticalSpacing);
        final JTextField sequenceNodeVerticalSpacingInput = new JTextField(2);
        sequenceNodeVerticalSpacingInput.setText("" + this.layout.getLayoutConfig().getSequenceNodeVerticalSpacing());
        sequenceNodeVerticalSpacingInput.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                try {
                    EditorControlsPanel.this.graph.getLayout().getLayoutConfig().setSequenceNodeVerticalSpacing(Integer.parseInt(sequenceNodeVerticalSpacingInput.getText()));
                }
                catch (NumberFormatException exception) {
                    logger.error("Number format error", (Throwable)exception);
                }
            }
        });
        layoutParametersPanel.add(sequenceNodeVerticalSpacingInput);
        JLabel taskNodeDataNodeVerticalSpacing = new JLabel("<html><p style ='font-size:0.9583em'>Vertical spacing between task <br>and data nodes: </p></html>");
        layoutParametersPanel.add(taskNodeDataNodeVerticalSpacing);
        final JTextField taskNodeDataNodeVerticalSpacingInput = new JTextField(2);
        taskNodeDataNodeVerticalSpacingInput.setText("" + this.layout.getLayoutConfig().getTaskNodeToDataNodeVerticalSpacing());
        taskNodeDataNodeVerticalSpacingInput.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                try {
                    EditorControlsPanel.this.graph.getLayout().getLayoutConfig().setTaskNodeToDataNodeVerticalSpacing(Integer.parseInt(taskNodeDataNodeVerticalSpacingInput.getText()));
                }
                catch (NumberFormatException exception) {
                    logger.error("Number format error", (Throwable)exception);
                }
            }
        });
        layoutParametersPanel.add(taskNodeDataNodeVerticalSpacingInput);
        JLabel sequenceNodesHorizontalSpacingLabel = new JLabel("<html><p style ='font-size:0.9583em'>Horizontal spacing for se-<br>quence nodes: </p></html>");
        sequenceNodesHorizontalSpacingLabel.setToolTipText(mxResources.get((String)"sequenceNodesHorizontalSpacingTooltip"));
        layoutParametersPanel.add(sequenceNodesHorizontalSpacingLabel);
        final JTextField sequenceNodesHorizontalSpacingInput = new JTextField(2);
        sequenceNodesHorizontalSpacingInput.setText("" + this.layout.getLayoutConfig().getSequenceNodesHorizontalSpacing());
        sequenceNodesHorizontalSpacingInput.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                try {
                    EditorControlsPanel.this.graph.getLayout().getLayoutConfig().setSequenceNodesHorizontalSpacing(Integer.parseInt(sequenceNodesHorizontalSpacingInput.getText()));
                }
                catch (NumberFormatException exception) {
                    logger.error("Number format error", (Throwable)exception);
                }
            }
        });
        layoutParametersPanel.add(sequenceNodesHorizontalSpacingInput);
        JLabel controlflowEdgeLabelMargin = new JLabel("Controlflow edge label margin: ");
        controlflowEdgeLabelMargin.setToolTipText(mxResources.get((String)"controlflowEdgeLabelMarginTooltip"));
        layoutParametersPanel.add(controlflowEdgeLabelMargin);
        final JTextField edgeLabelMarginInput = new JTextField(2);
        edgeLabelMarginInput.setText("" + this.layout.getLayoutConfig().getControlflowEdgeLabelHorizontalSpacing());
        edgeLabelMarginInput.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                try {
                    EditorControlsPanel.this.graph.getLayout().getLayoutConfig().setControlflowEdgeLabelHorizontalSpacing(Integer.parseInt(edgeLabelMarginInput.getText()));
                }
                catch (NumberFormatException exception) {
                    logger.error("Number format error", (Throwable)exception);
                }
            }
        });
        layoutParametersPanel.add(edgeLabelMarginInput);
        this.add(layoutParametersPanel);
        this.add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleReLayoutAction.class)));
        this.add(new JButton(new EditorActions.LayoutNESTWorkflowAction()));
        this.add(new JLabel("<html><b> </b></html>"));
    }

    private void addCellLabelsSection() {
        this.add(new JLabel("<html><b>Cell labels</b></html>"));
        this.add(new JSeparator(0));
        this.add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleIdVisibilityAction.class)));
        this.add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleEdgeLabelVisibilityAction.class)));
        this.add(new JLabel("<html><b> </b></html>"));
    }

    private void addMiscSection() {
        this.add(new JLabel("<html><b>Misc</b></html>"));
        this.add(new JSeparator(0));
        this.add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleCellTooltipVisibilityAction.class)));
        this.add(new JButton(new EditorActions.EditStylesheetAction()));
        this.add(new JButton(new EditorActions.ValidateNESTWorkflowAction()));
        this.add(new JLabel("<html><b> </b></html>"));
    }
}

