/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NESTWorkflowLayoutForMxGraph
extends NESTWorkflowLayout {
    private mxGraph mxGraph;
    private Map<String, Object> cells;

    public NESTWorkflowLayoutForMxGraph(mxGraph mxGraph2, NESTAbstractWorkflowObject nestWorkflow) {
        super(nestWorkflow);
        this.mxGraph = mxGraph2;
        this.cells = ((mxGraphModel)this.mxGraph.getModel()).getCells();
    }

    @Override
    public void execute() {
        super.execute();
        this.mxGraph.getModel().beginUpdate();
        try {
            this.clearEdgePoints();
            this.updateVertexPositions();
            this.updateEdgePaths();
            this.layoutFaultyEdges();
        }
        finally {
            this.mxGraph.getModel().endUpdate();
            this.mxGraph.refresh();
        }
    }

    private void updateVertexPositions() {
        this.nestWorkflow.getGraphNodes().forEach(node -> {
            Integer x = this.nodeXPositions.getOrDefault(node, null);
            Integer y = this.nodeYPositions.getOrDefault(node, null);
            if (x != null && y != null) {
                mxICell cell = (mxICell)this.cells.get(node.getId());
                mxGeometry cellGeometry = cell.getGeometry();
                cellGeometry.setX((double)x.intValue());
                cellGeometry.setY((double)y.intValue());
                cell.setGeometry(cellGeometry);
            }
        });
    }

    private void updateEdgePaths() {
        this.nestWorkflow.getGraphEdges().forEach(edge -> {
            List path = this.edgePaths.getOrDefault(edge, null);
            if (path != null) {
                mxICell edgeCell = (mxICell)this.cells.get(edge.getId());
                List mxPointPath = path.stream().map(mxPoint::new).collect(Collectors.toList());
                edgeCell.getGeometry().setPoints(mxPointPath);
                if (edge.isNESTDataflowEdge() && this.layoutConfig.isCombineReverseDataflowEdges() && this.findReverseDataflowEdge((NESTEdgeObject)edge).isPresent()) {
                    mxICell reverseEdgeCell = (mxICell)this.cells.get(this.findReverseDataflowEdge((NESTEdgeObject)edge).get().getId());
                    ArrayList pointsReversed = new ArrayList(mxPointPath);
                    Collections.reverse(pointsReversed);
                    reverseEdgeCell.getGeometry().setPoints(pointsReversed);
                }
            }
        });
    }

    private void clearEdgePoints() {
        Arrays.stream(this.mxGraph.getChildEdges(this.mxGraph.getDefaultParent())).map(mxICell.class::cast).filter(edgeCell -> edgeCell.getValue() != null).forEach(edge -> {
            this.mxGraph.resetEdge(edge);
            edge.setStyle(NESTWorkflowEditor.CellStyle.get((NESTEdgeObject)edge.getValue()));
        });
    }

    private void layoutFaultyEdges() {
        List<NESTEdgeObject> faultyEdges = this.nestWorkflow.getGraphEdges().stream().filter(edge -> edge.getPre() == null || edge.getPost() == null).collect(Collectors.toList());
        faultyEdges.forEach(edge -> {
            mxCell edgeCell = (mxCell)this.cells.get(edge.getId());
            mxGeometry edgeGeometry = edgeCell.getGeometry();
            if (edge.getPre() == null) {
                edgeGeometry.setSourcePoint(new mxPoint(edgeCell.getTarget().getGeometry().getX() + edgeCell.getTarget().getGeometry().getWidth() / 2.0, edgeCell.getTarget().getGeometry().getY() - 50.0));
            }
            if (edge.getPost() == null) {
                edgeGeometry.setTargetPoint(new mxPoint(edgeCell.getSource().getGeometry().getX() + edgeCell.getSource().getGeometry().getWidth() / 2.0, edgeCell.getSource().getGeometry().getY() - 50.0));
            }
            this.mxGraph.getModel().setStyle((Object)edgeCell, NESTWorkflowEditor.CellStyle.get(edge) + ";strokeColor=red;strokeWidth=3");
        });
    }

    @Override
    public Dimension getNodeSize(NESTNodeObject node) {
        mxICell nodeCell = (mxICell)((mxGraphModel)this.mxGraph.getModel()).getCell(node.getId());
        return new Dimension((int)nodeCell.getGeometry().getWidth(), (int)nodeCell.getGeometry().getHeight());
    }

    @Override
    public Dimension getEdgeLabelSize(NESTEdgeObject edge) {
        mxRectangle dimension = ((NESTWorkflowEditor.CustomGraph)this.mxGraph).getLabelSize(this.cells.get(edge.getId()));
        return new Dimension((int)dimension.getWidth(), (int)dimension.getHeight());
    }
}

