/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTDataNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTSequenceNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTTaskNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.impl.NESTSequentialWorkflowValidatorImpl;
import de.uni_trier.wi2.procake.data.object.nest.utils.impl.NESTWorkflowValidatorImpl;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;

public abstract class NESTWorkflowLayout {
    protected LayoutConfig layoutConfig = new LayoutConfig(this);
    public static boolean DEFAULT_EXECUTE_ON_EDGE_INSERTION = false;
    private boolean executeOnEdgeInsertion = DEFAULT_EXECUTE_ON_EDGE_INSERTION;
    protected NESTAbstractWorkflowObject nestWorkflow;
    protected Map<NESTNodeObject, Integer> nodeYPositions = new HashMap<NESTNodeObject, Integer>();
    protected Map<NESTNodeObject, Integer> nodeXPositions = new HashMap<NESTNodeObject, Integer>();
    protected Map<String, Integer> nodeYPositionsById = new HashMap<String, Integer>();
    protected Map<String, Integer> nodeXPositionsById = new HashMap<String, Integer>();
    protected Map<NESTEdgeObject, List<Point>> edgePaths = new HashMap<NESTEdgeObject, List<Point>>();
    private int currentBranchXOffset = 0;

    public NESTWorkflowLayout(NESTAbstractWorkflowObject nestWorkflow) {
        this.nestWorkflow = nestWorkflow;
    }

    public void execute() {
        this.nodeYPositions.clear();
        this.nodeXPositions.clear();
        this.edgePaths.clear();
        this.layoutAllBranches(this.nestWorkflow);
        this.layoutWorkflowNodesX();
        this.resolveNodeOverlapsX();
        this.shiftGraphToPositivePositions();
        if (this.layoutConfig.isOrthogonalDataflowEdgeRouting()) {
            // empty if block
        }
    }

    private void layoutAllBranches(NESTAbstractWorkflowObject nestWorkflow) {
        Set allStartNodes = nestWorkflow.getStartNodes();
        int[] maximumX = new int[]{0};
        this.traverseAllWorkflowTrees(nestWorkflow, workflowNode -> {
            List<NESTSequenceNodeObject> workflowStartNodes = allStartNodes.stream().filter(startNode -> startNode.getOutgoingEdges(DataObject::isNESTPartOfEdge).stream().anyMatch(partOfEdge -> partOfEdge.getPost() == workflowNode)).sorted(Comparator.comparing(DataObject::getId)).collect(Collectors.toList());
            workflowStartNodes.forEach(workflowStartNode -> {
                Branch workflowBranch = new Branch((NESTSequenceNodeObject)workflowStartNode);
                maximumX[0] = this.layoutBranchX(workflowBranch, maximumX[0]);
                this.layoutNodesY(workflowBranch);
                this.layoutControlflowEdges(workflowBranch);
                allStartNodes.remove(workflowStartNode);
            });
        });
        allStartNodes.forEach(startNode -> {
            Branch branch = new Branch((NESTSequenceNodeObject)startNode);
            maximumX[0] = this.layoutBranchX(branch, maximumX[0]);
            this.layoutNodesY(branch);
            this.layoutControlflowEdges(branch);
        });
    }

    private void layoutControlflowEdges(Branch branch) {
        this.edgePaths.putAll(branch.getControlflowEdgePaths());
    }

    private void traverseAllWorkflowTrees(NESTAbstractWorkflowObject nestWorkflow, Consumer<NESTNodeObject> consumer) {
        this.getWorkflowRootNodes(nestWorkflow).forEach(rootNode -> this.traverseWorkflowTree((NESTNodeObject)rootNode, consumer));
    }

    private List<NESTNodeObject> getWorkflowRootNodes(NESTAbstractWorkflowObject nestWorkflow) {
        return nestWorkflow.getGraphNodes(node -> node.isNESTWorkflowNode() || node.isNESTSubWorkflowNode()).stream().map(this::getRootWorkflowNode).collect(Collectors.toSet()).stream().sorted(Comparator.comparing(DataObject::isNESTSubWorkflowNode).thenComparing(DataObject::getId)).collect(Collectors.toList());
    }

    private NESTNodeObject getRootWorkflowNode(NESTNodeObject node) {
        if (node == null) {
            return null;
        }
        NESTNodeObject parentWorkflowNode = node.getOutgoingEdges(DataObject::isNESTPartOfEdge).stream().map(NESTEdgeObject::getPost).filter(postNode -> postNode.isNESTWorkflowNode() || postNode.isNESTSubWorkflowNode()).findAny().orElse(null);
        if (parentWorkflowNode == null) {
            return node.isNESTWorkflowNode() || node.isNESTSubWorkflowNode() ? node : null;
        }
        return this.getRootWorkflowNode(parentWorkflowNode);
    }

    private void traverseWorkflowTree(NESTNodeObject node, Consumer<NESTNodeObject> consumer) {
        consumer.accept(node);
        List<NESTNodeObject> childWorkflowNodes = node.getIngoingEdges(DataObject::isNESTPartOfEdge).stream().map(NESTEdgeObject::getPre).filter(Objects::nonNull).filter(preNode -> preNode.isNESTWorkflowNode() || preNode.isNESTSubWorkflowNode()).sorted(Comparator.comparing(DataObject::getId)).collect(Collectors.toList());
        childWorkflowNodes.forEach(workflowNode -> this.traverseWorkflowTree((NESTNodeObject)workflowNode, consumer));
    }

    private int layoutBranchX(Branch branch, int startX) {
        if (this.layoutConfig.isPlaceDataNodesVerticallyNearTaskNodes()) {
            branch.assignDataNodesToSequences(this.nestWorkflow.getDataNodes());
        }
        branch.calculateSequenceNodeHorizontalPositions();
        if (this.layoutConfig.isPlaceDataNodesVerticallyNearTaskNodes() && this.layoutConfig.isAlsoPlaceDataNodesAboveTaskNodes()) {
            this.nodeXPositions.putAll(branch.getNodesXPositions(startX));
            branch.distributeDataNodes();
        }
        this.nodeXPositions.putAll(branch.getNodesXPositions(startX));
        if (!this.layoutConfig.isPlaceDataNodesVerticallyNearTaskNodes()) {
            this.layoutDataNodesX();
        }
        return branch.getMaximumX();
    }

    protected Optional<NESTEdgeObject> findReverseDataflowEdge(NESTEdgeObject edge) {
        return this.findReverseEdge(edge, DataObject::isNESTDataflowEdge);
    }

    private Optional<NESTEdgeObject> findReverseEdge(NESTEdgeObject edge, Predicate<? super NESTEdgeObject> filter) {
        return edge.getPre() == null ? Optional.empty() : edge.getPre().getIngoingEdges(filter).stream().filter(inEdge -> inEdge.getPre() == edge.getPost()).findAny();
    }

    public boolean isApplicable() {
        if (this.nestWorkflow.isNESTWorkflow()) {
            NESTWorkflowValidatorImpl validator = new NESTWorkflowValidatorImpl((NESTWorkflowObject)this.nestWorkflow);
            return true;
        }
        if (this.nestWorkflow.isNESTSequentialWorkflow()) {
            return new NESTSequentialWorkflowValidatorImpl(this.nestWorkflow).isValidSequentialWorkflow();
        }
        return true;
    }

    public abstract Dimension getEdgeLabelSize(NESTEdgeObject var1);

    public abstract Dimension getNodeSize(NESTNodeObject var1);

    private int getMaxNodeHeight(Collection<? extends NESTNodeObject> nodes) {
        return nodes.stream().map(node -> this.getNodeSize((NESTNodeObject)node).getHeight()).max(Double::compareTo).orElse(0.0).intValue();
    }

    private void layoutNodesY(Branch branch) {
        Map<NESTNodeObject, Integer> nodeVerticalPositions = this.calculateNodeVerticalPositions(branch);
        int minPosition = nodeVerticalPositions.entrySet().stream().filter(entry -> ((NESTNodeObject)entry.getKey()).isNESTDataNode() || ((NESTNodeObject)entry.getKey()).isNESTSequenceNode()).map(Map.Entry::getValue).min(Integer::compareTo).orElse(0);
        if (this.layoutConfig.isPlaceDataNodesVerticallyNearTaskNodes() && this.layoutConfig.isAlsoPlaceDataNodesAboveTaskNodes() && nodeVerticalPositions.entrySet().stream().noneMatch(entry -> (Integer)entry.getValue() == minPosition && ((NESTNodeObject)entry.getKey()).isNESTDataNode())) {
            nodeVerticalPositions = nodeVerticalPositions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + this.layoutConfig.getNodeHeight() + this.layoutConfig.getTaskNodeToDataNodeVerticalSpacing()));
        }
        this.nodeYPositions.putAll(nodeVerticalPositions);
    }

    private Map<NESTNodeObject, Integer> calculateNodeVerticalPositions(Branch branch) {
        HashMap<NESTNodeObject, Integer> positions = new HashMap<NESTNodeObject, Integer>();
        Map<NESTNodeObject, Integer> sequenceNodePositions = branch.getNodeVerticalPositions();
        Map<NESTNodeObject, Integer> workflowAndSubworkflowLevels = this.getWorkflowAndSubworkflowLevels((NESTNodeObject)this.nestWorkflow.getWorkflowNode());
        int minSequenceNodeY = sequenceNodePositions.values().stream().min(Integer::compareTo).orElse(0);
        int maxWorkflowAndSubworkflowLevels = workflowAndSubworkflowLevels.values().stream().max(Integer::compareTo).orElse(0);
        Map<NESTNodeObject, Integer> workflowAndSubworkflowPositions = workflowAndSubworkflowLevels.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> minSequenceNodeY - (maxWorkflowAndSubworkflowLevels + 2) * (this.layoutConfig.getNodeHeight() + this.layoutConfig.getNodeVerticalSpacing()) + (Integer)e.getValue() * (this.layoutConfig.getNodeHeight() + this.layoutConfig.getNodeVerticalSpacing())));
        positions.putAll(sequenceNodePositions);
        positions.putAll(workflowAndSubworkflowPositions);
        if (!this.layoutConfig.isPlaceDataNodesVerticallyNearTaskNodes()) {
            int maxNodePosition = positions.values().stream().max(Integer::compareTo).orElse(0);
            for (NESTNodeObject dataNode : this.nestWorkflow.getDataNodes()) {
                positions.put(dataNode, maxNodePosition + this.layoutConfig.getTaskNodeToDataNodeVerticalSpacing());
            }
        }
        int minNodePosition = positions.values().stream().min(Integer::compareTo).orElse(0);
        positions = positions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() - minNodePosition + 1));
        return positions;
    }

    private Map<NESTNodeObject, Integer> getWorkflowAndSubworkflowLevels(NESTNodeObject node, int level) {
        HashMap<NESTNodeObject, Integer> levels = new HashMap<NESTNodeObject, Integer>();
        if (node == null) {
            return levels;
        }
        if (node.isNESTWorkflowNode() || node.isNESTSubWorkflowNode()) {
            levels.put(node, level);
            node.getIngoingEdges(DataObject::isNESTPartOfEdge).forEach(partOfEdge -> levels.putAll(this.getWorkflowAndSubworkflowLevels(partOfEdge.getPre(), level + 1)));
        }
        return levels;
    }

    private Map<NESTNodeObject, Integer> getWorkflowAndSubworkflowLevels(NESTNodeObject node) {
        return this.getWorkflowAndSubworkflowLevels(node, 0);
    }

    private void layoutDataNodesX() {
        IntervalOverlapResolver overlapResolver = new IntervalOverlapResolver(10);
        Set dataNodes = this.nestWorkflow.getDataNodes();
        Map<NESTDataNodeObject, Integer> dataNodesCenterXPositions = this.getDataNodesCenterXPositions(dataNodes);
        dataNodes.forEach(node -> {
            int intervalStart = (Integer)dataNodesCenterXPositions.get(node) - (int)(this.getNodeSize((NESTNodeObject)node).getWidth() / 2.0);
            overlapResolver.addInterval(intervalStart, intervalStart + (int)this.getNodeSize((NESTNodeObject)node).getWidth(), node.getId());
        });
        List<IntervalOverlapResolver.Interval> nonOverlappingIntervals = overlapResolver.resolve();
        nonOverlappingIntervals.forEach(interval -> this.nodeXPositions.put(this.nestWorkflow.getGraphNode(interval.getId()), interval.getStart()));
    }

    private Map<NESTDataNodeObject, Integer> getDataNodesCenterXPositions(Collection<NESTDataNodeObject> dataNodes) {
        return dataNodes.stream().collect(Collectors.toMap(Function.identity(), dataNode -> {
            final List inNeighboursXPositionsCentre = dataNode.getIngoingEdges(DataObject::isNESTDataflowEdge).stream().map(edge -> {
                NESTNodeObject preNode = edge.getPre();
                return (double)this.nodeXPositions.get(preNode).intValue() + this.getNodeSize(preNode).getWidth() / 2.0;
            }).collect(Collectors.toList());
            final List outNeighboursXPositionsCentre = dataNode.getOutgoingEdges(DataObject::isNESTDataflowEdge).stream().filter(edge -> edge.getPost() != null).map(edge -> {
                NESTNodeObject postNode = edge.getPost();
                return (double)this.nodeXPositions.get(postNode).intValue() + this.getNodeSize(postNode).getWidth() / 2.0;
            }).collect(Collectors.toList());
            ArrayList<Double> neighboursXPositions = new ArrayList<Double>(){
                {
                    this.addAll(inNeighboursXPositionsCentre);
                    this.addAll(outNeighboursXPositionsCentre);
                }
            };
            return (int)neighboursXPositions.stream().mapToDouble(val -> val).average().orElse(0.0);
        }));
    }

    private Map<NESTTaskNodeObject, Integer> getTaskNodesCenterXPositions() {
        return this.nestWorkflow.getTaskNodes().stream().filter(taskNode -> this.nodeXPositions.get(taskNode) != null).collect(Collectors.toMap(Function.identity(), taskNode -> (int)((double)this.nodeXPositions.get(taskNode).intValue() + this.getNodeSize((NESTNodeObject)taskNode).getWidth() / 2.0)));
    }

    private void layoutWorkflowNodesX() {
        HashSet<NESTWorkflowNodeObject> workflowNodes = new HashSet<NESTWorkflowNodeObject>(this.nestWorkflow.getSubWorkflowNodes());
        workflowNodes.add(this.nestWorkflow.getWorkflowNode());
        IntervalOverlapResolver overlapResolver = new IntervalOverlapResolver(10);
        workflowNodes.stream().filter(Objects::nonNull).forEach(node -> {
            List inNeighboursXPositions = node.getIngoingEdges(DataObject::isNESTPartOfEdge).stream().filter(edge -> edge.getPre() != null).map(edge -> this.nodeXPositions.getOrDefault(edge.getPre(), 0)).collect(Collectors.toList());
            int averageXPosition = (int)inNeighboursXPositions.stream().mapToDouble(val -> val.intValue()).average().orElse(0.0);
            overlapResolver.addInterval(averageXPosition, averageXPosition + this.getNodeSize((NESTNodeObject)node).width, node.getId());
        });
        overlapResolver.resolve().forEach(interval -> this.nodeXPositions.put(this.nestWorkflow.getGraphNode(interval.getId()), interval.getStart()));
    }

    private void resolveNodeOverlapsX() {
        Collection<List<NESTNodeObject>> nodeLayers = this.nestWorkflow.getGraphNodes().stream().collect(Collectors.groupingBy(node -> this.nodeYPositions.getOrDefault(node, 0))).values();
        nodeLayers.forEach(nodes -> {
            IntervalOverlapResolver overlapResolver = new IntervalOverlapResolver(5);
            nodes.forEach(node -> {
                int intervalStart = this.nodeXPositions.getOrDefault(node, 0);
                overlapResolver.addInterval(intervalStart, intervalStart + this.getNodeSize((NESTNodeObject)node).width, node.getId());
            });
            overlapResolver.resolve().forEach(interval -> this.nodeXPositions.put(this.nestWorkflow.getGraphNode(interval.getId()), interval.getStart()));
        });
    }

    private void shiftGraphToPositivePositions() {
        int minX = this.nodeXPositions.values().stream().min(Integer::compareTo).orElse(0);
        int shiftDistanceX = this.layoutConfig.getGraphLeftMargin() - minX;
        int minY = this.nodeYPositions.values().stream().min(Integer::compareTo).orElse(0);
        int minEdgePathY = this.edgePaths.values().stream().flatMap(Collection::stream).map(Point::getY).min(Double::compareTo).orElse(0.0).intValue();
        int shiftDistanceY = (minY = Math.min(minY, minEdgePathY)) < this.layoutConfig.getGraphTopMargin() ? this.layoutConfig.getGraphTopMargin() - minY : 0;
        this.nodeXPositions = this.nodeXPositions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + shiftDistanceX));
        this.nodeYPositions = this.nodeYPositions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + shiftDistanceY));
        this.edgePaths.values().stream().flatMap(Collection::stream).forEach(point -> point.setLocation(point.x + shiftDistanceX, point.y + shiftDistanceY));
    }

    public Map<NESTNodeObject, Integer> getNodeXPositions() {
        return this.nodeXPositions;
    }

    public int getNodeXPosition(NESTNodeObject node) {
        return this.nodeXPositions.get(node);
    }

    public Map<NESTNodeObject, Integer> getNodeYPositions() {
        return this.nodeYPositions;
    }

    public int getNodeYPosition(NESTNodeObject node) {
        return this.nodeYPositions.get(node);
    }

    public Map<NESTEdgeObject, List<Point>> getEdgePaths() {
        return this.edgePaths;
    }

    public List<Point> getEdgePath(NESTEdgeObject edge) {
        return this.edgePaths.get(edge);
    }

    public LayoutConfig getLayoutConfig() {
        return this.layoutConfig;
    }

    public void setLayoutConfig(LayoutConfig layoutConfig) {
        this.layoutConfig = layoutConfig;
        layoutConfig.setNestWorkflowLayout(this);
        this.execute();
    }

    public boolean isExecuteOnEdgeInsertion() {
        return this.executeOnEdgeInsertion;
    }

    public void setExecuteOnEdgeInsertion(boolean executeOnEdgeInsertion) {
        this.executeOnEdgeInsertion = executeOnEdgeInsertion;
    }

    public void setNestWorkflow(NESTAbstractWorkflowObject nestWorkflow) {
        this.nestWorkflow = nestWorkflow;
    }

    private int getCenterY(NESTNodeObject node) {
        return (int)((double)this.nodeYPositions.get(node).intValue() + this.getNodeSize(node).getHeight() / 2.0);
    }

    private int getCenterX(NESTNodeObject node) {
        return (int)((double)this.nodeXPositions.get(node).intValue() + this.getNodeSize(node).getWidth() / 2.0);
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class LayoutConfig {
        @XmlTransient
        private NESTWorkflowLayout nestWorkflowLayout;
        protected boolean combineReverseDataflowEdges = true;
        private int nodeWidth = 50;
        private int nodeHeight = 50;
        private int nodeVerticalSpacing = 50;
        private int taskNodeToDataNodeVerticalSpacing = 50;
        private int sequenceNodeVerticalSpacing = 0;
        private int graphLeftMargin = 50;
        private int graphTopMargin = 50;
        private int sequenceNodesHorizontalSpacing = 50;
        private int controlflowEdgeLabelHorizontalSpacing = 50;
        private boolean placeDataNodesVerticallyNearTaskNodes = true;
        private boolean alsoPlaceDataNodesAboveTaskNodes = false;
        private boolean orthogonalDataflowEdgeRouting = false;
        private int idealNudgingDistance = 15;
        private int shapeBufferDistance = 10;

        public LayoutConfig(NESTWorkflowLayout nestWorkflowLayout) {
            this.nestWorkflowLayout = nestWorkflowLayout;
        }

        public LayoutConfig() {
        }

        public int getNodeHeight() {
            return this.nodeHeight;
        }

        public void setNodeHeight(int nodeHeight) {
            this.nodeHeight = nodeHeight;
            this.nestWorkflowLayout.execute();
        }

        public int getNodeVerticalSpacing() {
            return this.nodeVerticalSpacing;
        }

        public void setNodeVerticalSpacing(int nodeVerticalSpacing) {
            this.nodeVerticalSpacing = nodeVerticalSpacing;
            this.nestWorkflowLayout.execute();
        }

        public void setIdealNudgingDistance(int idealNudgingDistance) {
            this.idealNudgingDistance = idealNudgingDistance;
            this.nestWorkflowLayout.execute();
        }

        public void setShapeBufferDistance(int shapeBufferDistance) {
            this.shapeBufferDistance = shapeBufferDistance;
            this.nestWorkflowLayout.execute();
        }

        public void setAlsoPlaceDataNodesAboveTaskNodes(boolean alsoPlaceDataNodesAboveTaskNodes) {
            this.alsoPlaceDataNodesAboveTaskNodes = alsoPlaceDataNodesAboveTaskNodes;
            this.nestWorkflowLayout.execute();
        }

        public int getGraphLeftMargin() {
            return this.graphLeftMargin;
        }

        public void setGraphLeftMargin(int graphLeftMargin) {
            this.graphLeftMargin = graphLeftMargin;
            this.nestWorkflowLayout.execute();
        }

        public void setSequenceNodeVerticalSpacing(int sequenceNodeVerticalSpacing) {
            this.sequenceNodeVerticalSpacing = sequenceNodeVerticalSpacing;
            this.nestWorkflowLayout.execute();
        }

        public void setTaskNodeToDataNodeVerticalSpacing(int taskNodeToDataNodeVerticalSpacing) {
            this.taskNodeToDataNodeVerticalSpacing = taskNodeToDataNodeVerticalSpacing;
            this.nestWorkflowLayout.execute();
        }

        public int getSequenceNodesHorizontalSpacing() {
            return this.sequenceNodesHorizontalSpacing;
        }

        public void setSequenceNodesHorizontalSpacing(int sequenceNodesHorizontalSpacing) {
            this.sequenceNodesHorizontalSpacing = sequenceNodesHorizontalSpacing;
            this.nestWorkflowLayout.execute();
        }

        public int getControlflowEdgeLabelHorizontalSpacing() {
            return this.controlflowEdgeLabelHorizontalSpacing;
        }

        public void setControlflowEdgeLabelHorizontalSpacing(int controlflowEdgeLabelHorizontalSpacing) {
            this.controlflowEdgeLabelHorizontalSpacing = controlflowEdgeLabelHorizontalSpacing;
            this.nestWorkflowLayout.execute();
        }

        public boolean isCombineReverseDataflowEdges() {
            return this.combineReverseDataflowEdges;
        }

        public void setCombineReverseDataflowEdges(boolean combineReverseDataflowEdges) {
            this.combineReverseDataflowEdges = combineReverseDataflowEdges;
            this.nestWorkflowLayout.execute();
        }

        public boolean isPlaceDataNodesVerticallyNearTaskNodes() {
            return this.placeDataNodesVerticallyNearTaskNodes;
        }

        public void setPlaceDataNodesVerticallyNearTaskNodes(boolean placeDataNodesVerticallyNearTaskNodes) {
            this.placeDataNodesVerticallyNearTaskNodes = placeDataNodesVerticallyNearTaskNodes;
            this.nestWorkflowLayout.execute();
        }

        public boolean isOrthogonalDataflowEdgeRouting() {
            return this.orthogonalDataflowEdgeRouting;
        }

        public void setOrthogonalDataflowEdgeRouting(boolean orthogonalDataflowEdgeRouting) {
            this.orthogonalDataflowEdgeRouting = orthogonalDataflowEdgeRouting;
            this.nestWorkflowLayout.execute();
        }

        public int getTaskNodeToDataNodeVerticalSpacing() {
            return this.taskNodeToDataNodeVerticalSpacing;
        }

        public int getNodeWidth() {
            return this.nodeWidth;
        }

        public int getSequenceNodeVerticalSpacing() {
            return this.sequenceNodeVerticalSpacing;
        }

        public int getGraphTopMargin() {
            return this.graphTopMargin;
        }

        public void setGraphTopMargin(int graphTopMargin) {
            this.graphTopMargin = graphTopMargin;
        }

        public boolean isAlsoPlaceDataNodesAboveTaskNodes() {
            return this.alsoPlaceDataNodesAboveTaskNodes;
        }

        public int getIdealNudgingDistance() {
            return this.idealNudgingDistance;
        }

        public int getShapeBufferDistance() {
            return this.shapeBufferDistance;
        }

        public void setNestWorkflowLayout(NESTWorkflowLayout nestWorkflowLayout) {
            this.nestWorkflowLayout = nestWorkflowLayout;
        }
    }

    class Branch
    implements Comparable<Branch>,
    Controlflow {
        private List<Controlflow> controlflow = new LinkedList<Controlflow>();
        private NESTEdgeObject ingoingEdge;
        private int maximumX;

        public Branch(NESTSequenceNodeObject firstNode) {
            this.initIngoingEdge(firstNode);
            this.initControlflow(firstNode);
        }

        private Branch(NESTEdgeObject ingoingEdge) {
            this.ingoingEdge = ingoingEdge;
        }

        private void initControlflow(NESTSequenceNodeObject currentNode) {
            Sequence currentSequence = new Sequence(currentNode);
            this.controlflow.add(currentSequence);
            NESTSequenceNodeObject lastNode = currentSequence.getLastNode();
            if (lastNode.isNESTControlflowNode() && ((NESTControlflowNodeObject)lastNode).isStartControlflowNode()) {
                NESTControlflowNodeObject startControlflowNode = (NESTControlflowNodeObject)lastNode;
                NESTControlflowNodeObject endControlflowNode = startControlflowNode.getMatchingBlockControlflowNode();
                List<Branch> branches = startControlflowNode.getOutgoingEdges(DataObject::isNESTControlflowEdge).stream().map(outEdge -> outEdge.getPost() == endControlflowNode ? new Branch((NESTEdgeObject)outEdge) : new Branch((NESTSequenceNodeObject)outEdge.getPost())).sorted().collect(Collectors.toList());
                this.controlflow.add(startControlflowNode.isLoopNode() ? new LoopSplit(branches) : new Split(branches));
                if (endControlflowNode != null) {
                    this.initControlflow((NESTSequenceNodeObject)endControlflowNode);
                }
            }
        }

        private List<Sequence> getSequences() {
            return this.controlflow.stream().filter(Sequence.class::isInstance).map(Sequence.class::cast).collect(Collectors.toList());
        }

        private List<Split> getSplits() {
            return this.controlflow.stream().filter(Split.class::isInstance).map(Split.class::cast).collect(Collectors.toList());
        }

        @Override
        public Map<NESTSequenceNodeObject, Sequence> getSequenceNodesToSequencesMapping() {
            HashMap<NESTSequenceNodeObject, Sequence> result = new HashMap<NESTSequenceNodeObject, Sequence>();
            this.controlflow.forEach(controlflow -> result.putAll(controlflow.getSequenceNodesToSequencesMapping()));
            return result;
        }

        @Override
        public void distributeDataNodes() {
            this.controlflow.forEach(Controlflow::distributeDataNodes);
        }

        @Override
        public void calculateSequenceNodeHorizontalPositions() {
            this.controlflow.forEach(Controlflow::calculateSequenceNodeHorizontalPositions);
        }

        @Override
        public Map<NESTNodeObject, Integer> getNodesXPositions(int startX) {
            NESTWorkflowLayout.this.currentBranchXOffset = startX;
            HashMap<NESTNodeObject, Integer> xPositions = new HashMap<NESTNodeObject, Integer>();
            for (Controlflow controlflow : this.controlflow) {
                Map<NESTNodeObject, Integer> controlflowXPositions = controlflow.getNodesXPositions(startX);
                if (controlflowXPositions.size() <= 0) continue;
                startX = this.maximumX = controlflowXPositions.entrySet().stream().map(entry -> (Integer)entry.getValue() + (int)NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)entry.getKey()).getWidth()).max(Integer::compareTo).get().intValue();
                xPositions.putAll(controlflowXPositions);
            }
            return xPositions;
        }

        private void initIngoingEdge(NESTSequenceNodeObject firstNode) {
            this.ingoingEdge = firstNode.getIngoingEdges().stream().filter(edge -> edge.isNESTControlflowEdge() && !Utils.isEdgeLoopReturnEdge(edge)).findAny().orElse(null);
        }

        public void assignDataNodesToSequences(Set<NESTDataNodeObject> dataNodes) {
            Map<NESTSequenceNodeObject, Sequence> sequenceNodesToSequencesMapping = this.getSequenceNodesToSequencesMapping();
            dataNodes.forEach(dataNode -> {
                HashMap associationCount = new HashMap();
                dataNode.getConnectedTasks().forEach(connectedTask -> {
                    Sequence taskSequence = (Sequence)sequenceNodesToSequencesMapping.get(connectedTask);
                    associationCount.put(taskSequence, associationCount.getOrDefault(taskSequence, 0) + 1);
                });
                int maxAssociationCount = associationCount.values().stream().max(Integer::compareTo).orElse(0);
                List fittingSequences = associationCount.entrySet().stream().filter(entry -> entry.getKey() != null && (Integer)entry.getValue() == maxAssociationCount).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
                if (fittingSequences.size() > 0) {
                    ((Sequence)fittingSequences.get(0)).getBottomDataNodes().add((NESTDataNodeObject)dataNode);
                }
            });
        }

        public NESTEdgeObject getIngoingEdge() {
            return this.ingoingEdge;
        }

        public NESTEdgeObject getOutgoingEdge() {
            if (this.controlflow.size() == 0) {
                return this.ingoingEdge;
            }
            Controlflow lastCf = this.controlflow.get(this.controlflow.size() - 1);
            if (lastCf instanceof Split) {
                return null;
            }
            return ((Sequence)lastCf).getLastNode().getOutgoingEdges(DataObject::isNESTControlflowEdge).stream().filter(edge -> !Utils.isEdgeLoopReturnEdge(edge)).findAny().orElse(null);
        }

        public int getMaximumX() {
            return this.maximumX;
        }

        @Override
        public Map<NESTNodeObject, Integer> getNodeVerticalPositions() {
            HashMap<NESTNodeObject, Integer> verticalPositions = new HashMap<NESTNodeObject, Integer>();
            this.controlflow.forEach(cf -> verticalPositions.putAll(cf.getNodeVerticalPositions()));
            return verticalPositions;
        }

        @Override
        public int getHeight() {
            return this.controlflow.stream().map(Controlflow::getHeight).max(Integer::compareTo).orElse(NESTWorkflowLayout.this.layoutConfig.getNodeHeight());
        }

        @Override
        public int getTopHeight() {
            return this.controlflow.stream().map(Controlflow::getTopHeight).max(Integer::compareTo).orElse(NESTWorkflowLayout.this.layoutConfig.getNodeHeight() / 2);
        }

        @Override
        public int getBottomHeight() {
            return this.controlflow.stream().map(Controlflow::getBottomHeight).max(Integer::compareTo).orElse(NESTWorkflowLayout.this.layoutConfig.getNodeHeight() / 2);
        }

        public Map<NESTEdgeObject, List<Point>> getControlflowEdgePaths() {
            HashMap<NESTEdgeObject, List<Point>> edgePaths = new HashMap<NESTEdgeObject, List<Point>>();
            this.getSplits().forEach(split -> edgePaths.putAll(split.getControlflowEdgePaths()));
            return edgePaths;
        }

        @Override
        public int compareTo(Branch other) {
            return this.getIngoingEdge().getId().compareTo(other.getIngoingEdge().getId());
        }
    }

    static class IntervalOverlapResolver
    extends HashSet<Interval> {
        private int buffer;

        public IntervalOverlapResolver(int buffer) {
            this.buffer = buffer;
        }

        public void addInterval(int start, int end, String id) {
            this.add(new Interval(start, end, id));
        }

        public List<Interval> resolve() {
            TreeSet<IntervalContainer> intervalContainers = new TreeSet<IntervalContainer>();
            for (Interval interval : this) {
                intervalContainers.add(new IntervalContainer(interval));
            }
            boolean modified = true;
            block1: while (modified) {
                modified = false;
                IntervalContainer last = null;
                for (IntervalContainer next : intervalContainers) {
                    if (last != null && last.isOverlapping(next, this.buffer)) {
                        intervalContainers.remove(last);
                        intervalContainers.remove(next);
                        IntervalContainer leftShiftIntervalContainer = last.getShiftDistanceWeight() <= next.getShiftDistanceWeight() ? last : next;
                        IntervalContainer rightShiftIntervalContainer = last.getShiftDistanceWeight() > next.getShiftDistanceWeight() ? last : next;
                        leftShiftIntervalContainer.resolveOverlap(rightShiftIntervalContainer, this.buffer);
                        leftShiftIntervalContainer.addAll(rightShiftIntervalContainer);
                        intervalContainers.add(leftShiftIntervalContainer);
                        modified = true;
                        continue block1;
                    }
                    last = next;
                }
            }
            ArrayList<Interval> result = new ArrayList<Interval>(this.size());
            for (IntervalContainer intervalContainer : intervalContainers) {
                result.addAll(intervalContainer);
            }
            return result;
        }

        static class Interval
        implements Comparable<Interval> {
            private int start;
            private int end;
            private String id;

            public Interval(int start, int end, String id) {
                this.start = start;
                this.end = end;
                this.id = id;
            }

            @Override
            public int compareTo(Interval other) {
                return Comparator.comparing(Interval::getStart).thenComparing(Interval::getId).compare(this, other);
            }

            public int getShiftDistanceWeight() {
                return 0;
            }

            public int getStart() {
                return this.start;
            }

            public void setStart(int start) {
                this.start = start;
            }

            public int getEnd() {
                return this.end;
            }

            public void setEnd(int end) {
                this.end = end;
            }

            public String getId() {
                return this.id;
            }
        }

        class IntervalContainer
        extends TreeSet<Interval>
        implements Comparable<IntervalContainer> {
            public IntervalContainer(Interval initialElement) {
                this.add(initialElement);
            }

            public void resolveOverlap(IntervalContainer other, int buffer) {
                int distanceToResolve = this.getShiftDistance(other) + buffer;
                int otherShiftDistance = (int)Math.ceil((double)this.size() / (double)(this.size() + other.size()) * (double)distanceToResolve);
                int meShiftDistance = (int)Math.ceil((double)other.size() / (double)(this.size() + other.size()) * (double)distanceToResolve);
                this.shift(-meShiftDistance);
                other.shift(otherShiftDistance);
            }

            private void shift(int distance) {
                this.forEach(interval -> {
                    interval.setStart(interval.getStart() + distance);
                    interval.setEnd(interval.getEnd() + distance);
                });
            }

            private boolean isOverlapping(IntervalContainer other, int buffer) {
                List<IntervalContainer> intervals = Arrays.asList(this, other);
                Collections.sort(intervals);
                return intervals.get(0).getEnd() + buffer > intervals.get(1).getStart();
            }

            private int getShiftDistance(IntervalContainer other) {
                List<IntervalContainer> intervals = Arrays.asList(this, other);
                Collections.sort(intervals);
                return intervals.get(0).getEnd() - intervals.get(1).getStart();
            }

            public int getShiftDistanceWeight() {
                return this.stream().map(Interval::getShiftDistanceWeight).mapToInt(Integer::intValue).sum();
            }

            public int getStart() {
                return ((Interval)this.first()).getStart();
            }

            public int getEnd() {
                return ((Interval)this.last()).getEnd();
            }

            @Override
            public int compareTo(IntervalContainer other) {
                return Comparator.comparing(IntervalContainer::getStart).thenComparing(TreeSet::first).compare(this, other);
            }
        }
    }

    public class PartitionIterable<T>
    implements Iterable<List<List<T>>> {
        private final List<T> allElements = new ArrayList<T>();
        private final int blocks;

        public PartitionIterable(List<T> allElements, int blocks) {
            this.checkNumberOfBlocks(blocks, allElements.size());
            this.allElements.addAll(allElements);
            this.blocks = blocks;
        }

        @Override
        public Iterator<List<List<T>>> iterator() {
            return new PartitionIterator<T>(this.allElements, this.blocks);
        }

        private void checkNumberOfBlocks(int blocks, int numberOfElements) {
            if (blocks < 1) {
                throw new IllegalArgumentException("The number of blocks should be at least 1, received: " + blocks);
            }
            if (blocks > numberOfElements) {
                throw new IllegalArgumentException("The number of blocks should be at most " + numberOfElements + ", received: " + blocks);
            }
        }

        private final class PartitionIterator<T>
        implements Iterator<List<List<T>>> {
            private final List<T> allElements = new ArrayList<T>();
            private final int blocks;
            private final int[] s;
            private final int[] m;
            private final int n;
            private List<List<T>> nextPartition;

            PartitionIterator(List<T> allElements, int blocks) {
                this.allElements.addAll(allElements);
                this.blocks = blocks;
                this.n = allElements.size();
                this.s = new int[this.n];
                this.m = new int[this.n];
                if (this.n != 0) {
                    int i;
                    for (i = 0; i < this.n - blocks + 1; ++i) {
                        this.s[i] = 0;
                        this.m[i] = 0;
                    }
                    for (i = this.n - blocks + 1; i < this.n; ++i) {
                        this.s[i] = this.m[i] = i - this.n + blocks;
                    }
                    this.loadPartition();
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextPartition != null;
            }

            @Override
            public List<List<T>> next() {
                if (this.nextPartition == null) {
                    throw new NoSuchElementException("No more partitions left.");
                }
                List<List<T>> partition = this.nextPartition;
                this.generateNextPartition();
                return partition;
            }

            private void loadPartition() {
                int i;
                this.nextPartition = new ArrayList<List<T>>(this.blocks);
                for (i = 0; i < this.blocks; ++i) {
                    this.nextPartition.add(new ArrayList());
                }
                for (i = 0; i < this.n; ++i) {
                    this.nextPartition.get(this.s[i]).add(this.allElements.get(i));
                }
            }

            private void generateNextPartition() {
                for (int i = this.n - 1; i > 0; --i) {
                    int j;
                    if (this.s[i] >= this.blocks - 1 || this.s[i] > this.m[i - 1]) continue;
                    int n = i;
                    this.s[n] = this.s[n] + 1;
                    this.m[i] = Math.max(this.m[i], this.s[i]);
                    for (j = i + 1; j < this.n - this.blocks + this.m[i] + 1; ++j) {
                        this.s[j] = 0;
                        this.m[j] = this.m[i];
                    }
                    for (j = this.n - this.blocks + this.m[i] + 1; j < this.n; ++j) {
                        this.s[j] = this.m[j] = this.blocks - this.n + j;
                    }
                    this.loadPartition();
                    return;
                }
                this.nextPartition = null;
            }
        }
    }

    class Sequence
    implements Comparable<Sequence>,
    Controlflow {
        private List<NESTSequenceNodeObject> sequence = new LinkedList<NESTSequenceNodeObject>();
        private Set<NESTDataNodeObject> bottomDataNodes = new HashSet<NESTDataNodeObject>();
        private Set<NESTDataNodeObject> topDataNodes = new HashSet<NESTDataNodeObject>();
        private Map<NESTSequenceNodeObject, Integer> sequenceNodesXPositions = new HashMap<NESTSequenceNodeObject, Integer>();

        public Sequence(NESTSequenceNodeObject firstNode) {
            this.initSequence(firstNode);
        }

        private void initSequence(NESTSequenceNodeObject currentNode) {
            this.sequence.add(currentNode);
            if (currentNode.getNextNodes().size() == 0 || currentNode.isNESTControlflowNode() && ((NESTControlflowNodeObject)currentNode).isStartControlflowNode()) {
                return;
            }
            NESTSequenceNodeObject nextNode = (NESTSequenceNodeObject)currentNode.getNextNodes().iterator().next();
            if (nextNode.isNESTTaskNode()) {
                this.initSequence(nextNode);
                return;
            }
            if (nextNode.isNESTControlflowNode() && ((NESTControlflowNodeObject)nextNode).isStartControlflowNode()) {
                this.sequence.add(nextNode);
            }
        }

        @Override
        public int getHeight() {
            int topDataNodesHeight = NESTWorkflowLayout.this.getMaxNodeHeight(this.topDataNodes);
            int bottomDataNodesHeight = NESTWorkflowLayout.this.getMaxNodeHeight(this.bottomDataNodes);
            return NESTWorkflowLayout.this.getMaxNodeHeight(this.sequence) + (topDataNodesHeight > 0 ? topDataNodesHeight + NESTWorkflowLayout.this.layoutConfig.getTaskNodeToDataNodeVerticalSpacing() : 0) + (bottomDataNodesHeight > 0 ? bottomDataNodesHeight + NESTWorkflowLayout.this.layoutConfig.getTaskNodeToDataNodeVerticalSpacing() : 0);
        }

        @Override
        public int getTopHeight() {
            int topDataNodesHeight = NESTWorkflowLayout.this.getMaxNodeHeight(this.topDataNodes);
            return NESTWorkflowLayout.this.getMaxNodeHeight(this.sequence) / 2 + (topDataNodesHeight > 0 ? topDataNodesHeight + NESTWorkflowLayout.this.layoutConfig.getTaskNodeToDataNodeVerticalSpacing() : 0);
        }

        @Override
        public int getBottomHeight() {
            int bottomDataNodesHeight = NESTWorkflowLayout.this.getMaxNodeHeight(this.bottomDataNodes);
            return NESTWorkflowLayout.this.getMaxNodeHeight(this.sequence) / 2 + (bottomDataNodesHeight > 0 ? bottomDataNodesHeight + NESTWorkflowLayout.this.layoutConfig.getTaskNodeToDataNodeVerticalSpacing() : 0);
        }

        @Override
        public Map<NESTSequenceNodeObject, Sequence> getSequenceNodesToSequencesMapping() {
            HashMap<NESTSequenceNodeObject, Sequence> result = new HashMap<NESTSequenceNodeObject, Sequence>();
            this.sequence.forEach(node -> result.put((NESTSequenceNodeObject)node, this));
            return result;
        }

        @Override
        public void distributeDataNodes() {
            DataNodeDistribution distribution = new DataNodeDistribution(this.bottomDataNodes);
            this.bottomDataNodes = distribution.getBottomLayer();
            this.topDataNodes = distribution.getTopLayer();
        }

        @Override
        public Map<NESTNodeObject, Integer> getNodeVerticalPositions() {
            HashMap<NESTNodeObject, Integer> verticalPositions = new HashMap<NESTNodeObject, Integer>();
            int sequenceHeight = NESTWorkflowLayout.this.getMaxNodeHeight(this.sequence);
            this.sequence.forEach(sequenceNode -> verticalPositions.put((NESTNodeObject)sequenceNode, -((int)NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)sequenceNode).getHeight()) / 2));
            this.bottomDataNodes.forEach(dataNode -> verticalPositions.put((NESTNodeObject)dataNode, sequenceHeight / 2 + NESTWorkflowLayout.this.layoutConfig.getTaskNodeToDataNodeVerticalSpacing()));
            this.topDataNodes.forEach(dataNode -> verticalPositions.put((NESTNodeObject)dataNode, -sequenceHeight / 2 - ((int)NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)dataNode).getHeight() + NESTWorkflowLayout.this.layoutConfig.getTaskNodeToDataNodeVerticalSpacing())));
            return verticalPositions;
        }

        @Override
        public void calculateSequenceNodeHorizontalPositions() {
            HashMap<NESTSequenceNodeObject, Integer> xPositions = new HashMap<NESTSequenceNodeObject, Integer>();
            int currentX = 0;
            for (NESTSequenceNodeObject node : this.sequence) {
                Set inControlflowEdges = node.getIngoingEdges(DataObject::isNESTControlflowEdge);
                int maxEdgeLabelWidth = inControlflowEdges.stream().map(edge -> (int)NESTWorkflowLayout.this.getEdgeLabelSize((NESTEdgeObject)edge).getWidth()).max(Integer::compareTo).orElse(0);
                int maxEdgeWidth = inControlflowEdges.size() <= 0 ? 0 : maxEdgeLabelWidth + NESTWorkflowLayout.this.layoutConfig.getControlflowEdgeLabelHorizontalSpacing();
                int nodeDistance = Math.max(maxEdgeWidth, NESTWorkflowLayout.this.layoutConfig.getSequenceNodesHorizontalSpacing());
                int nodeX = currentX + nodeDistance;
                xPositions.put(node, nodeX);
                currentX = nodeX + (int)NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)node).getWidth();
            }
            NESTWorkflowLayout.this.nodeXPositions.putAll(xPositions);
            this.sequenceNodesXPositions = xPositions;
        }

        private Map<NESTSequenceNodeObject, Integer> getSequenceNodesXPositions() {
            return this.sequenceNodesXPositions;
        }

        private Map<NESTDataNodeObject, Integer> getDataNodesXPositions(Map<NESTSequenceNodeObject, Integer> sequenceNodesXPositions) {
            HashMap<NESTDataNodeObject, Integer> xPositions = new HashMap<NESTDataNodeObject, Integer>();
            Stream.of(this.getTopDataNodes(), this.getBottomDataNodes()).forEach(dataNodeLayer -> {
                IntervalOverlapResolver overlapResolver = new IntervalOverlapResolver(10);
                dataNodeLayer.forEach(dataNode -> {
                    int optimalX = this.getOptimalDataNodeXPosition((NESTDataNodeObject)dataNode, sequenceNodesXPositions);
                    overlapResolver.add(new IntervalOverlapResolver.Interval(optimalX, optimalX + (int)NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)dataNode).getWidth(), dataNode.getId(), (NESTDataNodeObject)dataNode){
                        final /* synthetic */ NESTDataNodeObject val$dataNode;
                        {
                            this.val$dataNode = nESTDataNodeObject;
                            super(start, end, id);
                        }

                        @Override
                        public int getShiftDistanceWeight() {
                            List foreignTasks = this.val$dataNode.getConnectedTasks().stream().filter(taskNode -> !Sequence.this.sequence.contains(taskNode)).collect(Collectors.toList());
                            return foreignTasks.stream().mapToInt(taskNode -> {
                                if (NESTWorkflowLayout.this.nodeXPositions.get(taskNode) == null) {
                                    return 1;
                                }
                                return (int)Math.signum(NESTWorkflowLayout.this.nodeXPositions.get(taskNode) - (NESTWorkflowLayout.this.currentBranchXOffset + this.getStart()));
                            }).sum();
                        }
                    });
                });
                List<IntervalOverlapResolver.Interval> nonOverlappingIntervals = overlapResolver.resolve();
                nonOverlappingIntervals.forEach(interval -> {
                    NESTDataNodeObject dataNode = dataNodeLayer.stream().filter(node -> node.getId().equals(interval.getId())).findAny().get();
                    xPositions.put(dataNode, interval.getStart());
                });
            });
            return xPositions;
        }

        private int getOptimalDataNodeXPosition(NESTDataNodeObject dataNode, Map<NESTSequenceNodeObject, Integer> sequenceNodesXPositions) {
            Set validNeighbours = dataNode.getEdges(DataObject::isNESTDataflowEdge).stream().flatMap(edge -> Stream.of(edge.getPost(), edge.getPre())).filter(sequenceNodesXPositions::containsKey).collect(Collectors.toSet());
            return (int)(validNeighbours.stream().mapToDouble(neighbour -> (double)((Integer)sequenceNodesXPositions.get(neighbour)).intValue() + NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)neighbour).getWidth() / 2.0).average().getAsDouble() - NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)dataNode).getWidth() / 2.0);
        }

        @Override
        public Map<NESTNodeObject, Integer> getNodesXPositions(int startX) {
            Map<NESTSequenceNodeObject, Integer> sequenceNodesXPositions = this.getSequenceNodesXPositions();
            HashMap<Object, Integer> xPositions = new HashMap<Object, Integer>();
            xPositions.putAll(sequenceNodesXPositions);
            xPositions.putAll(this.getDataNodesXPositions(sequenceNodesXPositions));
            int minX = xPositions.values().stream().min(Integer::compareTo).orElse(0);
            int shiftDistance = minX >= 0 ? 0 : -minX;
            return xPositions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Integer)entry.getValue() + startX + shiftDistance));
        }

        public NESTSequenceNodeObject getFirstNode() {
            return this.sequence.get(0);
        }

        public NESTSequenceNodeObject getLastNode() {
            return this.sequence.get(this.sequence.size() - 1);
        }

        public List<NESTSequenceNodeObject> getSequence() {
            return this.sequence;
        }

        public Set<NESTDataNodeObject> getBottomDataNodes() {
            return this.bottomDataNodes;
        }

        public Set<NESTDataNodeObject> getTopDataNodes() {
            return this.topDataNodes;
        }

        public boolean equals(Object o) {
            return o instanceof Sequence && ((Sequence)o).getFirstNode() == this.getFirstNode();
        }

        public int hashCode() {
            return this.getFirstNode().hashCode();
        }

        @Override
        public int compareTo(Sequence other) {
            return this.getFirstNode().getId().compareTo(other.getFirstNode().getId());
        }
    }

    class LoopSplit
    extends Split {
        public LoopSplit(List<Branch> branches) {
            super(branches);
        }

        @Override
        public Map<NESTNodeObject, Integer> getNodeVerticalPositions() {
            return this.size() <= 0 ? new HashMap<NESTNodeObject, Integer>() : ((Branch)this.get(0)).getNodeVerticalPositions();
        }

        @Override
        public int getHeight() {
            return ((Branch)this.get(0)).getHeight() + NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing() + NESTWorkflowLayout.this.layoutConfig.getNodeHeight() / 2;
        }

        @Override
        public int getTopHeight() {
            return ((Branch)this.get(0)).getTopHeight() + NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing() + NESTWorkflowLayout.this.layoutConfig.getNodeHeight() / 2;
        }

        @Override
        public int getBottomHeight() {
            return ((Branch)this.get(0)).getBottomHeight();
        }

        @Override
        public Map<NESTEdgeObject, List<Point>> getControlflowEdgePaths() {
            HashMap<NESTEdgeObject, List<Point>> edgePaths = new HashMap<NESTEdgeObject, List<Point>>();
            this.forEach(branch -> edgePaths.putAll(branch.getControlflowEdgePaths()));
            if (this.size() > 0) {
                Branch branch2 = (Branch)this.get(0);
                NESTEdgeObject loopReturnEdge = branch2.getOutgoingEdge().getPost().getOutgoingEdges().stream().filter(Utils::isEdgeLoopReturnEdge).findAny().get();
                NESTNodeObject loopEndNode = loopReturnEdge.getPre();
                NESTNodeObject loopStartNode = loopReturnEdge.getPost();
                int loopEndNodeCenterY = NESTWorkflowLayout.this.nodeYPositions.get(loopEndNode) - NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)loopEndNode).height / 2;
                int bendVerticalPosition = loopEndNodeCenterY - branch2.getTopHeight() - NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing() - NESTWorkflowLayout.this.layoutConfig.getNodeHeight() / 2;
                edgePaths.put(loopReturnEdge, new LinkedList<Point>(Arrays.asList(new Point(NESTWorkflowLayout.this.nodeXPositions.get(loopEndNode) + NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)loopEndNode).width / 2, bendVerticalPosition), new Point(NESTWorkflowLayout.this.nodeXPositions.get(loopStartNode) + NESTWorkflowLayout.this.getNodeSize((NESTNodeObject)loopStartNode).width / 2, bendVerticalPosition))));
            }
            return edgePaths;
        }
    }

    class Split
    extends LinkedList<Branch>
    implements Controlflow {
        public Split(List<Branch> branches) {
            super(branches);
        }

        @Override
        public Map<NESTNodeObject, Integer> getNodeVerticalPositions() {
            HashMap<NESTNodeObject, Integer> verticalPositions = new HashMap<NESTNodeObject, Integer>();
            if (this.size() > 0) {
                Branch topBranch = (Branch)this.get(0);
                Map<NESTNodeObject, Integer> topBranchVerticalPositions = topBranch.getNodeVerticalPositions();
                verticalPositions.putAll(topBranchVerticalPositions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() - (topBranch.getBottomHeight() + this.getControlflowNodeHeight() / 2 + NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing()))));
            }
            if (this.size() > 1) {
                Branch bottomBranch = (Branch)this.get(1);
                Map<NESTNodeObject, Integer> bottomBranchVerticalPositions = bottomBranch.getNodeVerticalPositions();
                verticalPositions.putAll(bottomBranchVerticalPositions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + (bottomBranch.getTopHeight() + this.getControlflowNodeHeight() / 2 + NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing()))));
            }
            return verticalPositions;
        }

        private int getControlflowNodeHeight() {
            return (int)NESTWorkflowLayout.this.getNodeSize(((Branch)this.get(0)).getIngoingEdge().getPre()).getHeight();
        }

        @Override
        public int getHeight() {
            int topBranchHeight = this.size() > 0 ? ((Branch)this.get(0)).getHeight() : NESTWorkflowLayout.this.layoutConfig.getNodeHeight();
            int bottomBranchHeight = this.size() > 1 ? ((Branch)this.get(1)).getHeight() : NESTWorkflowLayout.this.layoutConfig.getNodeHeight();
            return topBranchHeight + bottomBranchHeight + this.getControlflowNodeHeight() + 2 * NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing();
        }

        @Override
        public int getTopHeight() {
            int topBranchHeight = this.size() > 0 ? ((Branch)this.get(0)).getHeight() : NESTWorkflowLayout.this.layoutConfig.getNodeHeight();
            return topBranchHeight + this.getControlflowNodeHeight() / 2 + NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing();
        }

        @Override
        public int getBottomHeight() {
            int bottomBranchHeight = this.size() > 1 ? ((Branch)this.get(1)).getHeight() : NESTWorkflowLayout.this.layoutConfig.getNodeHeight();
            return bottomBranchHeight + this.getControlflowNodeHeight() / 2 + NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing();
        }

        @Override
        public Map<NESTSequenceNodeObject, Sequence> getSequenceNodesToSequencesMapping() {
            HashMap<NESTSequenceNodeObject, Sequence> result = new HashMap<NESTSequenceNodeObject, Sequence>();
            this.forEach(branch -> result.putAll(branch.getSequenceNodesToSequencesMapping()));
            return result;
        }

        @Override
        public void distributeDataNodes() {
            this.forEach(Branch::distributeDataNodes);
        }

        @Override
        public void calculateSequenceNodeHorizontalPositions() {
            this.forEach(Branch::calculateSequenceNodeHorizontalPositions);
        }

        @Override
        public Map<NESTNodeObject, Integer> getNodesXPositions(int startX) {
            HashMap<NESTNodeObject, Integer> xPositions = new HashMap<NESTNodeObject, Integer>();
            this.forEach(branch -> xPositions.putAll(branch.getNodesXPositions(startX)));
            return xPositions;
        }

        public Map<NESTEdgeObject, List<Point>> getControlflowEdgePaths() {
            HashMap<NESTEdgeObject, List<Point>> edgePaths = new HashMap<NESTEdgeObject, List<Point>>();
            this.forEach(branch -> edgePaths.putAll(branch.getControlflowEdgePaths()));
            this.forEach(branch -> {
                NESTNodeObject controlflowEndNode;
                LinkedList<Point> ingoingEdgePath = new LinkedList<Point>();
                NESTEdgeObject ingoingEdge = branch.getIngoingEdge();
                NESTEdgeObject outgoingEdge = branch.getOutgoingEdge();
                NESTNodeObject controlflowStartNode = ingoingEdge.getPre();
                NESTNodeObject nESTNodeObject = controlflowEndNode = outgoingEdge != null ? outgoingEdge.getPost() : null;
                if (ingoingEdge == outgoingEdge) {
                    Branch otherBranch = this.get(0) == branch ? (this.size() >= 2 ? (Branch)this.get(1) : null) : (Branch)this.get(0);
                    int sign = otherBranch == null ? -1 : Integer.signum(branch.compareTo(otherBranch));
                    int bendVerticalPosition = (int)((double)NESTWorkflowLayout.this.getCenterY(controlflowStartNode) + (double)sign * (NESTWorkflowLayout.this.getNodeSize(controlflowStartNode).getHeight() / 2.0 + (double)NESTWorkflowLayout.this.layoutConfig.getSequenceNodeVerticalSpacing() + (double)(NESTWorkflowLayout.this.layoutConfig.getNodeHeight() / 2)));
                    ingoingEdgePath.add(new Point(NESTWorkflowLayout.this.getCenterX(controlflowStartNode), bendVerticalPosition));
                    ingoingEdgePath.add(new Point(NESTWorkflowLayout.this.getCenterX(controlflowEndNode), bendVerticalPosition));
                } else {
                    int bendVerticalPosition = NESTWorkflowLayout.this.getCenterY(ingoingEdge.getPost());
                    ingoingEdgePath.add(new Point(NESTWorkflowLayout.this.getCenterX(controlflowStartNode), bendVerticalPosition));
                    if (controlflowEndNode != null) {
                        edgePaths.put(outgoingEdge, new LinkedList<Point>(Collections.singletonList(new Point(NESTWorkflowLayout.this.getCenterX(controlflowEndNode), bendVerticalPosition))));
                    }
                }
                edgePaths.put(ingoingEdge, ingoingEdgePath);
            });
            return edgePaths;
        }
    }

    class DataNodeDistribution {
        Map<NESTDataNodeObject, Integer> xPositions = new HashMap<NESTDataNodeObject, Integer>();
        Set<NESTDataNodeObject> topLayer = new HashSet<NESTDataNodeObject>();
        Set<NESTDataNodeObject> bottomLayer = new HashSet<NESTDataNodeObject>();
        Map<NESTNodeObject, Integer> nodePositions = new HashMap<NESTNodeObject, Integer>();

        public DataNodeDistribution(Set<NESTDataNodeObject> dataNodes) {
            if (dataNodes.size() > 2) {
                this.distribute(dataNodes);
            } else {
                this.bottomLayer.addAll(dataNodes);
            }
        }

        private void distribute(Set<NESTDataNodeObject> dataNodes) {
            this.nodePositions.putAll(NESTWorkflowLayout.this.getDataNodesCenterXPositions(dataNodes));
            this.nodePositions.putAll(NESTWorkflowLayout.this.getTaskNodesCenterXPositions());
            HashMap<List<List<NESTDataNodeObject>>, Integer> solutions = new HashMap<List<List<NESTDataNodeObject>>, Integer>();
            for (List<List<NESTDataNodeObject>> list : new PartitionIterable<NESTDataNodeObject>(new LinkedList<NESTDataNodeObject>(dataNodes), 2)) {
                solutions.put(list, this.edgeCrossingsInSolution(list));
            }
            int minCrossings = (Integer)solutions.values().stream().min(Integer::compareTo).get();
            List list = (List)solutions.entrySet().stream().filter(entry -> (Integer)entry.getValue() == minCrossings).findFirst().get().getKey();
            if (((List)list.get(0)).size() < ((List)list.get(1)).size()) {
                this.topLayer.addAll((Collection)list.get(0));
                this.bottomLayer.addAll((Collection)list.get(1));
            } else {
                this.topLayer.addAll((Collection)list.get(1));
                this.bottomLayer.addAll((Collection)list.get(0));
            }
        }

        private int edgeCrossingsInSolution(List<List<NESTDataNodeObject>> solution) {
            return solution.stream().map(this::getEdgeCrossings).mapToInt(Integer::intValue).sum();
        }

        private int getEdgeCrossings(List<NESTDataNodeObject> dataNodes) {
            Set dataflowEdges = dataNodes.stream().map(dataNode -> dataNode.getEdges(DataObject::isNESTDataflowEdge).stream().filter(edge -> edge.getPost().isNESTTaskNode()).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
            return dataflowEdges.stream().map(currentEdge -> dataflowEdges.stream().filter(otherEdge -> this.isCrossing((NESTEdgeObject)currentEdge, (NESTEdgeObject)otherEdge)).count()).mapToInt(Long::intValue).sum();
        }

        private boolean isCrossing(NESTEdgeObject edgeA, NESTEdgeObject edgeB) {
            HashSet<NESTNodeObject> endpoints = new HashSet<NESTNodeObject>(Arrays.asList(edgeA.getPre(), edgeA.getPost(), edgeB.getPre(), edgeB.getPost()));
            if (endpoints.size() < 4) {
                return false;
            }
            NESTNodeObject edgeATaskNode = edgeA.getPre().isNESTTaskNode() ? edgeA.getPre() : edgeA.getPost();
            NESTNodeObject edgeADataNode = edgeA.getPre().isNESTDataNode() ? edgeA.getPre() : edgeA.getPost();
            NESTNodeObject edgeBTaskNode = edgeB.getPre().isNESTTaskNode() ? edgeB.getPre() : edgeB.getPost();
            NESTNodeObject edgeBDataNode = edgeB.getPre().isNESTDataNode() ? edgeB.getPre() : edgeB.getPost();
            return ObjectUtils.allNotNull((Object[])new Object[]{edgeATaskNode, edgeADataNode, edgeBTaskNode, edgeBDataNode}) && (this.nodePositions.get(edgeATaskNode) < this.nodePositions.get(edgeBTaskNode) && this.nodePositions.get(edgeADataNode) > this.nodePositions.get(edgeBDataNode) || this.nodePositions.get(edgeATaskNode) > this.nodePositions.get(edgeBTaskNode) && this.nodePositions.get(edgeADataNode) < this.nodePositions.get(edgeBDataNode));
        }

        public Map<NESTDataNodeObject, Integer> getxPositions() {
            return this.xPositions;
        }

        public Set<NESTDataNodeObject> getTopLayer() {
            return this.topLayer;
        }

        public Set<NESTDataNodeObject> getBottomLayer() {
            return this.bottomLayer;
        }
    }

    static interface Controlflow {
        public Map<NESTNodeObject, Integer> getNodeVerticalPositions();

        public int getHeight();

        public int getTopHeight();

        public int getBottomHeight();

        public Map<NESTSequenceNodeObject, Sequence> getSequenceNodesToSequencesMapping();

        public void distributeDataNodes();

        public void calculateSequenceNodeHorizontalPositions();

        public Map<NESTNodeObject, Integer> getNodesXPositions(int var1);
    }
}

