/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.Model;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;

public class EdgeCreationListener
implements mxEventSource.mxIEventListener {
    private final mxGraph mxGraph;

    public EdgeCreationListener(mxGraph mxGraph2) {
        this.mxGraph = mxGraph2;
    }

    public void invoke(Object sender, mxEventObject mxEventObject2) {
        NESTNodeObject post;
        mxCell edgeCell = (mxCell)mxEventObject2.getProperty("cell");
        NESTNodeObject pre = (NESTNodeObject)edgeCell.getSource().getValue();
        NESTEdgeObject newNESTEdge = this.insertSuitableEdge(pre, post = (NESTNodeObject)edgeCell.getTarget().getValue());
        if (newNESTEdge == null) {
            System.err.println("No suitable edge class for node connection of type " + pre.getDataClass().getName() + " -> " + post.getDataClass().getName() + " found.");
            this.mxGraph.removeCells(new Object[]{edgeCell});
            return;
        }
        edgeCell.setValue((Object)newNESTEdge);
        ((NESTWorkflowEditor.CustomGraph)this.mxGraph).setCellId((mxICell)edgeCell, newNESTEdge.getId());
        this.mxGraph.getModel().setStyle((Object)edgeCell, NESTWorkflowEditor.CellStyle.get((NESTEdgeObject)edgeCell.getValue()));
        if (((NESTWorkflowEditor.CustomGraph)this.mxGraph).getLayout().isExecuteOnEdgeInsertion()) {
            ((NESTWorkflowEditor.CustomGraph)this.mxGraph).executeLayout();
        }
    }

    private NESTEdgeObject insertSuitableEdge(NESTNodeObject pre, NESTNodeObject post) {
        if (pre == null || post == null) {
            return null;
        }
        NESTGraphObject workflow = pre.getGraph();
        Model model = workflow.getModel();
        String edgeClassName = Utils.getEdgeClassForNodeConnection(pre, post);
        if (edgeClassName != null) {
            NESTEdgeObject edge = (NESTEdgeObject)model.createObject(edgeClassName);
            workflow.getIDManager().assignUniqueEdgeId(edge);
            edge.setGraph(workflow);
            edge.setPre(pre);
            edge.setPost(post);
            return edge;
        }
        return null;
    }
}

