/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.base.InstanceEnumerationPredicate;
import de.uni_trier.wi2.procake.data.model.base.InstanceTaxonomyOrderPredicate;
import de.uni_trier.wi2.procake.data.model.base.UnionClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.data.object.base.CollectionObject;
import de.uni_trier.wi2.procake.data.object.base.ListObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTSequentialWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.objectpool.DataObjectIterator;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.CellLabelGenerator;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.SemanticDescriptorEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.BasicGridLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.misc.AutoCompletion;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import de.uni_trier.wi2.procake.utils.exception.InvalidNativeValueException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataObjectEditor
extends JPanel {
    protected DataObject dataObject;
    private String parentAttributeName;

    public DataObjectEditor(DataObject dataObject) {
        this.dataObject = dataObject;
        this.setLayout(new GridLayout(1, 1));
        this.load();
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    private void load() {
        if (this.dataObject == null) {
            this.add(new JLabel("null"));
        } else if (this.dataObject.isList()) {
            this.add(new ListObjectEditor((ListObject)this.dataObject));
        } else if (this.dataObject.isCollection()) {
            this.add(new CollectionObjectEditor((CollectionObject)this.dataObject));
        } else if (this.dataObject.isVoid()) {
            this.add(new JLabel(this.dataObject.getDataClass().getName()));
        } else if (this.dataObject.isAggregate()) {
            this.add(new AggregateObjectEditor((AggregateObject)this.dataObject));
        } else if (this.dataObject.isAtomic()) {
            AtomicObject atomicObject = (AtomicObject)this.dataObject;
            if (atomicObject.getAtomicClass().getInstanceTaxonomyOrderPredicate() != null) {
                this.add(new EnumerationWithTaxonomyEditor(atomicObject));
            } else if (atomicObject.getAtomicClass().getInstanceEnumerationPredicate() != null) {
                this.add(new EnumerationEditor(atomicObject));
            } else {
                this.add(new AtomicObjectEditor(atomicObject));
            }
        } else if (this.dataObject.isNESTWorkflow()) {
            JButton openNESTWorkflowButton = new JButton("Open NESTWorkflow " + this.dataObject.getId());
            openNESTWorkflowButton.addActionListener(e -> new NESTWorkflowEditor((NESTAbstractWorkflowObject)((NESTWorkflowObject)this.dataObject)));
            this.add(openNESTWorkflowButton);
        } else if (this.dataObject.isNESTSequentialWorkflow()) {
            JButton openNESTWorkflowButton = new JButton("Open NESTSequentialWorkflow " + this.dataObject.getId());
            openNESTWorkflowButton.addActionListener(e -> new NESTWorkflowEditor((NESTAbstractWorkflowObject)((NESTSequentialWorkflowObject)this.dataObject)));
            this.add(openNESTWorkflowButton);
        } else {
            this.add(new JLabel("unsupported data object: " + this.dataObject.getDataClass().getName()));
        }
    }

    void reload() {
        this.removeAll();
        this.load();
        this.updateUI();
        this.updateSemanticDescriptorEditorBounds();
    }

    private LinkedList<String> getAttributeNamePath() {
        if (this.parentAttributeName == null) {
            return new LinkedList<String>();
        }
        DataObjectEditor parentEditor = (DataObjectEditor)this.getParent().getParent();
        LinkedList<String> path = parentEditor.getAttributeNamePath();
        path.add(this.parentAttributeName);
        return path;
    }

    private DataObject getRootDataObject() {
        if (this.parentAttributeName == null) {
            return this.dataObject;
        }
        DataObjectEditor parentEditor = (DataObjectEditor)this.getParent().getParent();
        return parentEditor.getRootDataObject();
    }

    public void setDataObject(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    private void updateSemanticDescriptorEditorBounds() {
        Container semanticDescriptorEditorPanel = SwingUtilities.getAncestorNamed(SemanticDescriptorEditor.SEMANTIC_DESCRIPTOR_EDITOR_COMPONENT_NAME, this);
        if (semanticDescriptorEditorPanel != null) {
            Dimension preferredSize = semanticDescriptorEditorPanel.getPreferredSize();
            Rectangle currentBounds = semanticDescriptorEditorPanel.getBounds();
            Rectangle newBounds = new Rectangle((int)currentBounds.getX(), (int)currentBounds.getY(), Math.max((int)preferredSize.getWidth(), (int)currentBounds.getWidth()), Math.max((int)preferredSize.getHeight(), (int)currentBounds.getHeight()));
            semanticDescriptorEditorPanel.setBounds(newBounds);
        }
    }

    private JButton getDataObjectCreationButton(DataClass dataClass, Consumer<DataObject> newDataObjectConsumer) {
        JButton createDataObjectButton = new JButton("+");
        createDataObjectButton.addActionListener(e -> {
            if (!dataClass.isUnion() && dataClass.getSubClasses().size() <= 0) {
                newDataObjectConsumer.accept(dataClass.newObject());
                return;
            }
            List<Object> classes = Utils.getSubClassesDeep(dataClass);
            classes.add(0, dataClass);
            if (dataClass.isUnion()) {
                classes = Arrays.stream(((UnionClass)dataClass).getClasses()).map(dataClass1 -> {
                    List<DataClass> classesDeep = Utils.getSubClassesDeep(dataClass1);
                    classesDeep.add(0, dataClass);
                    return classesDeep;
                }).flatMap(Collection::stream).collect(Collectors.toList());
            }
            JComboBox<DataClass> newDataObjectClassSelection = new JComboBox<DataClass>(classes.toArray(new DataClass[classes.size()]));
            newDataObjectClassSelection.setRenderer(new DataClassHierarchyListCellRenderer(newDataObjectClassSelection.getRenderer(), dataClass));
            AutoCompletion.enable(newDataObjectClassSelection);
            WindowPopup classSelectionPopup = new WindowPopup(SwingUtilities.getWindowAncestor(this), newDataObjectClassSelection);
            newDataObjectClassSelection.addActionListener(e2 -> {
                DataClass selectedDataClass = (DataClass)newDataObjectClassSelection.getSelectedItem();
                if (selectedDataClass != null && selectedDataClass.isInstantiable()) {
                    newDataObjectConsumer.accept(selectedDataClass.newObject());
                }
                if (e2.getActionCommand().equals("comboBoxEdited") && classSelectionPopup != null) {
                    classSelectionPopup.dispatchEvent(new WindowEvent(classSelectionPopup, 201));
                }
            });
            newDataObjectClassSelection.setSelectedItem(newDataObjectClassSelection.getSelectedItem());
        });
        return createDataObjectButton;
    }

    class ListObjectEditor
    extends JPanel {
        private ListObject listObject;

        ListObjectEditor(ListObject listObject) {
            this.listObject = listObject;
            this.setLayout(new BasicGridLayout(0, 3, 5, 5));
            for (int i = 0; i < listObject.getValues().size(); ++i) {
                DataObject listElement = listObject.elementAt(i);
                this.add(this.createRemoveCollectionElementButton(listElement));
                this.add(this.createDragAndDropEnabledIndexLabel(i));
                this.add(new DataObjectEditor(listElement));
            }
            this.add(this.createAddCollectionElementButton());
        }

        private JLabel createDragAndDropEnabledIndexLabel(final int index) {
            JLabel indexLabel = new JLabel(index + ":");
            indexLabel.setToolTipText("Drag and drop to change order");
            final DataFlavor integerFlavor = new DataFlavor(Integer.class, "An Integer Object");
            new DragSource().createDefaultDragGestureRecognizer(indexLabel, 2, new DragGestureListener(){

                @Override
                public void dragGestureRecognized(DragGestureEvent event) {
                    Cursor cursor = Cursor.getDefaultCursor();
                    cursor = DragSource.DefaultMoveDrop;
                    event.startDrag(cursor, new Transferable(){

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return new DataFlavor[]{integerFlavor};
                        }

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return flavor.equals(integerFlavor);
                        }

                        @Override
                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                            if (flavor.equals(integerFlavor)) {
                                return index;
                            }
                            throw new UnsupportedFlavorException(flavor);
                        }
                    });
                }
            });
            new DropTarget(indexLabel, 2, new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent event) {
                    try {
                        int draggedIndex = (Integer)event.getTransferable().getTransferData(integerFlavor);
                        if (event.isDataFlavorSupported(integerFlavor)) {
                            event.acceptDrop(2);
                            ListObjectEditor.this.moveListElement(draggedIndex, index);
                            DataObjectEditor.this.reload();
                            event.dropComplete(true);
                            return;
                        }
                        event.rejectDrop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        event.rejectDrop();
                    }
                }
            }, true, null);
            return indexLabel;
        }

        private void moveListElement(int index, int newIndex) {
            int maxIndex = this.listObject.size() - 1;
            if (index <= maxIndex && newIndex <= maxIndex) {
                DataObject element = this.listObject.elementAt(index);
                this.listObject.insertAt(element, newIndex);
                int offset = newIndex <= index ? 1 : 0;
                this.listObject.removeAt(index + offset);
            }
        }

        private void swapListElements(int indexA, int indexB) {
            int maxIndex = this.listObject.size() - 1;
            if (indexA <= maxIndex && indexB <= maxIndex) {
                DataObject elementA = this.listObject.elementAt(indexA);
                DataObject elementB = this.listObject.elementAt(indexB);
                this.listObject.insertAt(elementB, indexA);
                this.listObject.removeAt(indexA + 1);
                this.listObject.insertAt(elementA, indexB);
                this.listObject.removeAt(indexB + 1);
            }
        }

        private JButton createAddCollectionElementButton() {
            JButton addCollectionElementButton = DataObjectEditor.this.getDataObjectCreationButton(this.listObject.getCollectionClass().getElementClass(), dataObject -> {
                this.listObject.addValue(dataObject);
                DataObjectEditor.this.reload();
            });
            addCollectionElementButton.setMargin(new Insets(0, 0, 0, 0));
            return addCollectionElementButton;
        }

        private JButton createRemoveCollectionElementButton(DataObject elementToBeRemoved) {
            JButton removeCollectionElementButton = new JButton("-");
            removeCollectionElementButton.setMargin(new Insets(0, 0, 0, 0));
            removeCollectionElementButton.addActionListener(e -> {
                this.listObject.removeValue(elementToBeRemoved);
                DataObjectEditor.this.reload();
            });
            return removeCollectionElementButton;
        }
    }

    class CollectionObjectEditor
    extends JPanel {
        private CollectionObject collectionObject;

        public CollectionObjectEditor(CollectionObject collectionObject) {
            this.collectionObject = collectionObject;
            this.setLayout(new BasicGridLayout(1, 2, 5, 5));
            DataObjectIterator iterator = collectionObject.iterator();
            while (iterator.hasNext()) {
                DataObject nextDataObject = iterator.nextDataObject();
                this.add(this.createRemoveCollectionElementButton(nextDataObject));
                this.add(new DataObjectEditor(nextDataObject));
            }
            this.add(this.createAddCollectionElementButton());
        }

        private JButton createAddCollectionElementButton() {
            JButton dataObjectCreationButton = DataObjectEditor.this.getDataObjectCreationButton(this.collectionObject.getCollectionClass().getElementClass(), dataObject -> {
                this.collectionObject.addValue(dataObject);
                DataObjectEditor.this.reload();
            });
            dataObjectCreationButton.setMargin(new Insets(0, 0, 0, 0));
            return dataObjectCreationButton;
        }

        private JButton createRemoveCollectionElementButton(DataObject elementToBeRemoved) {
            JButton removeCollectionElementButton = new JButton("-");
            removeCollectionElementButton.addActionListener(e -> {
                this.collectionObject.removeValue(elementToBeRemoved);
                DataObjectEditor.this.reload();
            });
            removeCollectionElementButton.setMargin(new Insets(0, 0, 0, 0));
            return removeCollectionElementButton;
        }
    }

    class AggregateObjectEditor
    extends JPanel {
        public AggregateObjectEditor(AggregateObject aggregateObject) {
            List attributeNames = aggregateObject.getAggregateClass().getAttributeNames();
            BasicGridLayout basicGridLayout = new BasicGridLayout(0, 2, 5, 5);
            this.setLayout(basicGridLayout);
            for (String attributeName : attributeNames) {
                DataObject attributeDataObject = aggregateObject.getAttributeValue(attributeName);
                JPanel labelAndButtonPanel = new JPanel(new FlowLayout(2, 0, 0));
                labelAndButtonPanel.add(this.createAttributeNameLabel(attributeName, aggregateObject));
                if (attributeDataObject == null) {
                    labelAndButtonPanel.add(this.createAttributeValueAddButton(attributeName, aggregateObject));
                } else {
                    labelAndButtonPanel.add(this.createAttributeValueDeleteButton(attributeName, aggregateObject));
                }
                this.add(labelAndButtonPanel);
                DataObjectEditor dataObjectEditor = new DataObjectEditor(attributeDataObject);
                dataObjectEditor.parentAttributeName = attributeName;
                this.add(dataObjectEditor);
            }
        }

        private JButton createAttributeValueAddButton(String attributeName, AggregateObject aggregateObject) {
            DataClass attributeDataClass = aggregateObject.getAggregateClass().getAttributeType(attributeName);
            Consumer<DataObject> newDataObjectConsumer = dataObject -> {
                aggregateObject.setAttributeValue(attributeName, dataObject);
                DataObjectEditor.this.reload();
            };
            JButton button = DataObjectEditor.this.getDataObjectCreationButton(attributeDataClass, newDataObjectConsumer);
            button.setPreferredSize(new Dimension(15, 15));
            button.setMargin(new Insets(0, 0, 0, 0));
            return button;
        }

        private JButton createAttributeValueDeleteButton(String attributeName, AggregateObject aggregateObject) {
            JButton button = new JButton();
            button.setPreferredSize(new Dimension(15, 15));
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setText("x");
            button.addActionListener(e -> {
                aggregateObject.setAttributeValue(attributeName, null);
                ((DataObjectEditor)this.getParent()).reload();
            });
            return button;
        }

        private JLabel createAttributeNameLabel(String attributeName, AggregateObject aggregateObject) {
            DataClass attributeClass = aggregateObject.getAggregateClass().getAttributeType(attributeName);
            List attributeDataObjectSuperClassesNames = Arrays.stream(attributeClass.getSuperClasses()).map(DataClass::getName).collect(Collectors.toList());
            JLabel attributeNameLabel = new JLabel(attributeName + ": ");
            attributeNameLabel.setHorizontalAlignment(4);
            attributeNameLabel.setToolTipText(attributeClass.getName() + " -> " + String.join((CharSequence)" -> ", attributeDataObjectSuperClassesNames));
            attributeNameLabel.setComponentPopupMenu(this.createPopupMenuForAttributeNameLabel(attributeName, aggregateObject));
            return attributeNameLabel;
        }

        private JPopupMenu createPopupMenuForAttributeNameLabel(String attributeName, AggregateObject aggregateObject) {
            DataObject attributeDataObject = aggregateObject.getAttributeValue(attributeName);
            JPopupMenu menu = new JPopupMenu();
            if (attributeDataObject != null) {
                menu.add(new JMenuItem("null")).addActionListener(e -> {
                    aggregateObject.setAttributeValue(attributeName, null);
                    DataObjectEditor.this.reload();
                });
                menu.addSeparator();
            }
            menu.add(new JMenuItem("Set as label")).addActionListener(e -> {
                NESTWorkflowEditor.CustomGraphComponent graphComponent = (NESTWorkflowEditor.CustomGraphComponent)((SemanticDescriptorEditor.EditorWindow)SwingUtilities.getAncestorNamed(SemanticDescriptorEditor.SEMANTIC_DESCRIPTOR_EDITOR_COMPONENT_NAME, this)).getGraphComponent();
                CellLabelGenerator cellLabelGenerator = ((NESTWorkflowEditor.CustomGraph)graphComponent.getGraph()).getCellLabelGenerator();
                Map<String, Queue<String>> dataClassNameToLabelPathMapping = cellLabelGenerator.getDataClassNameToLabelPathMapping();
                LinkedList<String> attributePath = DataObjectEditor.this.getAttributeNamePath();
                attributePath.addLast(attributeName);
                dataClassNameToLabelPathMapping.put(DataObjectEditor.this.getRootDataObject().getDataClass().getName(), attributePath);
                graphComponent.updateAllCellLabels();
            });
            return menu;
        }
    }

    class EnumerationWithTaxonomyEditor
    extends JPanel {
        public EnumerationWithTaxonomyEditor(AtomicObject atomicObject) {
            this.setLayout(new BasicGridLayout(1, 2));
            InstanceEnumerationPredicate predicate = atomicObject.getAtomicClass().getInstanceEnumerationPredicate();
            InstanceTaxonomyOrderPredicate validValueOrder = predicate.getAtomicClass().getInstanceTaxonomyOrderPredicate();
            List<AtomicObject> possibleValues = validValueOrder != null ? this.collectTaxonomyValuesOrdered(validValueOrder, validValueOrder.getRoot()) : predicate.getValues();
            JComboBox<AtomicObject> enumerationSelection = new JComboBox<AtomicObject>();
            ListCellRenderer defaultRenderer = enumerationSelection.getRenderer();
            enumerationSelection.setModel(new DefaultComboBoxModel<AtomicObject>(possibleValues.toArray(new AtomicObject[0])));
            enumerationSelection.setRenderer(new TaxonomyOrderListCellRenderer(defaultRenderer, validValueOrder));
            AtomicObject objectToSelect = possibleValues.stream().filter(possibleValue -> possibleValue.getNativeObject().equals(atomicObject.getNativeObject())).findFirst().get();
            enumerationSelection.setSelectedItem(objectToSelect);
            enumerationSelection.addActionListener(e -> atomicObject.setNativeObject(((AtomicObject)enumerationSelection.getSelectedItem()).getNativeObject()));
            this.add(enumerationSelection);
        }

        private JPopupMenu getTaxonomyOrderPopupMenu(InstanceEnumerationPredicate predicate, Consumer<InstanceTaxonomyOrderPredicate> selectedValueOrderConsumer) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new JMenuItem("No value order")).addActionListener(e -> selectedValueOrderConsumer.accept(null));
            menu.addSeparator();
            return menu;
        }

        private List<AtomicObject> collectTaxonomyValuesOrdered(InstanceTaxonomyOrderPredicate taxonomyOrder, AtomicObject node) {
            LinkedList<AtomicObject> result = new LinkedList<AtomicObject>();
            result.add(node);
            AtomicObject[] sons = taxonomyOrder.getSons(node);
            if (sons.length > 0) {
                for (AtomicObject son : sons) {
                    result.addAll(this.collectTaxonomyValuesOrdered(taxonomyOrder, son));
                }
            }
            return result;
        }

        class TaxonomyOrderListCellRenderer
        implements ListCellRenderer {
            private final ListCellRenderer originalRenderer;
            private final InstanceTaxonomyOrderPredicate taxonomyOrder;

            public TaxonomyOrderListCellRenderer(ListCellRenderer originalRenderer, InstanceTaxonomyOrderPredicate taxonomyOrder) {
                this.originalRenderer = originalRenderer;
                this.taxonomyOrder = taxonomyOrder;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return this.originalRenderer.getListCellRendererComponent(list, this.toStringIndented(value), index, isSelected, cellHasFocus);
            }

            private String toStringIndented(Object object) {
                AtomicObject value = (AtomicObject)object;
                if (this.taxonomyOrder == null) {
                    return value.getNativeObject().toString();
                }
                int depth = 0;
                AtomicObject father = this.taxonomyOrder.getFather(value);
                while (father != null) {
                    father = this.taxonomyOrder.getFather(father);
                    ++depth;
                }
                return "| ".repeat(Math.max(depth - 1, 0)) + (depth <= 0 ? "" : "|-") + value.getNativeObject().toString();
            }
        }
    }

    class EnumerationEditor
    extends JPanel {
        public EnumerationEditor(AtomicObject atomicObject) {
            this.setLayout(new GridLayout(1, 1));
            List<Object> possibleValues = atomicObject.getAtomicClass().getInstanceEnumerationPredicate().getValues().stream().map(AtomicObject::getNativeObject).sorted(Comparator.comparing(Object::toString, String.CASE_INSENSITIVE_ORDER)).toList();
            JComboBox<Object> enumerationSelection = new JComboBox<Object>(possibleValues.toArray());
            AutoCompletion.enable(enumerationSelection);
            enumerationSelection.setSelectedItem(atomicObject.getNativeObject().toString());
            enumerationSelection.addActionListener(e -> atomicObject.setNativeObject(enumerationSelection.getSelectedItem()));
            this.add(enumerationSelection);
        }
    }

    class AtomicObjectEditor
    extends JPanel {
        public AtomicObjectEditor(final AtomicObject atomicObject) {
            this.setLayout(new GridLayout(1, 1));
            Object object = atomicObject.getNativeObject();
            String text = object != null ? object.toString() : "";
            final JTextArea input = new JTextArea(text);
            if (text.length() <= 10) {
                input.setColumns(10);
            }
            input.setBorder(BorderFactory.createEmptyBorder());
            input.getDocument().addDocumentListener(new DocumentListener(){

                private void updateNativeObject() {
                    try {
                        input.setBackground(Color.WHITE);
                        atomicObject.setValueFromString(input.getText());
                    }
                    catch (InvalidNativeValueException e) {
                        input.setBackground(new Color(255, 170, 166));
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateNativeObject();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateNativeObject();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateNativeObject();
                }
            });
            this.add(input);
        }
    }

    class DataClassHierarchyListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer originalRenderer;
        private final List<DataClass> parentClasses;

        public DataClassHierarchyListCellRenderer(ListCellRenderer originalRenderer, DataClass parentClass) {
            this.originalRenderer = originalRenderer;
            this.parentClasses = parentClass.isUnion() ? Arrays.asList(((UnionClass)parentClass).getClasses()) : Collections.singletonList(parentClass);
        }

        private String toStringIndented(Object dataClass) {
            DataClass value = (DataClass)dataClass;
            DataClass matchingParentClass = this.parentClasses.stream().filter(dataClass1 -> new HashSet<DataClass>(Arrays.asList(value.getSuperClasses())).contains(dataClass1)).findFirst().orElse(null);
            int baseClassOffset = matchingParentClass == null ? value.getSuperClasses().length : matchingParentClass.getSuperClasses().length;
            int depth = value.getSuperClasses().length - baseClassOffset;
            return "| ".repeat(Math.max(depth - 1, 0)) + (depth <= 0 ? "" : "|-") + value.getName();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.originalRenderer.getListCellRendererComponent(list, this.toStringIndented(value), index, isSelected, cellHasFocus);
        }
    }

    class WindowPopup
    extends JDialog {
        public WindowPopup(Window owner, Component component) {
            super(owner);
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    WindowPopup.this.dispose();
                }
            });
            this.setUndecorated(true);
            this.add(component);
            this.pack();
            this.setLocation(MouseInfo.getPointerInfo().getLocation());
            this.setVisible(true);
        }
    }
}

