/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.NESTAbstractWorkflowModifier;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CellRemoveListener
implements mxEventSource.mxIEventListener {
    public void invoke(Object sender, mxEventObject mxEventObject2) {
        NESTWorkflowEditor.CustomGraph mxGraph2 = (NESTWorkflowEditor.CustomGraph)((Object)sender);
        NESTAbstractWorkflowModifier modifier = mxGraph2.getNestWorkflow().getModifier();
        Set removedCells = Arrays.stream((Object[])mxEventObject2.getProperty("cells")).map(mxCell.class::cast).collect(Collectors.toCollection(HashSet::new));
        removedCells.forEach(removedCell -> {
            if (removedCell != null && removedCell.getValue() instanceof NESTGraphItemObject) {
                NESTGraphItemObject graphItem = (NESTGraphItemObject)removedCell.getValue();
                if (graphItem.isNESTEdge()) {
                    NESTEdgeObject edge = (NESTEdgeObject)graphItem;
                    if (Utils.isEdgeLoopReturnEdge(edge) && !removedCells.contains(removedCell.getTerminal(true)) && !removedCells.contains(removedCell.getTerminal(false))) {
                        this.reAddDeletedLoopReturnEdgeCell(mxGraph2, edge);
                    } else {
                        modifier.removeEdge(edge);
                    }
                } else if (graphItem.isNESTNode()) {
                    NESTControlflowNodeObject matchingNode;
                    if (graphItem.isNESTControlflowNode() && (matchingNode = ((NESTControlflowNodeObject)graphItem).getMatchingBlockControlflowNode()) != null) {
                        mxGraph2.removeCells(new Object[]{mxGraph2.getCellById(matchingNode.getId())}, true);
                    }
                    graphItem.getGraph().removeGraphNode(graphItem.getId());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reAddDeletedLoopReturnEdgeCell(NESTWorkflowEditor.CustomGraph mxGraph2, NESTEdgeObject edge) {
        mxGraph2.setEventsEnabled(false);
        try {
            mxICell edgeCell = mxGraph2.syncEdge(edge);
            List<mxPoint> mxPointPath = Collections.singletonList(new mxPoint(edgeCell.getTerminal(true).getGeometry().getCenterX(), edgeCell.getTerminal(true).getGeometry().getY() - (double)mxGraph2.getLayout().getLayoutConfig().getNodeHeight() / 2.0 - (double)mxGraph2.getLayout().getLayoutConfig().getNodeVerticalSpacing()));
            edgeCell.getGeometry().setPoints(mxPointPath);
        }
        finally {
            mxGraph2.setEventsEnabled(true);
        }
    }
}

