/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.NESTAbstractWorkflowModifier;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NodeInsertType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;

public class CellAddListener
implements mxEventSource.mxIEventListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Object sender, mxEventObject mxEventObject2) {
        List<mxICell> newCells = Arrays.stream((Object[])mxEventObject2.getProperty("cells")).filter(Objects::nonNull).map(mxICell.class::cast).filter(cell -> cell.getValue() instanceof NodeInsertType || cell.getValue() instanceof NESTGraphItemObject).collect(Collectors.toList());
        if (newCells.size() <= 0) {
            return;
        }
        NESTWorkflowEditor.CustomGraph customGraph = (NESTWorkflowEditor.CustomGraph)((Object)sender);
        customGraph.setEventsEnabled(false);
        try {
            if (newCells.size() == 1 && ((mxICell)newCells.get(0)).getValue() instanceof NodeInsertType) {
                this.handlePaletteDrop(customGraph, newCells.get(0));
            } else if (newCells.size() == 1 && ((NESTGraphItemObject)((mxICell)newCells.get(0)).getValue()).getId().equals(newCells.get(0).getId())) {
                this.handleEdgeSplitDrop(customGraph, newCells);
            } else {
                this.handleCopying(customGraph, newCells);
            }
        }
        finally {
            customGraph.orderCells(true, customGraph.getNestWorkflow().getGraphEdges().stream().filter(DataObject::isNESTPartOfEdge).map(edge -> customGraph.getCellById(edge.getId())).toArray(mxICell[]::new));
            customGraph.setEventsEnabled(true);
        }
    }

    private void handleCopying(NESTWorkflowEditor.CustomGraph customGraph, List<mxICell> newCells) {
        this.handleCopiedWorkflowNode(customGraph, newCells);
        newCells.stream().filter(mxICell::isEdge).forEach(edge -> customGraph.getModel().remove(edge));
        NESTAbstractWorkflowObject nestWorkflow = customGraph.getNestWorkflow();
        NESTAbstractWorkflowModifier nestWorkflowModifier = nestWorkflow.getModifier();
        Set newNodeCells = newCells.stream().filter(cell -> ((NESTGraphItemObject)cell.getValue()).isNESTNode()).collect(Collectors.toSet());
        Set nestNodesToCopy = newNodeCells.stream().map(mxICell::getValue).map(NESTNodeObject.class::cast).collect(Collectors.toSet());
        NESTWorkflowObject partialGraph = (NESTWorkflowObject)nestWorkflowModifier.extractPartialGraph(nestNodesToCopy);
        Map oldToNewIDMapping = nestWorkflowModifier.insertSubgraph((NESTAbstractWorkflowObject)partialGraph, null, null, null);
        Set<NESTNodeObject> copiedNESTNodes = newNodeCells.stream().map(cell -> {
            NESTNodeObject nestNode = (NESTNodeObject)cell.getValue();
            String copiedNESTGraphItemId = (String)oldToNewIDMapping.get(nestNode.getId());
            NESTNodeObject copiedNESTNode = nestWorkflow.getGraphNode(copiedNESTGraphItemId);
            customGraph.setCellId((mxICell)cell, copiedNESTGraphItemId);
            cell.setValue((Object)copiedNESTNode);
            return copiedNESTNode;
        }).collect(Collectors.toSet());
        copiedNESTNodes.forEach(customGraph::syncOutgoingEdges);
    }

    private void handleCopiedWorkflowNode(NESTWorkflowEditor.CustomGraph customGraph, List<mxICell> newCells) {
        mxICell workflowNodeCell = newCells.stream().filter(cell -> ((NESTGraphItemObject)cell.getValue()).isNESTWorkflowNode()).findAny().orElse(null);
        if (workflowNodeCell != null && customGraph.getNestWorkflow().getWorkflowNode() != null) {
            Set connectedEdges = IntStream.range(0, workflowNodeCell.getEdgeCount()).mapToObj(arg_0 -> ((mxICell)workflowNodeCell).getEdgeAt(arg_0)).collect(Collectors.toSet());
            newCells.removeAll(connectedEdges);
            customGraph.getModel().remove((Object)workflowNodeCell);
            this.showWorkflowNodeAlreadyExistsDialog();
        }
    }

    private void handleEdgeSplitDrop(NESTWorkflowEditor.CustomGraph customGraph, List<mxICell> newCells) {
        NESTNodeObject node = customGraph.getNestWorkflow().getGraphNode(((NESTGraphItemObject)newCells.get(0).getValue()).getId());
        customGraph.setEventsEnabled(true);
        customGraph.removeCells(node.getEdges(DataObject::isNESTControlflowEdge).stream().map(edge -> customGraph.getCellById(edge.getId())).toArray(mxICell[]::new));
    }

    private void handlePaletteDrop(NESTWorkflowEditor.CustomGraph customGraph, mxICell newCell) {
        NodeInsertType insertType = (NodeInsertType)((Object)newCell.getValue());
        if (insertType == NodeInsertType.WORKFLOW && customGraph.getNestWorkflow().getWorkflowNode() != null) {
            customGraph.getModel().remove((Object)newCell);
            this.showWorkflowNodeAlreadyExistsDialog();
        } else {
            newCell.setValue((Object)insertType.doInsertion(customGraph.getNestWorkflow(), customGraph, newCell));
        }
    }

    private void showWorkflowNodeAlreadyExistsDialog() {
        JOptionPane.showMessageDialog(null, "Only one workflow node is allowed.");
    }
}

