/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import com.mxgraph.util.mxResources;
import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.CollectionObject;
import de.uni_trier.wi2.procake.data.object.base.ListObject;
import de.uni_trier.wi2.procake.data.object.base.SetObject;
import de.uni_trier.wi2.procake.data.object.base.StringObject;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.FilterableObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.BasicGraphEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.DefaultFileFilter;
import de.uni_trier.wi2.procake.utils.exception.ProCAKEInvalidTypeException;
import de.uni_trier.wi2.procake.utils.io.IOUtil;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

public class ObjectEditorActions {

    public static class DeleteDataAction
    extends AbstractAction {
        private ObjectEditor editor;

        public DeleteDataAction(ObjectEditor editor) {
            super("Delete");
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = this.editor.getTree().getSelectionPath();
            if (path == null || this.editor == null) {
                JOptionPane.showMessageDialog(this.editor, "No Item selected", "Error", 0);
                return;
            }
            DataObject dataObject = this.editor.getDataObject();
            Object object = path.getLastPathComponent();
            this.editor.setCurrentFile(null);
            if (!this.editor.getTitle().endsWith(" *")) {
                this.editor.setTitle(this.editor.getTitle() + " *");
            }
            if (this.editor.getPool() != null && this.editor.getDataObject() == null) {
                this.editor.getPool().remove((DataObject)object);
                this.editor.updateTreeView();
                return;
            }
            if (!dataObject.isCollection()) {
                return;
            }
            ((CollectionObject)dataObject).removeValue((DataObject)object);
            this.editor.updateTreeView();
        }
    }

    public static class SaveInObjectAction
    extends AbstractAction {
        private ObjectEditor editor;

        public SaveInObjectAction(ObjectEditor editor) {
            super("Save to Object", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/save.gif")));
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.editor.writeChangesToOriginalObject();
        }
    }

    public static class AddNewDataAction
    extends AbstractAction {
        private final ObjectEditor editor;
        private final JComboBox<DataClass> newDataObjectClassSelector;

        public AddNewDataAction(ObjectEditor editor, JComboBox<DataClass> newDataObjectClassSelector) {
            super("Add");
            this.editor = editor;
            this.newDataObjectClassSelector = newDataObjectClassSelector;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath pathToNewObject;
            DataClass selectedDataClass = (DataClass)this.newDataObjectClassSelector.getSelectedItem();
            assert (selectedDataClass != null);
            DataObject newDataObject = selectedDataClass.newObject();
            if (this.editor.getDataObject() != null) {
                DataObject obj = this.editor.getDataObject();
                if (obj instanceof SetObject) {
                    ((SetObject)obj).addValue(newDataObject);
                }
                if (obj instanceof ListObject) {
                    if (this.editor.getTree().getSelectionModel().isSelectionEmpty()) {
                        ((ListObject)obj).addValue(newDataObject);
                    } else {
                        ((ListObject)obj).insertAt(newDataObject, this.editor.getTree().getSelectionModel().getLeadSelectionRow());
                    }
                }
                pathToNewObject = new TreePath(new Object[]{this.editor.getDataObject(), newDataObject});
            } else {
                this.editor.getPool().store(newDataObject);
                pathToNewObject = new TreePath(new Object[]{this.editor.getPool(), newDataObject});
            }
            this.editor.updateTreeView();
            this.editor.updateTreeView(pathToNewObject.getPath());
            this.editor.getTree().scrollPathToVisible(pathToNewObject);
            this.editor.getTree().setSelectionPath(pathToNewObject);
            this.editor.setCurrentFile(null);
            if (!this.editor.getTitle().endsWith(" *")) {
                this.editor.setTitle(this.editor.getTitle() + " *");
            }
        }
    }

    public static class OpenNewEditorWindowAction
    extends AbstractAction {
        private ObjectEditor editor;

        public OpenNewEditorWindowAction(ObjectEditor editor) {
            super("Open new editor window");
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.editor.getDataObject() != null && this.editor.getPool() == null) {
                try {
                    Constructor<?> constructor = this.editor.getClass().getDeclaredConstructor(DataObject.class);
                    constructor.setAccessible(true);
                    ObjectEditor newInstance = (ObjectEditor)constructor.newInstance(this.editor.getDataObject());
                    ObjectEditorTreeModel model = (ObjectEditorTreeModel)this.editor.getTree().getModel();
                    newInstance.loadObject(this.editor.getDataObject());
                    newInstance.setTreeModel(model);
                    model.addTreeModelListener(newInstance);
                    newInstance.setDataObject(this.editor.getDataObject());
                    newInstance.setOriginalDataObject(this.editor.getOriginalDataObject());
                    TreePath selectionPath = this.editor.getTree().getSelectionPath();
                    newInstance.getTree().scrollPathToVisible(selectionPath);
                    newInstance.getTree().setSelectionPath(selectionPath);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                    JOptionPane.showMessageDialog(this.editor, exception.toString(), mxResources.get((String)"error"), 0);
                }
            } else if (this.editor.getDataObject() == null && this.editor.getPool() != null) {
                try {
                    Constructor<?> constructor = this.editor.getClass().getDeclaredConstructor(WriteableObjectPool.class);
                    constructor.setAccessible(true);
                    ObjectEditor newInstance = (ObjectEditor)constructor.newInstance(this.editor.getPool());
                    FilterableObjectPoolTreeModel model = (FilterableObjectPoolTreeModel)this.editor.getTree().getModel();
                    newInstance.setTreeModel(model);
                    model.addTreeModelListener(newInstance);
                    newInstance.setPool(this.editor.getPool());
                    newInstance.setOriginalPool(this.editor.getOriginalPool());
                    TreePath selectionPath = this.editor.getTree().getSelectionPath();
                    newInstance.getTree().scrollPathToVisible(selectionPath);
                    newInstance.getTree().setSelectionPath(selectionPath);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                    JOptionPane.showMessageDialog(this.editor, exception.toString(), mxResources.get((String)"error"), 0);
                }
            }
        }
    }

    public static class ExportAsAction
    extends AbstractAction {
        protected String lastDir = null;
        private ObjectEditor editor;
        private Supplier<Object> dataObjectToSaveSupplier;
        private Supplier<Object> poolToSaveSupplier;

        public ExportAsAction(ObjectEditor editor, Supplier<Object> dataObjectToSaveSupplier, Supplier<Object> poolToSaveSupplier) {
            super("Save to File", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/saveas.gif")));
            this.editor = editor;
            this.dataObjectToSaveSupplier = dataObjectToSaveSupplier;
            this.poolToSaveSupplier = poolToSaveSupplier;
        }

        public ExportAsAction(ObjectEditor editor) {
            this(editor, editor::getDataObject, editor::getPool);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String workingDir = this.lastDir != null ? this.lastDir : (this.editor.getCurrentFile() != null ? this.editor.getCurrentFile().getParent() : System.getProperty("user.dir"));
            JFileChooser fileChooser = new JFileChooser(workingDir);
            DefaultFileFilter defaultFileFilter = new DefaultFileFilter(".xml", "XML File (.xml)");
            fileChooser.addChoosableFileFilter(defaultFileFilter);
            fileChooser.setFileFilter(defaultFileFilter);
            int rc = fileChooser.showDialog(this.editor, "Save");
            if (rc != 0) {
                return;
            }
            this.lastDir = fileChooser.getSelectedFile().getParent();
            Object filename = fileChooser.getSelectedFile().getAbsolutePath();
            FileFilter selectedFilter = fileChooser.getFileFilter();
            if (selectedFilter instanceof DefaultFileFilter) {
                String ext = ((DefaultFileFilter)selectedFilter).getExtension();
                if (!((String)filename).toLowerCase().endsWith(ext)) {
                    filename = (String)filename + ext;
                }
            }
            if (new File((String)filename).exists() && JOptionPane.showConfirmDialog(this.editor, "Overwrite existing file?") != 0) {
                return;
            }
            this.editor.updateTreeView();
            try {
                boolean writeSuccess = false;
                if (this.dataObjectToSaveSupplier.get() == null) {
                    writeSuccess = IOUtil.writeFile((Object)this.poolToSaveSupplier.get(), (String)filename) != null;
                } else if (this.poolToSaveSupplier.get() == null) {
                    boolean bl = writeSuccess = IOUtil.writeFile((Object)this.dataObjectToSaveSupplier.get(), (String)filename) != null;
                }
                if (!writeSuccess) {
                    throw new IOException("XML serialization failed. Check stacktrace for details.");
                }
                this.editor.setCurrentFile(new File((String)filename));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.editor, ex.toString(), "Error", 0);
            }
        }
    }

    public static class StoreDataObjectInClipboardAction
    extends AbstractAction {
        public static DataObject clipboardObject;
        private DataObject objectToStore;

        public StoreDataObjectInClipboardAction(DataObject dataObject) {
            super("Copy", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/copy.gif")));
            this.objectToStore = dataObject;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            clipboardObject = this.objectToStore.copy();
        }
    }

    public static class AddDataObjectFromClipboardAction
    extends AddDataObjectFromXMLFileAction {
        public AddDataObjectFromClipboardAction(ObjectEditor editor, Object target) {
            super(editor, target);
            this.putValue("Name", "Add clipboard object");
            this.putValue("SmallIcon", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/paste.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StoreDataObjectInClipboardAction.clipboardObject == null) {
                JOptionPane.showMessageDialog(this.editor, "Clipboard is empty.", "Error", 0);
            } else {
                this.consumeLoadedDataObject(StoreDataObjectInClipboardAction.clipboardObject.copy());
            }
        }
    }

    public static class AddDataObjectFromXMLFileAction
    extends OpenDataObjectFromXMLFileAction {
        public AddDataObjectFromXMLFileAction(ObjectEditor editor, Object target) {
            super(editor, "Add from XML import", target, null);
        }

        @Override
        void consumeLoadedDataObject(DataObject dataObject) {
            if (this.target instanceof Map.Entry) {
                this.target = ((Map.Entry)this.target).getValue();
            }
            try {
                if (this.target instanceof WriteableObjectPool) {
                    WriteableObjectPool targetPool = (WriteableObjectPool)this.target;
                    try {
                        targetPool.store(dataObject);
                    }
                    catch (RuntimeException e) {
                        dataObject.setId(null);
                        targetPool.store(dataObject);
                    }
                } else if (this.target instanceof CollectionObject) {
                    CollectionObject targetCollection = (CollectionObject)this.target;
                    targetCollection.addValue(dataObject);
                } else {
                    throw new ProCAKEInvalidTypeException("Invalid target object. Only collections and pools are supported.", new String[]{this.target.toString(), dataObject.getId()});
                }
                this.editor.updateTreeView();
            }
            catch (ProCAKEInvalidTypeException e) {
                JOptionPane.showMessageDialog(this.editor, "Import failed due to invalid type of data object.", "Error", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.editor, "Import failed: " + e.getMessage(), "Error", 0);
            }
        }
    }

    public static class ReplaceWithDataObjectFromClipboardAction
    extends ReplaceWithDataObjectFromXMLFileAction {
        public ReplaceWithDataObjectFromClipboardAction(ObjectEditor editor, Object target, Object parent) {
            super(editor, target, parent);
            this.putValue("Name", "Replace by clipboard object");
            this.putValue("SmallIcon", new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/paste.gif")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StoreDataObjectInClipboardAction.clipboardObject == null) {
                JOptionPane.showMessageDialog(this.editor, "Clipboard is empty.", "Error", 0);
            } else {
                this.consumeLoadedDataObject(StoreDataObjectInClipboardAction.clipboardObject.copy());
            }
        }
    }

    public static class ReplaceWithDataObjectFromXMLFileAction
    extends OpenDataObjectFromXMLFileAction {
        public ReplaceWithDataObjectFromXMLFileAction(ObjectEditor editor, Object target, Object parent) {
            super(editor, "Replace by XML import", target, parent);
        }

        @Override
        void consumeLoadedDataObject(DataObject dataObject) {
            try {
                if (this.parent instanceof WriteableObjectPool) {
                    WriteableObjectPool parentPool = (WriteableObjectPool)this.parent;
                    parentPool.remove((DataObject)this.target);
                    try {
                        parentPool.store(dataObject);
                    }
                    catch (RuntimeException e) {
                        dataObject.setId(null);
                        parentPool.store(dataObject);
                    }
                } else if (this.parent instanceof SetObject) {
                    SetObject parentSet = (SetObject)this.parent;
                    parentSet.removeValue((DataObject)this.target);
                    parentSet.addValue(dataObject);
                } else if (this.parent instanceof ListObject) {
                    ListObject parentList = (ListObject)this.parent;
                    parentList.insertAt(dataObject, parentList.indexOf((DataObject)this.target));
                    parentList.removeValue((DataObject)this.target);
                } else if (this.parent instanceof AggregateObject) {
                    AggregateObject parentAggregate = (AggregateObject)this.parent;
                    Map.Entry target = (Map.Entry)this.target;
                    if (parentAggregate.getAggregateClass().getAttributeType((String)target.getKey()) == ModelFactory.getDefaultModel().getStringSystemClass()) {
                        StringObject stringObject = (StringObject)ModelFactory.getDefaultModel().getStringSystemClass().newObject();
                        stringObject.setNativeString(((StringObject)dataObject).getNativeString());
                        parentAggregate.setAttributeValue((String)target.getKey(), (DataObject)stringObject);
                    } else {
                        parentAggregate.setAttributeValue((String)target.getKey(), dataObject);
                    }
                } else {
                    throw new ProCAKEInvalidTypeException("Invalid parent type. Only collections, pools and aggregates are supported.", new String[]{this.target.toString(), dataObject.getId()});
                }
                this.editor.updateTreeView();
            }
            catch (ProCAKEInvalidTypeException e) {
                JOptionPane.showMessageDialog(this.editor, "Import failed due to invalid type of data object.", "Error", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.editor, "Import failed: " + e.getMessage(), "Error", 0);
            }
        }
    }

    public static abstract class OpenDataObjectFromXMLFileAction
    extends OpenXMLFileAction {
        static String lastDir;
        Object target;
        Object parent;

        public OpenDataObjectFromXMLFileAction(ObjectEditor editor, String actionTitle, Object target, Object parent) {
            super(lastDir, actionTitle);
            this.target = target;
            this.parent = parent;
            this.editor = editor;
        }

        @Override
        void consumeSelectedFile(File selectedFile) {
            Object parsedObject = IOUtil.readFile((String)selectedFile.getAbsolutePath(), (String)"ObjectSaxParser");
            if (!(parsedObject instanceof DataObject)) {
                JOptionPane.showMessageDialog(this.editor, "Chosen file does not contain a data object definition or the definition is invalid for the current CakeInstance.", "Error", 0);
            } else {
                lastDir = selectedFile.getAbsolutePath();
                this.consumeLoadedDataObject((DataObject)parsedObject);
                this.editor.updateTreeView();
            }
        }

        abstract void consumeLoadedDataObject(DataObject var1);
    }

    public static class OpenPoolXMLFileAction
    extends OpenXMLFileAction {
        public OpenPoolXMLFileAction(ObjectEditor editor) {
            super(editor);
        }

        @Override
        void consumeSelectedFile(File selectedFile) {
            boolean useDataObjectMode = true;
            Object parsedObject = IOUtil.readFile((String)selectedFile.getAbsolutePath(), DataObject.class);
            if (parsedObject == null) {
                useDataObjectMode = false;
                parsedObject = IOUtil.readFile((String)selectedFile.getAbsolutePath(), (String)"ObjectPoolParser");
                if (!(parsedObject instanceof WriteableObjectPool)) {
                    JOptionPane.showMessageDialog(this.editor, "Chosen file does not contain a pool definition or the definition is invalid for the current CakeInstance.", "Error", 0);
                    return;
                }
            }
            this.editor.setCurrentFile(selectedFile);
            if (useDataObjectMode) {
                this.editor.loadObject((DataObject)parsedObject);
            } else {
                this.editor.loadObject((WriteableObjectPool)parsedObject);
            }
            this.editor.setTree(this.editor.setUpTree());
            JPanel newLeftPane = this.editor.setUpLeftPane();
            JPanel newRightPane = this.editor.setUpRightPane();
            this.editor.setNewMainSplitPane(newLeftPane, newRightPane);
        }
    }

    public static abstract class OpenXMLFileAction
    extends AbstractAction {
        protected String lastDir;
        protected ObjectEditor editor;

        public OpenXMLFileAction(String lastDir, String actionTitle) {
            super(actionTitle, new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/open.gif")));
            this.lastDir = lastDir;
        }

        public OpenXMLFileAction(String lastDir) {
            this(lastDir, "Open File");
        }

        public OpenXMLFileAction(ObjectEditor editor) {
            this(editor.getCurrentFile() != null ? editor.getCurrentFile().getAbsolutePath() : null);
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
            JFileChooser fc = new JFileChooser(wd);
            DefaultFileFilter defaultFilter = new DefaultFileFilter(".xml", "XML File (.xml)");
            fc.addChoosableFileFilter(defaultFilter);
            fc.setFileFilter(defaultFilter);
            int rc = fc.showDialog(null, "Open File");
            if (rc == 0) {
                this.lastDir = fc.getSelectedFile().getParent();
                this.consumeSelectedFile(fc.getSelectedFile());
            }
        }

        abstract void consumeSelectedFile(File var1);
    }

    public static class RefreshObjectPoolAction
    extends AbstractAction {
        private ObjectEditor editor;

        public RefreshObjectPoolAction(ObjectEditor editor) {
            super("Load from Object");
            this.putValue("ShortDescription", "<html><p width='300'>Copies the Object from the reference given on instantiation of the editor and loads this copy into the editor. Be aware that any unsaved changes made to the pool will be lost.</p></html>");
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JPanel barPanel = new JPanel();
            barPanel.setLayout(new GridBagLayout());
            JLabel text = new JLabel("Loading... ");
            JProgressBar bar = new JProgressBar();
            bar.setVisible(true);
            bar.setIndeterminate(true);
            barPanel.add(text);
            barPanel.add(bar);
            this.editor.setNewMainSplitPane(new JPanel(), barPanel);
            SwingUtilities.invokeLater(() -> {
                boolean useDataObjectMode = false;
                if (this.editor.getDataObject() != null && this.editor.getPool() == null) {
                    useDataObjectMode = true;
                    this.editor.loadObject(this.editor.getOriginalDataObject());
                } else if (this.editor.getDataObject() == null && this.editor.getPool() != null) {
                    this.editor.loadObject(this.editor.getOriginalPool());
                }
                if (useDataObjectMode) {
                    this.editor.loadObject(this.editor.getOriginalDataObject());
                } else {
                    this.editor.loadObject(this.editor.getOriginalPool());
                }
                this.editor.setTree(this.editor.setUpTree());
                JPanel newLeftPane = this.editor.setUpLeftPane();
                JPanel newRightPane = this.editor.setUpRightPane();
                this.editor.setNewMainSplitPane(newLeftPane, newRightPane);
                this.editor.updateTreeView();
            });
        }
    }
}

