/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.Model;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.data.object.base.CollectionObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.objectpool.ReadableObjectPool;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.FilterableObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorActions;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorMenuBar;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.label.AggregateObjectLabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProviderFactory;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.DataObjectEditorSaveable;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorToolBar;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectEditor<T extends DataObject>
extends JFrame
implements TreeModelListener {
    protected static final Logger logger = LoggerFactory.getLogger(ObjectEditor.class);
    private static final Object windowCloseLock = new Object();
    private T originalDataObject;
    private T dataObject;
    private WriteableObjectPool<T> pool;
    private WriteableObjectPool<T> originalPool;
    private ObjectJTree tree;
    private File currentFile;
    private JSplitPane mainSplitPane;
    JComboBox<DataClass> newDataObjectClassSelector;
    JScrollPane treeScrollPane;
    private JButton saveButton;
    private boolean changesInObject = false;
    private DataObjectEditorSaveable activeDataObjectEditor;
    private NESTWorkflowEditor activeNestGraphEditor;
    private EditorToolBar extraToolBar = null;

    public ObjectEditor(T dataObject, boolean blockThreadUntilEditorWindowClosed) {
        this.loadObject(dataObject);
        this.setUpApp(blockThreadUntilEditorWindowClosed);
    }

    public ObjectEditor(T dataObject) {
        this(dataObject, false);
    }

    public ObjectEditor(WriteableObjectPool<T> pool, boolean blockThreadUntilEditorWindowClosed) {
        this.loadObject(pool);
        this.setUpApp(blockThreadUntilEditorWindowClosed);
    }

    public ObjectEditor(WriteableObjectPool<T> pool) {
        this(pool, false);
    }

    private void setUpApp(boolean blockThreadUntilEditorWindowClosed) {
        this.setUpFrame();
        this.tree = this.setUpTree();
        JPanel leftPanel = this.setUpLeftPane();
        JPanel rightPanel = this.setUpRightPane();
        this.mainSplitPane = this.setUpSplitPane(leftPanel, rightPanel);
        this.add(this.mainSplitPane);
        this.setJMenuBar(new ObjectEditorMenuBar(this));
        this.setMinimumSize(new Dimension(1366, 768));
        this.setVisible(true);
        if (this.pool == null && this.dataObject != null) {
            this.tree.setSelectionRow(0);
        } else if (this.pool != null && this.dataObject == null) {
            this.tree.setSelectionRow(1);
        }
        if (blockThreadUntilEditorWindowClosed) {
            this.waitUntilEditorWindowClosed();
        }
    }

    ObjectJTree setUpTree() {
        final ObjectJTree tree = new ObjectJTree();
        if (this.pool == null) {
            tree.setModel(new ObjectEditorTreeModel((DataObject)this.dataObject));
        } else if (this.dataObject == null) {
            tree.setModel(new FilterableObjectPoolTreeModel<T>(this.pool));
        }
        tree.getModel().addTreeModelListener(this);
        tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int selRow = tree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
                    tree.setSelectionPath(selPath);
                    if (selRow > -1) {
                        tree.setSelectionRow(selRow);
                    }
                    Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), ObjectEditor.this);
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new ObjectEditorActions.AddNewDataAction(ObjectEditor.this, ObjectEditor.this.newDataObjectClassSelector));
                    menu.add(new ObjectEditorActions.DeleteDataAction(ObjectEditor.this));
                    if (tree.getSelectionPath() == null) {
                        for (Component element : menu.getComponents()) {
                            element.setEnabled(false);
                        }
                    }
                    menu.show(ObjectEditor.this, pt.x, pt.y);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(e -> {
            TreePath selectionPath = tree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            Object[] path = selectionPath.getPath();
            Object selectedElement = path[path.length - 1];
            if (this.extraToolBar != null) {
                this.remove(this.extraToolBar);
                this.extraToolBar = new EditorToolBar(0);
                this.add((Component)this.extraToolBar, "North");
            }
            DataObject dataObject = null;
            if (selectedElement instanceof DataObject) {
                dataObject = (DataObject)selectedElement;
            } else if (selectedElement instanceof Map.Entry && (dataObject = (DataObject)((Map.Entry)selectedElement).getValue()) == null) {
                this.mainSplitPane.setRightComponent(new JLabel("Creation and deletion of aggregate attributes have to be done in the editor of the corresponding aggregate object."));
                return;
            }
            if (dataObject != null) {
                if (dataObject.isNESTWorkflow() || dataObject.isNESTSequentialWorkflow()) {
                    this.activeNestGraphEditor = new NESTWorkflowEditor((NESTAbstractWorkflowObject)dataObject, true, true, true, false);
                    this.activeNestGraphEditor.addGraphSaveListener(this::updateForNESTGraphEditorSave);
                    this.mainSplitPane.setRightComponent(this.activeNestGraphEditor);
                    this.extraToolBar = new EditorToolBar(this.activeNestGraphEditor, 0);
                    this.add((Component)this.extraToolBar, "North");
                } else if (dataObject.isNESTEdge() || dataObject.isNESTNode()) {
                    NESTGraphItemObject graphItemObject = (NESTGraphItemObject)dataObject;
                    if (graphItemObject.getSemanticDescriptor() != null) {
                        this.mainSplitPane.setRightComponent(new JScrollPane(this.createSaveableDataObjectEditorPanel(graphItemObject.getSemanticDescriptor())));
                    }
                } else {
                    this.mainSplitPane.setRightComponent(new JScrollPane(this.createSaveableDataObjectEditorPanel(dataObject)));
                }
            } else {
                this.mainSplitPane.setRightComponent(new JLabel(""));
            }
            Object[] oldPath = e.getOldLeadSelectionPath() != null ? e.getOldLeadSelectionPath().getPath() : null;
            SwingUtilities.invokeLater(() -> SwingUtilities.updateComponentTreeUI(this));
            if (oldPath == null) {
                return;
            }
            this.updateTreeView(oldPath);
        });
        return tree;
    }

    private JPanel createSaveableDataObjectEditorPanel(DataObject dataObject) {
        JPanel panel = new JPanel(new BorderLayout());
        this.activeDataObjectEditor = new DataObjectEditorSaveable(dataObject, true);
        panel.add((Component)this.activeDataObjectEditor, "Center");
        if (!dataObject.isCollection() && this.dataObject != null && !this.dataObject.isCollection() && this.pool == null) {
            this.saveButton = new JButton("Save changes");
            this.saveButton.addActionListener(e -> {
                this.setCurrentFile(null);
                if (!this.getTitle().endsWith(" *")) {
                    this.setTitle(this.getTitle() + " *");
                    this.activeDataObjectEditor.saveChanges();
                    this.updateTreeView(Objects.requireNonNull(this.tree.getSelectionPath()).getPath());
                }
            });
            JPanel buttonPanel = new JPanel(new FlowLayout(0));
            buttonPanel.add(this.saveButton);
            panel.add((Component)buttonPanel, "First");
        }
        return panel;
    }

    void updateTreeView(Object[] path) {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (this.pool == null) {
            ((ObjectEditorTreeModel)this.tree.getModel()).fireTreeStructureChanged(path);
        } else if (this.dataObject == null) {
            ((FilterableObjectPoolTreeModel)this.tree.getModel()).fireTreeStructureChanged(path);
        }
        this.tree.scrollPathToVisible(selectionPath);
        this.tree.setSelectionPath(selectionPath);
    }

    void updateTreeView() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (this.pool == null) {
            ((ObjectEditorTreeModel)this.tree.getModel()).fireTreeStructureChanged(new Object[]{this.dataObject});
        } else if (this.dataObject == null) {
            ((ObjectPoolTreeModel)this.tree.getModel()).fireTreeStructureChanged(new Object[]{this.getPool()});
            this.tree.scrollPathToVisible(selectionPath);
            this.tree.setSelectionPath(selectionPath);
        }
        this.tree.scrollPathToVisible(selectionPath);
        this.tree.setSelectionPath(selectionPath);
    }

    JPanel setUpRightPane() {
        return new JPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilEditorWindowClosed() {
        try {
            while (!this.isVisible()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object object = windowCloseLock;
        synchronized (object) {
            while (this.isVisible()) {
                try {
                    windowCloseLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    JPanel setUpLeftPane() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.treeScrollPane = new JScrollPane();
        leftPanel.add((Component)this.treeScrollPane, "Center");
        leftPanel.setMinimumSize(new Dimension(250, 250));
        this.treeScrollPane.setViewportView(this.tree);
        leftPanel.add((Component)new AddDataPanel(), "Last");
        return leftPanel;
    }

    private void setUpFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Utils.setDefaultFontSize(11.5f);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/objecteditor/nestworkfloweditor/images/ProCAKE_Icon.png")));
        super.setDefaultCloseOperation(2);
        super.setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                Object object = windowCloseLock;
                synchronized (object) {
                    JFrame frame = (JFrame)e.getComponent();
                    if (ObjectEditor.this.changesInObject) {
                        frame.setDefaultCloseOperation(0);
                        int n = JOptionPane.showConfirmDialog(ObjectEditor.this, "You may have unsaved changes. Do you want to continue closing the window?", "Unsaved Changes", 0, 2);
                        if (n == 1 || n == -1) {
                            frame.setVisible(true);
                            return;
                        }
                    }
                    frame.setDefaultCloseOperation(2);
                    ObjectEditor.this.setVisible(false);
                    ObjectEditor.this.dispose();
                    windowCloseLock.notify();
                }
            }
        });
        this.pack();
    }

    void loadObject(T dataObject) {
        this.pool = null;
        this.originalPool = null;
        this.originalDataObject = dataObject;
        this.dataObject = this.originalDataObject.copy();
        super.setTitle(dataObject.getId());
    }

    void loadObject(WriteableObjectPool<T> pool) {
        this.dataObject = null;
        this.originalDataObject = null;
        this.originalPool = pool;
        this.pool = pool.copy();
        this.setTitle(pool.getId());
    }

    private JSplitPane setUpSplitPane(JPanel leftPanel, JPanel rightPanel) {
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setOneTouchExpandable(true);
        splitPane.setLeftComponent(leftPanel);
        splitPane.setRightComponent(rightPanel);
        splitPane.setDividerSize(12);
        this.add((Component)splitPane, "Center");
        return splitPane;
    }

    public DataObject getOriginalDataObject() {
        return this.originalDataObject;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File file) {
        this.currentFile = file;
        this.updateTitle();
    }

    private void updateTitle() {
        String ID = this.dataObject == null ? this.pool.getId() : this.dataObject.getId();
        this.setTitle(ID + (String)(this.currentFile != null ? " - file: " + this.currentFile.getAbsolutePath() : ""));
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public void writeChangesToOriginalObject() {
        if (this.saveButton != null) {
            this.saveButton.doClick();
        }
        try {
            if (this.dataObject != null && this.pool == null) {
                this.originalDataObject = this.dataObject.copy();
            } else if (this.pool != null && this.dataObject == null) {
                this.originalPool = this.pool.copy();
            }
            this.setTitle(this.getTitle().replace("*", " ").trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error in saving, please refer to the stack trace", "Error", 0);
            throw new RuntimeException(e);
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public WriteableObjectPool<T> getPool() {
        return this.pool;
    }

    public WriteableObjectPool<T> getOriginalPool() {
        return this.originalPool;
    }

    public void setTree(ObjectJTree setUpTree) {
        this.tree = setUpTree;
    }

    protected String getTreeNodeLabel(Object object) {
        try {
            if (object == null) {
                return "null";
            }
            if (object instanceof AtomicObject) {
                return this.getTreeNodeLabel((AtomicObject)object);
            }
            if (object instanceof AggregateObject) {
                return this.getTreeNodeLabel((AggregateObject)object);
            }
            if (object instanceof NESTWorkflowObject) {
                return this.getTreeNodeLabel((NESTWorkflowObject)object);
            }
            if (object instanceof Map.Entry) {
                return this.getTreeNodeLabel((Map.Entry)object);
            }
            if (object instanceof CollectionObject) {
                return this.getTreeNodeLabel((CollectionObject)object);
            }
            if (object instanceof NESTEdgeObject) {
                return this.getTreeNodeLabel((NESTEdgeObject)object);
            }
            if (object instanceof NESTNodeObject) {
                return this.getTreeNodeLabel((NESTNodeObject)object);
            }
            if (object instanceof ReadableObjectPool) {
                return this.getTreeNodeLabel((ReadableObjectPool<DataObject>)((ReadableObjectPool)object));
            }
            if (object instanceof DataObject) {
                return this.getTreeNodeLabel((DataObject)object);
            }
        }
        catch (RuntimeException e) {
            logger.error("Could not get label for object: {}", object);
            logger.error("Exception: ", (Throwable)e);
        }
        return Objects.toString(object);
    }

    protected String getTreeNodeLabel(DataObject dataObject) {
        return dataObject.getId();
    }

    protected String getTreeNodeLabel(ReadableObjectPool<DataObject> pool) {
        return pool.getId();
    }

    protected String getTreeNodeLabel(Map.Entry<String, Object> attribute) {
        return attribute.getKey() + " = " + this.getTreeNodeLabel(attribute.getValue());
    }

    protected String getTreeNodeLabel(AtomicObject atomicObject) {
        return atomicObject.getNativeObject().toString();
    }

    protected String getTreeNodeLabel(AggregateObject aggregateObject) {
        AggregateObjectLabelProvider labelProvider = (AggregateObjectLabelProvider)((Object)LabelProviderFactory.getProvider(aggregateObject.getDataClass()));
        return labelProvider == null ? aggregateObject.getId() : labelProvider.getLabel((DataObject)aggregateObject);
    }

    protected String getTreeNodeLabel(CollectionObject collectionObject) {
        return collectionObject.getDataClass() + " of " + collectionObject.size() + " " + collectionObject.getCollectionClass().getElementClass().getName();
    }

    protected String getTreeNodeLabel(NESTEdgeObject nestEdgeObject) {
        return nestEdgeObject.getDataClass().getName() + ": " + nestEdgeObject;
    }

    protected String getTreeNodeLabel(NESTNodeObject nestNodeObject) {
        return nestNodeObject.getDataClass().getName() + ": " + nestNodeObject.getId();
    }

    protected String getTreeNodeLabel(NESTWorkflowObject nestGraphObject) {
        return nestGraphObject.getId();
    }

    public void setTreeModel(ObjectEditorTreeModel model) {
        this.tree.setModel(model);
    }

    public void setTreeModel(FilterableObjectPoolTreeModel<?> model) {
        this.tree.setModel(model);
    }

    void setNewMainSplitPane(Component l, Component r) {
        this.mainSplitPane.setLeftComponent(l);
        this.mainSplitPane.setRightComponent(r);
    }

    public void setPool(WriteableObjectPool<T> pool) {
        this.pool = pool;
    }

    public void setOriginalPool(WriteableObjectPool<T> pool) {
        this.originalPool = pool;
    }

    public void setDataObject(T dataObject) {
        this.dataObject = dataObject;
    }

    public void setOriginalDataObject(T dataObject) {
        this.originalDataObject = dataObject;
    }

    private void updateForNESTGraphEditorSave(NESTAbstractWorkflowObject nestWorkflowObject) {
        Object[] path = this.tree.getSelectionPath().getPath();
        this.writeChangesToOriginalObject();
        SwingUtilities.invokeLater(() -> this.updateTreeView(path));
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.tree.scrollPathToVisible(e.getTreePath());
    }

    class ObjectJTree
    extends JTree {
        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return ObjectEditor.this.getTreeNodeLabel(value);
        }
    }

    class AddDataPanel
    extends JPanel {
        public AddDataPanel() {
            List mostTypeObjects;
            super(new BorderLayout());
            if (ObjectEditor.this.dataObject != null && !ObjectEditor.this.dataObject.isCollection()) {
                return;
            }
            Model model = ModelFactory.getDefaultModel();
            List possibleClasses = model.getClasses().stream().filter(DataClass::isInstantiable).collect(Collectors.toList());
            ObjectEditor.this.newDataObjectClassSelector = new JComboBox<DataClass>((DataClass[])possibleClasses.toArray(DataClass[]::new));
            if (ObjectEditor.this.pool != null && (mostTypeObjects = (List)ObjectEditor.this.pool.getCollection().stream().collect(Collectors.groupingBy(DataObject::getDataClass)).values().stream().max(Comparator.comparing(List::size)).orElse(new ArrayList())).size() > 0) {
                ObjectEditor.this.newDataObjectClassSelector.setSelectedItem(((DataObject)mostTypeObjects.iterator().next()).getDataClass());
            }
            ObjectEditor.this.newDataObjectClassSelector.setMinimumSize(new Dimension(0, ObjectEditor.this.newDataObjectClassSelector.getHeight()));
            this.add(ObjectEditor.this.newDataObjectClassSelector, "Center");
            JButton addButton = new JButton(new ObjectEditorActions.AddNewDataAction(ObjectEditor.this, ObjectEditor.this.newDataObjectClassSelector));
            JButton deleteButton = new JButton(new ObjectEditorActions.DeleteDataAction(ObjectEditor.this));
            deleteButton.setMnemonic(127);
            this.add((Component)addButton, "After");
            this.add((Component)deleteButton, "Last");
        }
    }
}

