/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.objectpool.ReadableObjectPool;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectPoolTreeModel;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class FilterableObjectPoolTreeModel<T extends DataObject>
extends ObjectPoolTreeModel<T> {
    Class filterClass;

    public FilterableObjectPoolTreeModel(WriteableObjectPool<T> pool) {
        super(pool);
    }

    @Override
    public Object getChild(Object o, int i) {
        if (o instanceof ReadableObjectPool) {
            return new ArrayList(((ReadableObjectPool)o).getCollection()).stream().filter(this::matchesFilter).collect(Collectors.toList()).get(i);
        }
        return super.getChild(o, i);
    }

    @Override
    public int getChildCount(Object o) {
        if (o instanceof ReadableObjectPool) {
            return (int)new ArrayList(((ReadableObjectPool)o).getCollection()).stream().filter(this::matchesFilter).count();
        }
        return super.getChildCount(o);
    }

    @Override
    public boolean isLeaf(Object o) {
        if (o instanceof ReadableObjectPool) {
            return this.getChildCount(o) <= 0;
        }
        return super.isLeaf(o);
    }

    public void setFilter(Class filterClass) {
        this.filterClass = filterClass;
    }

    private boolean matchesFilter(DataObject dataObject) {
        if (this.filterClass == null) {
            return true;
        }
        try {
            return (Boolean)this.filterClass.getDeclaredMethod("filter" + dataObject.getDataClass().getName(), AggregateObject.class).invoke(null, dataObject);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }
}

