/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.xmlutils.run.modules;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import de.unirostock.sems.xmlutils.run.XMLTool;
import java.util.HashMap;
import java.util.Set;

public class XMLStats
extends XMLTool {
    public XMLStats(String[] args) {
        super(args);
    }

    public void doIt(TreeDocument doc) throws Exception {
        System.out.println("===================");
        System.out.println("document contains " + doc.getNumNodes() + " nodes:");
        System.out.println("===================");
        HashMap<String, Integer> map = doc.getNodeStats();
        for (String tag : map.keySet()) {
            System.out.println(tag + " => " + map.get(tag));
        }
        System.out.println("===================");
        System.out.println("those are the actual nodes, format:");
        System.out.println("xpath - num args - num children - size subtree");
        System.out.println("with size subtree being the number of nodes in the subtree or the length of the text in text nodes");
        System.out.println("===================");
        Set<String> xpaths = doc.getOccurringXPaths();
        block5: for (String xpath : xpaths) {
            TreeNode tn = doc.getNodeByPath(xpath);
            switch (tn.getType()) {
                case 1: {
                    DocumentNode dn = (DocumentNode)tn;
                    System.out.println(xpath + " - " + dn.getAttributes().size() + " - " + dn.getChildren().size() + " - " + dn.getSizeSubtree());
                    continue block5;
                }
                case 2: {
                    TextNode txtn = (TextNode)tn;
                    System.out.println(xpath + " - " + 0 + " - " + 0 + " - " + txtn.getText().length());
                    continue block5;
                }
            }
            LOGGER.error((Object[])new Object[]{"unexpected node type ", tn.getType(), " in ", xpath});
        }
    }

    public String usage() {
        return "no arguments required";
    }
}

