/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.xmlutils.ds;

import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeComparatorBySubtreeSize
implements Comparator<TreeNode> {
    private int reverse;

    public TreeNodeComparatorBySubtreeSize() {
        this.reverse = 1;
    }

    public TreeNodeComparatorBySubtreeSize(boolean reverse) {
        this.reverse = reverse ? -1 : 1;
    }

    @Override
    public int compare(TreeNode o1, TreeNode o2) {
        return this.reverse * this.privateCompare(o1, o2);
    }

    private int privateCompare(TreeNode o1, TreeNode o2) {
        if (o1 == o2) {
            return 0;
        }
        int t = o2.getType();
        if (t != o1.getType()) {
            return t == 2 ? 1 : -1;
        }
        if (t == 1) {
            int a2;
            double w2;
            int sub2;
            int sub1 = ((DocumentNode)o1).getSizeSubtree();
            if (sub1 < (sub2 = ((DocumentNode)o2).getSizeSubtree())) {
                return -1;
            }
            if (sub1 > sub2) {
                return 1;
            }
            double w1 = o1.getWeight();
            if (w1 < (w2 = o2.getWeight())) {
                return -1;
            }
            if (w1 > w2) {
                return 1;
            }
            int a1 = ((DocumentNode)o1).getAttributes().size();
            if (a1 < (a2 = ((DocumentNode)o2).getAttributes().size())) {
                return -1;
            }
            if (a1 > a2) {
                return 1;
            }
        } else {
            double w2;
            double w1 = o1.getWeight();
            if (w1 < (w2 = o2.getWeight())) {
                return -1;
            }
            if (w1 > w2) {
                return 1;
            }
        }
        return o1.getXPath().compareTo(o2.getXPath());
    }
}

