/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.xmlutils.ds;

import de.unirostock.sems.xmlutils.alg.SemsWeighter;
import de.unirostock.sems.xmlutils.alg.Weighter;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import de.unirostock.sems.xmlutils.ds.TreeNodeComparatorBySubtreeSize;
import de.unirostock.sems.xmlutils.ds.mappers.MultiNodeMapper;
import de.unirostock.sems.xmlutils.ds.mappers.NodeMapper;
import de.unirostock.sems.xmlutils.exception.XmlDocumentParseException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdom2.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeDocument {
    private DocumentNode root;
    private NodeMapper<DocumentNode> idMapper;
    private NodeMapper<TreeNode> pathMapper;
    private MultiNodeMapper<TreeNode> hashMapper;
    private MultiNodeMapper<DocumentNode> tagMapper;
    private List<TextNode> textNodes;
    private boolean ordered;
    private SortedSet<TreeNode> subtreesBySize;
    private boolean uniqueIds;
    private URI baseUri;

    private void init() {
        this.pathMapper = new NodeMapper();
        this.idMapper = new NodeMapper();
        this.hashMapper = new MultiNodeMapper();
        this.tagMapper = new MultiNodeMapper();
        this.subtreesBySize = new TreeSet<TreeNode>(new TreeNodeComparatorBySubtreeSize(true));
        this.textNodes = new ArrayList<TextNode>();
    }

    public TreeDocument(Document d, URI baseUri) throws XmlDocumentParseException {
        this.init();
        SemsWeighter w = new SemsWeighter();
        this.root = new DocumentNode(d.getRootElement(), null, this, w, 1, 0);
        this.ordered = true;
        this.uniqueIds = true;
        this.baseUri = baseUri;
    }

    public TreeDocument(Document d, Weighter w, URI baseUri) throws XmlDocumentParseException {
        this.init();
        if (w == null) {
            w = new SemsWeighter();
        }
        this.root = new DocumentNode(d.getRootElement(), null, this, w, 1, 0);
        this.ordered = true;
        this.uniqueIds = true;
        this.baseUri = baseUri;
    }

    public TreeDocument(Document d, URI baseUri, boolean ordered) throws XmlDocumentParseException {
        this.init();
        SemsWeighter w = new SemsWeighter();
        this.root = new DocumentNode(d.getRootElement(), null, this, w, 1, 0);
        this.ordered = ordered;
        this.uniqueIds = true;
        this.baseUri = baseUri;
    }

    public TreeDocument(Document d, Weighter w, URI baseUri, boolean ordered) throws XmlDocumentParseException {
        this.init();
        if (w == null) {
            w = new SemsWeighter();
        }
        this.root = new DocumentNode(d.getRootElement(), null, this, w, 1, 0);
        this.ordered = ordered;
        this.uniqueIds = true;
        this.baseUri = baseUri;
    }

    public TreeDocument(TreeDocument td) {
        this.init();
        this.uniqueIds = true;
        this.root = td.root.extract();
        this.integrate(this.root, true);
        this.ordered = td.ordered;
        this.baseUri = td.baseUri;
    }

    @Deprecated
    public void resortSubtrees() {
    }

    public void integrate(TreeNode node, boolean recursively) {
        this.pathMapper.putNode(node.getXPath(), node);
        this.subtreesBySize.add(node);
        this.hashMapper.addNode(node.getSubTreeHash(), node);
        if (node.getType() == 1) {
            DocumentNode dnode = (DocumentNode)node;
            this.tagMapper.addNode(dnode.getTagName(), dnode);
            String id = dnode.getId();
            if (id != null) {
                if (this.idMapper.getNode(id) != null) {
                    this.uniqueIds = false;
                } else {
                    this.idMapper.putNode(id, dnode);
                }
            }
            if (recursively) {
                List<TreeNode> kids = dnode.getChildren();
                for (TreeNode tn : kids) {
                    this.integrate(tn, recursively);
                }
            }
        } else {
            this.textNodes.add((TextNode)node);
        }
        node.doc = this;
    }

    public void separate(TreeNode node, boolean recursively) {
        this.pathMapper.rmNode(node.getXPath());
        this.subtreesBySize.remove(node);
        this.hashMapper.rmNode(node.getSubTreeHash(), node);
        if (node.getType() == 1) {
            DocumentNode dnode = (DocumentNode)node;
            this.tagMapper.rmNode(dnode.getTagName(), dnode);
            if (dnode.getId() != null) {
                this.idMapper.rmNode(dnode.getId());
            }
            if (recursively) {
                List<TreeNode> kids = dnode.getChildren();
                for (TreeNode tn : kids) {
                    this.separate(tn, recursively);
                }
            }
        } else {
            this.textNodes.remove(node);
        }
        node.doc = null;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public boolean uniqueIds() {
        return this.uniqueIds;
    }

    public void resetAllModifications() {
        this.root.resetModifications();
    }

    public DocumentNode getRoot() {
        return this.root;
    }

    public int getNumNodes() {
        return this.root.getSizeSubtree() + 1;
    }

    public double getTreeWeight() {
        return this.root.getWeight();
    }

    public List<TextNode> getTextNodes() {
        return this.textNodes;
    }

    public List<DocumentNode> getNodesByTag(String tag) {
        List<DocumentNode> nodes = this.tagMapper.getNodes(tag);
        if (nodes == null) {
            return new ArrayList<DocumentNode>();
        }
        return this.tagMapper.getNodes(tag);
    }

    public TreeNode[] getSubtreesBySize() {
        TreeNode[] tmp = new TreeNode[this.subtreesBySize.size()];
        this.subtreesBySize.toArray(tmp);
        return tmp;
    }

    public List<TreeNode> getNodesByHash(String hash) {
        return this.hashMapper.getNodes(hash);
    }

    public DocumentNode getNodeById(String id) {
        if (this.uniqueIds) {
            return this.idMapper.getNode(id);
        }
        return null;
    }

    public TreeNode getNodeByPath(String path) {
        return this.pathMapper.getNode(path);
    }

    public Set<String> getOccurringXPaths() {
        return this.pathMapper.getIds();
    }

    public Set<String> getOccurringIds() {
        if (this.uniqueIds) {
            return this.idMapper.getIds();
        }
        return null;
    }

    public Set<String> getOccurringTags() {
        return this.tagMapper.getIds();
    }

    public Set<String> getOccurringHashes() {
        return this.hashMapper.getIds();
    }

    public HashMap<String, Integer> getNodeStats() {
        HashMap<String, Integer> tags = new HashMap<String, Integer>();
        this.root.getNodeStats(tags);
        return tags;
    }

    public String dump() {
        return this.root.dump("");
    }

    public String toString() {
        String s = this.root.toString() + " - " + this.ordered;
        s = s + "\n\n\n";
        return s;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof TreeDocument) {
            DocumentNode thisNode = this.getRoot();
            DocumentNode otherNode = ((TreeDocument)anObject).getRoot();
            if (thisNode == null || otherNode == null) {
                return thisNode == null && otherNode == null;
            }
            return thisNode.getSubTreeHash().equals(otherNode.getSubTreeHash()) && thisNode.getSizeSubtree() == otherNode.getSizeSubtree();
        }
        return false;
    }
}

