/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.xmlutils.ds;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.xmlutils.alg.Weighter;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.HashMap;
import org.jdom2.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextNode
extends TreeNode {
    private String text;
    private double weight;
    private Weighter weighter;

    public TextNode(TextNode toCopy, DocumentNode parent, int numChild) {
        super(2, parent, null, parent == null ? 0 : parent.level + 1);
        this.text = toCopy.text;
        this.xPath = parent == null ? "" : parent.getXPath();
        this.xPath = this.xPath + "/text()[" + numChild + "]";
        this.ownHash = toCopy.ownHash;
        this.weight = toCopy.weight;
        this.weighter = toCopy.weighter;
    }

    public TextNode(String text, DocumentNode parent, TreeDocument doc, int numChild, Weighter w, int level) {
        super(2, parent, doc, level);
        this.text = text;
        this.xPath = parent == null ? "" : parent.getXPath();
        this.xPath = this.xPath + "/text()[" + numChild + "]";
        this.ownHash = GeneralTools.hash((String)text);
        this.weighter = w;
        this.weight = w.getWeight(this);
        doc.integrate(this, false);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.reSetupStructureUp();
    }

    @Override
    public boolean evaluate(ConnectionManager conMgmr) {
        this.setModification(0);
        Connection con = conMgmr.getConnectionForNode(this);
        if (con == null || con.getPartnerOf(this) == null) {
            this.addModification(257);
            return true;
        }
        TreeNode partner = con.getPartnerOf(this);
        if (this.contentDiffers(partner)) {
            this.addModification(4);
        }
        if (this.networkDiffers(partner, conMgmr, con)) {
            this.addModification(2);
        }
        LOGGER.debug((Object[])new Object[]{"mod: ", this.modified, "(", this.xPath, ")"});
        return (this.modified & 7) != 0;
    }

    @Override
    public String dump(String prefix) {
        return prefix + this.xPath + " -> " + this.modified + "\n";
    }

    @Override
    public Element getSubDoc(Element parent) {
        if (parent != null) {
            parent.setText(this.text);
        }
        return null;
    }

    @Override
    protected void reSetupStructureDown(TreeDocument doc, int numChild) {
        if (this.doc != null) {
            this.doc.separate(this, false);
        }
        this.doc = doc;
        this.xPath = this.parent.xPath + "/" + "text()" + "[" + numChild + "]";
        this.level = this.parent.level + 1;
        if (this.doc != null) {
            this.doc.integrate(this, false);
        }
    }

    @Override
    protected void reSetupStructureUp() {
        TreeDocument treeDoc = this.doc;
        if (this.doc != null) {
            this.doc.separate(this, false);
        }
        this.ownHash = GeneralTools.hash((String)this.text);
        if (treeDoc != null) {
            treeDoc.integrate(this, false);
        }
        this.weight = this.weighter.getWeight(this);
        if (this.parent != null) {
            this.parent.reSetupStructureUp();
        }
    }

    @Override
    public void getNodeStats(HashMap<String, Integer> map) {
        Integer i = map.get("text()");
        if (i == null) {
            map.put("text()", 1);
        } else {
            map.put("text()", i + 1);
        }
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public String getOwnHash() {
        return this.ownHash;
    }

    @Override
    public String getSubTreeHash() {
        return this.ownHash;
    }

    public String toString() {
        return "TEXT: " + this.weight + "\t(" + this.xPath + ")\t" + this.text;
    }

    @Override
    public String getTagName() {
        return "text()";
    }

    public double getTextDistance(TextNode cmp) {
        double dist = GeneralTools.computeLevenshteinDistance((String)this.text, (String)cmp.text);
        return dist / (double)Math.max(this.text.length(), cmp.text.length());
    }
}

