/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.xmlutils.ds;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.xmlutils.alg.Weighter;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import de.unirostock.sems.xmlutils.exception.XmlDocumentConsistencyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentNode
extends TreeNode {
    public static String ID_ATTR = "id";
    private String tagName;
    private String nsUri;
    private String nsPrefix;
    private String id;
    private Map<String, Attribute> attributes;
    private List<TreeNode> children;
    private HashMap<String, ArrayList<TreeNode>> childrenByTag;
    private String subTreeHash;
    private int sizeSubtree;
    private int numLeaves;
    private double weight;
    private Weighter weighter;

    private DocumentNode(DocumentNode toCopy, DocumentNode parent, int numChild) {
        super(1, parent, null, parent == null ? 0 : parent.level + 1);
        this.tagName = toCopy.tagName;
        this.nsPrefix = toCopy.nsPrefix;
        this.nsUri = toCopy.nsUri;
        this.id = toCopy.id;
        this.sizeSubtree = toCopy.sizeSubtree;
        this.numLeaves = toCopy.numLeaves;
        this.weight = toCopy.weight;
        this.weighter = toCopy.weighter;
        this.xPath = parent == null ? "" : parent.getXPath();
        this.xPath = this.xPath + "/" + this.tagName + "[" + numChild + "]";
        this.attributes = new TreeMap<String, Attribute>();
        for (String attr : toCopy.attributes.keySet()) {
            this.attributes.put(attr, toCopy.attributes.get(attr).clone());
        }
        this.children = new ArrayList<TreeNode>();
        this.childrenByTag = new HashMap();
        for (TreeNode tn : toCopy.getChildren()) {
            TreeNode cc;
            TreeNode c;
            if (tn.getType() == 1) {
                c = (DocumentNode)tn;
                if (this.childrenByTag.get(c.tagName) == null) {
                    this.childrenByTag.put(c.tagName, new ArrayList());
                }
                cc = new DocumentNode((DocumentNode)c, this, this.childrenByTag.get(c.tagName).size() + 1);
                this.children.add(cc);
                ((DocumentNode)cc).parent = this;
                this.childrenByTag.get(((DocumentNode)cc).tagName).add(cc);
                continue;
            }
            if (this.childrenByTag.get("text()") == null) {
                this.childrenByTag.put("text()", new ArrayList());
            }
            c = (TextNode)tn;
            cc = new TextNode((TextNode)c, this, this.childrenByTag.get("text()").size() + 1);
            this.children.add(cc);
            cc.parent = this;
            this.childrenByTag.get("text()").add(cc);
        }
        this.doc = null;
        this.ownHash = toCopy.ownHash;
        this.subTreeHash = toCopy.subTreeHash;
    }

    public DocumentNode(Element element, DocumentNode parent, TreeDocument doc, Weighter w, int numChild, int level) {
        super(1, parent, doc, level);
        this.attributes = new TreeMap<String, Attribute>();
        this.children = new ArrayList<TreeNode>();
        this.tagName = element.getName();
        this.nsPrefix = element.getNamespacePrefix();
        this.nsUri = element.getNamespaceURI();
        this.numLeaves = 0;
        this.sizeSubtree = 0;
        this.weighter = w;
        this.xPath = parent == null ? "" : parent.getXPath();
        this.xPath = this.xPath + "/" + this.tagName + "[" + numChild + "]";
        List attrs = element.getAttributes();
        for (Attribute a : attrs) {
            this.attributes.put(a.getName(), a);
        }
        this.id = this.attributes.get(ID_ATTR) == null ? null : this.attributes.get(ID_ATTR).getValue();
        List kids = element.getContent();
        this.childrenByTag = new HashMap();
        for (Content current : kids) {
            String text;
            TreeNode kid;
            if (current.getCType() == Content.CType.Element) {
                Element cur = (Element)current;
                if (this.childrenByTag.get(cur.getName()) == null) {
                    this.childrenByTag.put(cur.getName(), new ArrayList());
                }
                kid = new DocumentNode(cur, this, doc, w, this.childrenByTag.get(cur.getName()).size() + 1, level + 1);
                this.children.add(kid);
                this.childrenByTag.get(cur.getName()).add(kid);
                this.sizeSubtree += ((DocumentNode)kid).getSizeSubtree() + 1;
                this.numLeaves += ((DocumentNode)kid).getNumLeaves();
            }
            if (current.getCType() != Content.CType.Text || (text = ((Text)current).getText().trim()).length() < 1) continue;
            if (this.childrenByTag.get("text()") == null) {
                this.childrenByTag.put("text()", new ArrayList());
            }
            kid = new TextNode(text, this, doc, this.childrenByTag.get("text()").size() + 1, w, level + 1);
            this.children.add(kid);
            this.childrenByTag.get("text()").add(kid);
            ++this.sizeSubtree;
            ++this.numLeaves;
        }
        this.calcHash();
        if (this.numLeaves == 0) {
            this.numLeaves = 1;
        }
        this.weight = w.getWeight(this);
        doc.integrate(this, false);
    }

    public DocumentNode extract() {
        return new DocumentNode(this, null, 1);
    }

    @Override
    public String getSubTreeHash() {
        return this.subTreeHash;
    }

    @Override
    public String getOwnHash() {
        return this.ownHash;
    }

    public int getSizeSubtree() {
        return this.sizeSubtree;
    }

    public int getNumLeaves() {
        return this.numLeaves;
    }

    public static final void setIdAttr(String id) {
        ID_ATTR = id;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    public String getId() {
        return this.id;
    }

    public void addChild(DocumentNode toAdd) {
        toAdd.parent = this;
        if (this.childrenByTag.get(toAdd.getTagName()) == null) {
            this.childrenByTag.put(toAdd.getTagName(), new ArrayList());
        }
        this.children.add(toAdd);
        this.doc.integrate(toAdd, true);
        toAdd.reSetupStructureDown(this.doc, this.childrenByTag.get(toAdd.getTagName()).size() + 1);
        this.childrenByTag.get(toAdd.getTagName()).add(toAdd);
        this.reSetupStructureUp();
        this.doc.resortSubtrees();
    }

    public void rmChild(DocumentNode toRemove) throws XmlDocumentConsistencyException {
        List nodes = this.childrenByTag.get(toRemove.getTagName());
        if (nodes == null) {
            return;
        }
        if (!nodes.remove(toRemove)) {
            return;
        }
        if (!this.children.remove(toRemove)) {
            LOGGER.error((Object[])new Object[]{"we produced an inconsistent state. we removed a node", " from tag-mapped children, but weren't able to find it in", " children!?"});
            throw new XmlDocumentConsistencyException("inconsistens state. there was a node in tag-mapped children, but not in children!?");
        }
        this.doc.separate(toRemove, true);
        toRemove.parent = null;
        toRemove.reSetupStructureDown(null, 1);
        this.reSetupStructureUp();
        if (this.parent != null) {
            this.parent.reSetupStructureDown(this.doc, -1);
        } else {
            this.reSetupStructureDown(this.doc, -1);
        }
        if (this.doc != null) {
            this.doc.resortSubtrees();
        }
    }

    private void calcHash() {
        StringBuilder h = new StringBuilder();
        h.append(this.tagName);
        for (String a : this.attributes.keySet()) {
            h.append(";" + a + "=" + this.attributes.get(a));
        }
        this.ownHash = GeneralTools.hash((String)h.toString());
        for (TreeNode kid : this.children) {
            h.append(kid.getSubTreeHash());
        }
        this.subTreeHash = GeneralTools.hash((String)h.toString());
    }

    public String getAttributeValue(String attr) {
        if (this.attributes.get(attr) == null) {
            return null;
        }
        return this.attributes.get(attr).getValue();
    }

    public Attribute getAttribute(String attr) {
        return this.attributes.get(attr);
    }

    public String getAttributeValue(String attr, String nsContains) {
        if (this.attributes.get(attr) == null) {
            return null;
        }
        Attribute a = this.attributes.get(attr);
        if (a.getNamespaceURI().contains(nsContains)) {
            return a.getValue();
        }
        return null;
    }

    public void setAttribute(Attribute attr) {
        this.attributes.put(attr.getName(), attr);
        this.reSetupStructureUp();
    }

    public void setAttribute(String attr, String value) {
        this.setAttribute(new Attribute(attr, value));
    }

    public void rmAttribute(String attr) {
        this.attributes.remove(attr);
    }

    public Set<String> getAttributes() {
        return this.attributes.keySet();
    }

    public boolean isBelow(DocumentNode parent) {
        return this.doc == parent.doc && this.xPath.startsWith(parent.xPath);
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public List<TreeNode> getChildrenWithTag(String tag) {
        ArrayList<TreeNode> ret = this.childrenByTag.get(tag);
        if (ret == null) {
            return new ArrayList<TreeNode>();
        }
        return (ArrayList)ret.clone();
    }

    public HashMap<String, List<TreeNode>> getChildrenTagMap() {
        HashMap<String, List<TreeNode>> ret = new HashMap<String, List<TreeNode>>(this.childrenByTag.size());
        for (String tag : this.childrenByTag.keySet()) {
            ret.put(tag, (ArrayList)this.childrenByTag.get(tag).clone());
        }
        return ret;
    }

    public int getNoOfChild(TreeNode kid) {
        int ret = this.children.indexOf(kid);
        if (ret < 0) {
            return ret;
        }
        return ret + 1;
    }

    public double getAttributeDistance(DocumentNode cmp) {
        return this.getAttributeDistance(cmp, true, true, false);
    }

    public double getAttributeDistance(DocumentNode cmp, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        if (this.attributes.size() == 0 && cmp.attributes.size() == 0) {
            return 0.0;
        }
        double unmatch = 0.0;
        for (String name : this.attributes.keySet()) {
            if (cmp.attributes.get(name) == null) {
                unmatch += 1.0;
                continue;
            }
            String v1 = cmp.attributes.get(name).getValue();
            String v2 = this.attributes.get(name).getValue();
            if (careAboutNames && name.equals("name")) {
                if (v1.equals(v2)) continue;
                double dist = GeneralTools.computeLevenshteinDistance((String)v1, (String)v2);
                double len = Math.min(v1.length(), v2.length());
                if (stricterNames) {
                    unmatch += 15.0 * dist / (len / 6.0 + dist);
                    continue;
                }
                unmatch += 8.0 * dist / (len / 3.0 + dist);
                continue;
            }
            if (!allowDifferentIds && name.equals(ID_ATTR) && !v1.equals(v2)) {
                return 1.0;
            }
            if (v1.equals(v2)) continue;
            unmatch += 2.0;
        }
        for (String name : cmp.attributes.keySet()) {
            if (this.attributes.get(name) != null) continue;
            unmatch += 1.0;
        }
        if (unmatch < Double.MIN_VALUE) {
            return 0.0;
        }
        double dist = unmatch / (double)(this.attributes.size() + cmp.attributes.size());
        return dist > 1.0 ? 1.0 : dist;
    }

    public Weighter getWeighter() {
        return this.weighter;
    }

    public String getNameSpaceUri() {
        return this.nsUri;
    }

    public String getNameSpacePrefix() {
        return this.nsPrefix;
    }

    @Override
    public Element getSubDoc(Element parent) {
        Element node = new Element(this.tagName, this.nsPrefix, this.nsUri);
        for (String att : this.attributes.keySet()) {
            Attribute a = this.attributes.get(att);
            node.setAttribute(a.getName(), a.getValue(), a.getNamespace());
        }
        if (parent != null) {
            parent.addContent((Content)node);
        }
        for (TreeNode kid : this.children) {
            kid.getSubDoc(node);
        }
        return node;
    }

    @Override
    public void getNodeStats(HashMap<String, Integer> map) {
        Integer i = map.get(this.tagName);
        if (i == null) {
            map.put(this.tagName, 1);
        } else {
            map.put(this.tagName, i + 1);
        }
        for (TreeNode child : this.children) {
            child.getNodeStats(map);
        }
    }

    @Override
    public boolean evaluate(ConnectionManager conMgmr) {
        boolean kidChanged = false;
        boolean kidsUnmapped = true;
        for (TreeNode child : this.children) {
            kidChanged |= child.evaluate(conMgmr);
            if (child.hasModification(256)) continue;
            kidsUnmapped = false;
        }
        LOGGER.debug((Object[])new Object[]{"after subtreeunmapped mod of ", this.xPath, " = ", this.modified});
        if (kidChanged) {
            this.addModification(8);
        }
        LOGGER.debug((Object[])new Object[]{"evaluate kids changed: ", kidChanged, " -- for ", this.xPath});
        LOGGER.debug((Object[])new Object[]{"after kid changed mod of ", this.xPath, " = ", this.modified});
        Connection con = conMgmr.getConnectionForNode(this);
        if (con == null || con.getPartnerOf(this) == null) {
            LOGGER.debug((Object[])new Object[]{this.xPath, " is unmapped"});
            this.addModification(1);
            if (kidsUnmapped) {
                this.addModification(256);
            }
            return true;
        }
        LOGGER.debug((Object[])new Object[]{"after unmapped/subtreeunmapped mod of ", this.xPath, " = ", this.modified});
        TreeNode partner = con.getPartnerOf(this);
        LOGGER.debug((Object[])new Object[]{"evaluate ", this.xPath, " is mapped to ", partner.getXPath()});
        if (this.contentDiffers(partner)) {
            this.addModification(4);
        }
        LOGGER.debug((Object[])new Object[]{"after modified check mod of ", this.xPath, " = ", this.modified});
        if (this.networkDiffers(partner, conMgmr, con)) {
            this.addModification(2);
        }
        LOGGER.debug((Object[])new Object[]{"move check mod of ", this.xPath, " = ", this.modified});
        return this.modified != 0;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    protected void reSetupStructureDown(TreeDocument doc, int numChild) {
        if (this.doc != null) {
            this.doc.separate(this, false);
        }
        this.doc = doc;
        if (this.parent != null) {
            if (numChild > 0) {
                this.xPath = this.parent.xPath + "/" + this.tagName + "[" + numChild + "]";
            }
            this.level = this.parent.level + 1;
        } else if (numChild > 0) {
            this.xPath = "/" + this.tagName + "[" + numChild + "]";
        }
        for (String tag : this.childrenByTag.keySet()) {
            List kids = this.childrenByTag.get(tag);
            for (int i = 0; i < kids.size(); ++i) {
                ((TreeNode)kids.get(i)).reSetupStructureDown(doc, i + 1);
            }
        }
        if (this.doc != null) {
            this.doc.integrate(this, false);
        }
    }

    @Override
    protected void reSetupStructureUp() {
        TreeDocument treeDoc = this.doc;
        if (this.doc != null) {
            this.doc.separate(this, false);
        }
        this.calcHash();
        this.numLeaves = 0;
        this.sizeSubtree = 0;
        for (TreeNode kid : this.children) {
            if (kid.type == 1) {
                DocumentNode k = (DocumentNode)kid;
                this.numLeaves += k.numLeaves;
                this.sizeSubtree += k.getSizeSubtree() + 1;
                continue;
            }
            ++this.numLeaves;
            ++this.sizeSubtree;
        }
        if (this.numLeaves == 0) {
            this.numLeaves = 1;
        }
        if (treeDoc != null) {
            treeDoc.integrate(this, false);
        }
        this.weight = this.weighter.getWeight(this);
        if (this.parent != null) {
            this.parent.reSetupStructureUp();
        }
    }

    public String toString() {
        StringBuilder attr = new StringBuilder(" ");
        for (String a : this.attributes.keySet()) {
            attr.append(a + "=\"" + this.attributes.get(a) + "\" ");
        }
        attr = new StringBuilder("<" + this.tagName + attr.toString() + ">\t" + this.weight + "\t(" + this.xPath + ")\t" + this.subTreeHash + "\n");
        for (int i = 0; i < this.children.size(); ++i) {
            attr.append(this.children.get(i));
        }
        return attr.toString() + "</" + this.tagName + ">\n";
    }

    @Override
    public String dump(String prefix) {
        String s = prefix + this.xPath + " -> " + this.modified + "\n";
        for (TreeNode child : this.children) {
            s = s + child.dump(prefix + "\t");
        }
        return s;
    }

    public Namespace getNameSpace() {
        return Namespace.getNamespace((String)this.nsPrefix, (String)this.nsUri);
    }
}

