/*
 * Decompiled with CFR 0.152.
 */
package org.sbgn.schematron;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.sbgn.Language;
import org.sbgn.SbgnUtil;
import org.sbgn.SbgnVersionFinder;
import org.sbgn.schematron.Issue;
import org.sbgn.schematron.SVRLHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchematronValidator {
    private static boolean fSvrlDump = false;
    private List<Issue> issues;

    private SchematronValidator() {
    }

    public static void setSvrlDump(boolean value) {
        fSvrlDump = value;
    }

    public static List<Issue> validate(File exportedPwFile) throws IOException, ParserConfigurationException, TransformerException, SAXException {
        SchematronValidator stf = new SchematronValidator();
        stf.doValidation(exportedPwFile);
        List<Issue> result = stf.getIssues();
        return result;
    }

    private void doValidation(File inputFile) throws ParserConfigurationException, TransformerException, IOException, SAXException {
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        String res = SbgnUtil.getResource("/iso_svrl_for_xslt2.xsl");
        Transformer transformer1 = factory.newTransformer(new StreamSource(res));
        Language lang = SbgnVersionFinder.getLanguage(inputFile);
        String schema = SbgnUtil.getResource("/sbgn_" + lang.name().toLowerCase() + ".sch");
        StreamSource schemaSource = new StreamSource(schema);
        StreamSource inputSource = new StreamSource(inputFile);
        StringWriter sw1 = new StringWriter();
        StreamResult result1 = new StreamResult(sw1);
        transformer1.transform(schemaSource, result1);
        Transformer transformer2 = factory.newTransformer(new StreamSource(new StringReader(sw1.toString())));
        StringWriter sw2 = new StringWriter();
        StreamResult result2 = new StreamResult(sw2);
        transformer2.transform(inputSource, result2);
        if (fSvrlDump) {
            File f = File.createTempFile(inputFile.getName(), ".svrl");
            System.out.println("SVRL Location: " + f);
            PrintWriter out = new PrintWriter(f);
            out.println(sw2.toString());
            out.close();
        }
        this.parseSVRL(this.removeXMLheader(sw2.toString()));
    }

    private String removeXMLheader(String svrl) {
        int firstLineEnd = svrl.indexOf("\n");
        if (svrl.startsWith("<?xml ") || svrl.startsWith("<?xml ", 1) || svrl.startsWith("<?xml ", 2) || svrl.startsWith("<?xml ", 3)) {
            return svrl.substring(firstLineEnd + 1);
        }
        return svrl;
    }

    private void parseSVRL(String svrl) throws IOException, SAXException, ParserConfigurationException {
        SVRLHandler handler = new SVRLHandler();
        InputSource is = new InputSource(new StringReader(svrl));
        is.setEncoding("UTF-16");
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        saxParser.parse(is, (DefaultHandler)handler);
        this.issues = handler.getIssues();
    }

    private List<Issue> getIssues() {
        return this.issues;
    }
}

