/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Difference;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.DyadicDatasetGraph;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class DifferenceDatasetGraph
extends DyadicDatasetGraph {
    public DifferenceDatasetGraph(DatasetGraph left, DatasetGraph right, Context c) {
        super(left, right, c);
    }

    private Graph difference(Function<DatasetGraph, Graph> op) {
        return this.apply(DifferenceView::new, op);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.difference(DatasetGraph::getDefaultGraph);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return this.difference(dsg -> dsg.getGraph(graphNode));
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return ((DatasetGraph)this.getLeft()).containsGraph(graphNode);
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return ((DatasetGraph)this.getLeft()).listGraphNodes();
    }

    @Override
    public boolean contains(Node g2, Node s2, Node p, Node o) {
        return ((DatasetGraph)this.getLeft()).contains(g2, s2, p, o) && !((DatasetGraph)this.getRight()).contains(g2, s2, p, o);
    }

    @Override
    public boolean isEmpty() {
        return ((DatasetGraph)this.getLeft()).isEmpty() || this.getLeft() == this.getRight() || !this.contains(Quad.ANY);
    }

    @Override
    public long size() {
        return ((DatasetGraph)this.getLeft()).size();
    }

    static class DifferenceView
    extends Difference {
        public DifferenceView(Graph L, Graph R) {
            super(L, R);
        }

        @Override
        public void performAdd(Triple t) {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        @Override
        public void performDelete(Triple t) {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        @Override
        public void clear() {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        @Override
        public ExtendedIterator<Triple> _graphBaseFind(Triple s2) {
            return this.L.isEmpty() ? NullIterator.instance() : super._graphBaseFind(s2);
        }
    }
}

