/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.ResultSetProcessor;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.util.FileUtils;

public class PlainFormat
implements ResultSetProcessor {
    PrintWriter out;
    int count = 0;
    boolean lineNumbers = true;
    boolean first = true;
    SerializationContext context;

    public PlainFormat(OutputStream outStream, SerializationContext context) {
        this.out = FileUtils.asPrintWriterUTF8(outStream);
        this.context = context;
    }

    public PlainFormat(OutputStream outStream, Prologue prologue) {
        this(outStream, new SerializationContext(prologue));
    }

    @Override
    public void start(ResultSet rs) {
    }

    @Override
    public void finish(ResultSet rs) {
        this.out.flush();
    }

    @Override
    public void start(QuerySolution qs) {
        ++this.count;
        this.first = true;
    }

    @Override
    public void finish(QuerySolution qs) {
        this.out.println();
    }

    @Override
    public void binding(String varName, RDFNode value) {
        if (value == null) {
            return;
        }
        if (!this.first) {
            this.out.print(" ");
        }
        String s2 = FmtUtils.stringForRDFNode(value, this.context);
        this.out.print("( ?" + varName + " = " + s2 + " )");
        this.first = false;
    }

    void insertLineNumber() {
        if (!this.lineNumbers) {
            return;
        }
        String s2 = Integer.toString(this.count);
        for (int i = 0; i < 3 - s2.length(); ++i) {
            this.out.print(' ');
        }
        this.out.print(s2);
        this.out.print(' ');
    }
}

