/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.table.TableUnit;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.path.Path;

class NodeTransformOp
extends TransformCopy {
    private final NodeTransform transform;

    NodeTransformOp(NodeTransform transform) {
        this.transform = transform;
    }

    @Override
    public Op transform(OpTriple opTriple) {
        Triple t2 = NodeTransformLib.transform(this.transform, opTriple.getTriple());
        if (t2 == opTriple.getTriple()) {
            return super.transform(opTriple);
        }
        return new OpTriple(t2);
    }

    @Override
    public Op transform(OpBGP opBGP) {
        BasicPattern bgp2 = NodeTransformLib.transform(this.transform, opBGP.getPattern());
        if (bgp2 == opBGP.getPattern()) {
            return super.transform(opBGP);
        }
        return new OpBGP(bgp2);
    }

    @Override
    public Op transform(OpPath opPath) {
        TriplePath tp2;
        TriplePath tp = opPath.getTriplePath();
        Node s2 = tp.getSubject();
        Node s1 = (Node)this.transform.apply(s2);
        Node o = tp.getObject();
        Node o1 = (Node)this.transform.apply(o);
        if (s1 == s2 && o1 == o) {
            return super.transform(opPath);
        }
        Path path = tp.getPath();
        if (path != null) {
            tp2 = new TriplePath(s1, path, o1);
        } else {
            Triple t = new Triple(s1, tp.getPredicate(), o1);
            tp2 = new TriplePath(t);
        }
        return new OpPath(tp2);
    }

    @Override
    public Op transform(OpQuadPattern opQuadPattern) {
        BasicPattern bgp2 = NodeTransformLib.transform(this.transform, opQuadPattern.getBasicPattern());
        Node g2 = opQuadPattern.getGraphNode();
        if ((g2 = (Node)this.transform.apply(g2)) == opQuadPattern.getGraphNode() && bgp2 == opQuadPattern.getBasicPattern()) {
            return super.transform(opQuadPattern);
        }
        return new OpQuadPattern(g2, bgp2);
    }

    @Override
    public Op transform(OpGraph opGraph, Op subOp) {
        Node g2 = (Node)this.transform.apply(opGraph.getNode());
        if (g2 == opGraph.getNode()) {
            return super.transform(opGraph, subOp);
        }
        return new OpGraph(g2, subOp);
    }

    @Override
    public Op transform(OpDatasetNames opDatasetNames) {
        Node g2 = (Node)this.transform.apply(opDatasetNames.getGraphNode());
        if (g2 == opDatasetNames.getGraphNode()) {
            return super.transform(opDatasetNames);
        }
        return new OpDatasetNames(g2);
    }

    @Override
    public Op transform(OpTable opTable) {
        if (opTable.isJoinIdentity()) {
            return opTable;
        }
        Table table = opTable.getTable();
        if (table.isEmpty()) {
            return opTable;
        }
        if (TableUnit.isTableUnit(table)) {
            return opTable;
        }
        if (table.getVars().size() == 0) {
            return opTable;
        }
        Table table2 = NodeTransformLib.transform(table, this.transform);
        return OpTable.create(table2);
    }

    @Override
    public Op transform(OpProject opProject, Op subOp) {
        List<Var> x2;
        List<Var> x = opProject.getVars();
        if (x == (x2 = NodeTransformLib.transformVars(this.transform, x))) {
            return super.transform(opProject, subOp);
        }
        return new OpProject(subOp, x2);
    }

    @Override
    public Op transform(OpAssign opAssign, Op subOp) {
        VarExprList varExprList2;
        VarExprList varExprList = opAssign.getVarExprList();
        if (varExprList == (varExprList2 = NodeTransformLib.transformVars(this.transform, varExprList))) {
            return super.transform(opAssign, subOp);
        }
        return OpAssign.assign(subOp, varExprList2);
    }

    @Override
    public Op transform(OpExtend opExtend, Op subOp) {
        VarExprList varExprList2;
        VarExprList varExprList = opExtend.getVarExprList();
        if (varExprList == (varExprList2 = NodeTransformLib.transformVars(this.transform, varExprList))) {
            return super.transform(opExtend, subOp);
        }
        return OpExtend.create(subOp, varExprList2);
    }

    @Override
    public Op transform(OpGroup opGroup, Op subOp) {
        VarExprList groupVars = opGroup.getGroupVars();
        VarExprList groupVars2 = NodeTransformLib.transformVars(this.transform, groupVars);
        if (groupVars2 == groupVars) {
            return super.transform(opGroup, subOp);
        }
        return OpGroup.create(subOp, groupVars2, opGroup.getAggregators());
    }
}

