/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.math.BigDecimal;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.util.Utils;

public class NodeValueDecimal
extends NodeValue {
    BigDecimal decimal;

    public NodeValueDecimal(BigDecimal d) {
        this.decimal = d;
    }

    public NodeValueDecimal(BigDecimal d, Node n) {
        super(n);
        this.decimal = d;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isDecimal() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public BigDecimal getDecimal() {
        return this.decimal;
    }

    @Override
    public float getFloat() {
        return this.decimal.floatValue();
    }

    @Override
    public double getDouble() {
        return this.decimal.doubleValue();
    }

    @Override
    protected Node makeNode() {
        int s2 = this.decimal.scale();
        return NodeFactory.createLiteral(Utils.stringForm(this.decimal), XSDDatatype.XSDdecimal);
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return Utils.stringForm(this.decimal);
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

