/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared.uuid;

import java.util.Locale;
import java.util.Random;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.shared.uuid.JenaUUID;
import org.apache.jena.shared.uuid.LibUUID;
import org.apache.jena.shared.uuid.UUIDFactory;
import org.apache.jena.shared.uuid.UUID_V4;

public class UUID_V4_Gen
implements UUIDFactory {
    static final int versionHere = 4;
    static final int variantHere = 2;
    private Random random = null;

    @Override
    public JenaUUID generate() {
        return this.generateV4();
    }

    public UUID_V4 generateV4() {
        this.init();
        long mostSigBits = this.random.nextLong();
        long leastSigBits = this.random.nextLong();
        mostSigBits = BitsLong.pack(mostSigBits, 4L, 12, 16);
        leastSigBits = BitsLong.pack(leastSigBits, 2L, 62, 64);
        return new UUID_V4(mostSigBits, leastSigBits);
    }

    @Override
    public JenaUUID parse(String s2) {
        return this.parseV4(s2);
    }

    public UUID_V4 parseV4(String s2) {
        if ((s2 = s2.toLowerCase(Locale.ENGLISH)).length() != 36) {
            throw new JenaUUID.UUIDFormatException("UUID string is not 36 chars long: it's " + s2.length() + " [" + s2 + "]");
        }
        if (s2.charAt(8) != '-' && s2.charAt(13) != '-' && s2.charAt(18) != '-' && s2.charAt(23) != '-') {
            throw new JenaUUID.UUIDFormatException("String does not have dashes in the right places: " + s2);
        }
        UUID_V4 u = UUID_V4_Gen.parse$(s2);
        if (u.getVersion() != 4) {
            throw new JenaUUID.UUIDFormatException("Wrong version (Expected: 4Got: " + u.getVersion() + "): " + s2);
        }
        if (u.getVariant() != 2) {
            throw new JenaUUID.UUIDFormatException("Wrong version (Expected: 2Got: " + u.getVariant() + "): " + s2);
        }
        return u;
    }

    static UUID_V4 parse$(String s2) {
        long mostSigBits = BitsLong.unpack(s2, 0, 8);
        mostSigBits = mostSigBits << 16 | BitsLong.unpack(s2, 9, 13);
        mostSigBits = mostSigBits << 16 | BitsLong.unpack(s2, 14, 18);
        long leastSigBits = BitsLong.unpack(s2, 19, 23);
        leastSigBits = leastSigBits << 48 | BitsLong.unpack(s2, 24, 36);
        return new UUID_V4(mostSigBits, leastSigBits);
    }

    private void init() {
        if (this.random == null) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.random = LibUUID.makeRandom();
    }
}

