/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.NodeIteratorImpl;
import org.apache.jena.rdf.model.impl.ResIteratorImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.util.iterator.WrappedIterator;

public final class IteratorFactory {
    private IteratorFactory() {
    }

    public static StmtIterator asStmtIterator(Iterator<Triple> i, ModelCom m3) {
        return new StmtIteratorImpl((Iterator<Statement>)WrappedIterator.create(i).mapWith(t -> m3.asStatement((Triple)t)));
    }

    public static ResIterator asResIterator(Iterator<Node> i, ModelCom m3) {
        return new ResIteratorImpl(WrappedIterator.create(i).mapWith(o -> (Resource)m3.asRDFNode((Node)o)), null);
    }

    public static NodeIterator asRDFNodeIterator(Iterator<Node> i, ModelCom m3) {
        return new NodeIteratorImpl(WrappedIterator.create(i).mapWith(o -> m3.asRDFNode((Node)o)), null);
    }

    static Resource asResource(Node n, ModelCom m3) {
        return IteratorFactory.asResource(n, Resource.class, m3);
    }

    static Property asProperty(Node n, ModelCom m3) {
        return (Property)IteratorFactory.asResource(n, Property.class, m3);
    }

    static Literal asLiteral(Node n, ModelCom m3) {
        return m3.getNodeAs(n, Literal.class);
    }

    static <X extends RDFNode> Resource asResource(Node n, Class<X> cl, ModelCom m3) {
        return (Resource)m3.getNodeAs(n, cl);
    }
}

