/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.n3.turtle;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.n3.turtle.TurtleEventHandler;
import org.apache.jena.n3.turtle.TurtleParseException;

public class TurtleRDFGraphInserter
implements TurtleEventHandler {
    Graph graph = null;

    public TurtleRDFGraphInserter(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void triple(int line, int col, Triple triple) {
        Node s2 = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        if (!s2.isURI() && !s2.isBlank()) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Subject is not a URI or blank node");
        }
        if (!p.isURI()) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Predicate is not a URI");
        }
        if (!(o.isURI() || o.isBlank() || o.isLiteral())) {
            throw new TurtleParseException("[" + line + ", " + col + "] : Error: Object is not a URI, blank node or literal");
        }
        this.graph.add(triple);
    }

    @Override
    public void startFormula(int line, int col) {
        throw new TurtleParseException("[" + line + ", " + col + "] : Error: Formula found");
    }

    @Override
    public void endFormula(int line, int col) {
        throw new TurtleParseException("[" + line + ", " + col + "] : Error: Formula found");
    }

    @Override
    public void prefix(int line, int col, String prefix, String iri) {
        this.graph.getPrefixMapping().setNsPrefix(prefix, iri);
    }
}

