/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.Locale;
import java.util.Objects;
import org.apache.jena.JenaRuntime;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.impl.AdhocDatatype;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.impl.JenaParameters;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LiteralLabelImpl
implements LiteralLabel {
    private static Logger log = LoggerFactory.getLogger(LiteralLabelImpl.class);
    private String lexicalForm;
    private Object value;
    private RDFDatatype dtype;
    private String lang;
    private boolean wellformed = true;
    private String exceptionMsg = null;
    private int hash = 0;

    LiteralLabelImpl(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        this.setLiteralLabel_1(lex, lang, dtype);
    }

    private void setLiteralLabel_1(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        this.lexicalForm = lex;
        this.dtype = dtype;
        String string = this.lang = lang == null ? "" : lang;
        if (dtype == null) {
            this.value = lex;
        } else {
            this.setValue(lex);
        }
        this.normalize();
    }

    LiteralLabelImpl(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        this.setLiteralLabel_2(value, lang, dtype);
    }

    LiteralLabelImpl(Object value) {
        RDFDatatype dt = TypeMapper.getInstance().getTypeByValue(value);
        if (dt == null) {
            this.setWithNewDatatypeForValueClass(value);
        } else {
            this.setLiteralLabel_2(value, "", dt);
        }
    }

    private void setWithNewDatatypeForValueClass(Object value) {
        Class<?> c = value.getClass();
        log.warn("inventing a datatype for " + c);
        AdhocDatatype dt = new AdhocDatatype(c);
        TypeMapper.getInstance().registerDatatype(dt);
        this.lang = "";
        this.dtype = dt;
        this.value = value;
        this.lexicalForm = value.toString();
    }

    private void setLiteralLabel_2(Object value, String language, RDFDatatype dtype) throws DatatypeFormatException {
        this.dtype = dtype;
        String string = this.lang = language == null ? "" : language;
        if (value instanceof String) {
            String lex;
            this.lexicalForm = lex = (String)value;
            if (dtype == null) {
                this.value = lex;
            } else {
                this.setValue(lex);
            }
        } else {
            this.value = dtype == null ? value : dtype.cannonicalise(value);
        }
        this.normalize();
        if (dtype != null && this.lexicalForm == null) {
            this.wellformed = this.dtype.isValidValue(value);
            if (JenaParameters.enableEagerLiteralValidation && !this.wellformed) {
                throw new DatatypeFormatException(value.toString(), dtype, "in literal creation");
            }
        }
    }

    LiteralLabelImpl(String s2, String lang, boolean xml) {
        this.setLiteralLabel_3(s2, lang, xml);
    }

    private void setLiteralLabel_3(String s2, String lang, boolean xml) {
        this.lexicalForm = s2;
        String string = this.lang = lang == null ? "" : lang;
        if (xml) {
            this.dtype = XMLLiteralType.theXMLLiteralType;
            this.value = s2;
            this.wellformed = true;
        } else {
            this.value = s2;
            this.dtype = null;
        }
    }

    private void setValue(String lex) throws DatatypeFormatException {
        try {
            this.value = this.dtype.parse(lex);
            this.wellformed = true;
        }
        catch (DatatypeFormatException e2) {
            if (JenaParameters.enableEagerLiteralValidation) {
                e2.fillInStackTrace();
                throw e2;
            }
            this.wellformed = false;
            this.exceptionMsg = e2.getMessage();
        }
    }

    protected void normalize() {
        if (this.dtype != null && this.value != null) {
            this.dtype = this.dtype.normalizeSubType(this.value, this.dtype);
        }
    }

    @Override
    public boolean isXML() {
        return this.dtype == XMLLiteralType.theXMLLiteralType && this.wellformed;
    }

    @Override
    public boolean isWellFormed() {
        return this.dtype != null && this.wellformed;
    }

    @Override
    public boolean isWellFormedRaw() {
        return this.wellformed;
    }

    @Override
    public String toString(boolean quoting) {
        StringBuilder b = new StringBuilder();
        if (quoting) {
            b.append('\"');
        }
        String lex = this.getLexicalForm();
        lex = Util.replace(lex, "\"", "\\\"");
        b.append(lex);
        if (quoting) {
            b.append('\"');
        }
        if (this.lang != null && !this.lang.equals("")) {
            b.append("@").append(this.lang);
        } else if (!(this.dtype == null || JenaRuntime.isRDF11 && this.dtype.equals(XSDDatatype.XSDstring))) {
            b.append("^^").append(this.dtype.getURI());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String getLexicalForm() {
        if (this.lexicalForm == null) {
            this.lexicalForm = this.dtype == null ? this.value.toString() : this.dtype.unparse(this.value);
        }
        return this.lexicalForm;
    }

    @Override
    public Object getIndexingValue() {
        return this.isXML() ? this : (!this.lang.equals("") ? this.getLexicalForm() + "@" + this.lang.toLowerCase(Locale.ROOT) : (this.wellformed ? this.getValue() : this.getLexicalForm()));
    }

    @Override
    public String language() {
        return this.lang;
    }

    @Override
    public Object getValue() throws DatatypeFormatException {
        if (this.wellformed) {
            return this.value;
        }
        throw new DatatypeFormatException(this.lexicalForm, this.dtype, this.exceptionMsg);
    }

    @Override
    public RDFDatatype getDatatype() {
        return this.dtype;
    }

    @Override
    public String getDatatypeURI() {
        if (this.dtype == null) {
            return null;
        }
        return this.dtype.getURI();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof LiteralLabel)) {
            return false;
        }
        LiteralLabel otherLiteral = (LiteralLabel)other;
        boolean typeEquals = Objects.equals(this.dtype, otherLiteral.getDatatype());
        if (!typeEquals) {
            return false;
        }
        boolean lexEquals = Objects.equals(this.getLexicalForm(), otherLiteral.getLexicalForm());
        if (!lexEquals) {
            return false;
        }
        boolean langEquals = Objects.equals(this.lang, otherLiteral.language());
        return langEquals;
    }

    @Override
    public boolean sameValueAs(LiteralLabel other) {
        return LiteralLabelImpl.sameValueAs(this, other);
    }

    private static boolean sameValueAs(LiteralLabel lit1, LiteralLabel lit2) {
        if (lit1 == null) {
            throw new NullPointerException();
        }
        if (lit2 == null) {
            throw new NullPointerException();
        }
        if (LiteralLabelImpl.isStringValue(lit1) && LiteralLabelImpl.isStringValue(lit2)) {
            if (JenaParameters.enablePlainLiteralSameAsString) {
                return lit1.getLexicalForm().equals(lit2.getLexicalForm());
            }
            return lit1.getLexicalForm().equals(lit2.getLexicalForm()) && Objects.equals(lit1.getDatatype(), lit2.getDatatype());
        }
        if (LiteralLabelImpl.isStringValue(lit1)) {
            return false;
        }
        if (LiteralLabelImpl.isStringValue(lit2)) {
            return false;
        }
        if (LiteralLabelImpl.isLangString(lit1) && LiteralLabelImpl.isLangString(lit2)) {
            String lex2;
            String lex1 = lit1.getLexicalForm();
            return lex1.equals(lex2 = lit2.getLexicalForm()) && lit1.language().equalsIgnoreCase(lit2.language());
        }
        if (LiteralLabelImpl.isLangString(lit1)) {
            return false;
        }
        if (LiteralLabelImpl.isLangString(lit2)) {
            return false;
        }
        if (lit1.isWellFormedRaw() && lit2.isWellFormedRaw()) {
            return lit1.getDatatype().isEqual(lit1, lit2);
        }
        if (!lit1.isWellFormedRaw() && !lit2.isWellFormedRaw()) {
            return lit1.equals(lit2);
        }
        return false;
    }

    private static boolean isStringValue(LiteralLabel lit) {
        if (lit.getDatatype() == null) {
            return !LiteralLabelImpl.isLangString(lit);
        }
        return lit.getDatatype().equals(XSDDatatype.XSDstring);
    }

    public static boolean isLangString(LiteralLabel lit) {
        String lang = lit.language();
        if (lang == null) {
            return false;
        }
        if (lang.equals("")) {
            return false;
        }
        if (JenaRuntime.isRDF11 && !Objects.equals(lit.getDatatype(), RDF.dtLangString)) {
            throw new JenaException("Literal with language string which is not rdf:langString: " + lit);
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.dtype == null ? this.getDefaultHashcode() : this.dtype.getHashCode(this);
        }
        return this.hash;
    }

    @Override
    public int getDefaultHashcode() {
        return (this.wellformed ? this.value : this.getLexicalForm()).hashCode();
    }
}

