/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

public final class BitsLong {
    private static int LongLen = 64;

    private BitsLong() {
    }

    public static final long unpack(long bits, int start, int finish) {
        BitsLong.check(start, finish);
        if (finish == 0) {
            return 0L;
        }
        return bits << LongLen - finish >>> LongLen - finish + start;
    }

    public static final long pack(long bits, long value, int start, int finish) {
        BitsLong.check(start, finish);
        bits = BitsLong.clear$(bits, start, finish);
        long mask = BitsLong.mask(start, finish);
        return bits |= value << start & mask;
    }

    public static final long unpack(String str2, int startChar, int finishChar) {
        String s2 = str2.substring(startChar, finishChar);
        return Long.parseLong(s2, 16);
    }

    public static final long set(long bits, int bitIndex) {
        BitsLong.check(bitIndex);
        return BitsLong.set$(bits, bitIndex);
    }

    public static final long set(long bits, int start, int finish) {
        BitsLong.check(start, finish);
        return BitsLong.set$(bits, start, finish);
    }

    public static final boolean test(long bits, boolean isSet, int bitIndex) {
        BitsLong.check(bitIndex);
        return BitsLong.test$(bits, isSet, bitIndex);
    }

    public static final boolean isSet(long bits, int bitIndex) {
        BitsLong.check(bitIndex);
        return BitsLong.test$(bits, true, bitIndex);
    }

    public static final boolean test(long bits, long value, int start, int finish) {
        BitsLong.check(start, finish);
        return BitsLong.test$(bits, value, start, finish);
    }

    public static final long access(long bits, int start, int finish) {
        BitsLong.check(start, finish);
        return BitsLong.access$(bits, start, finish);
    }

    public static final long clear(long bits, int start, int finish) {
        BitsLong.check(start, finish);
        return BitsLong.clear$(bits, start, finish);
    }

    public static final long mask(int start, int finish) {
        BitsLong.check(start, finish);
        return BitsLong.mask$(start, finish);
    }

    public static final long maskZero(int start, int finish) {
        BitsLong.check(start, finish);
        return BitsLong.maskZero$(start, finish);
    }

    private static final long clear$(long bits, int start, int finish) {
        long mask = BitsLong.maskZero$(start, finish);
        return bits &= mask;
    }

    private static final long set$(long bits, int bitIndex) {
        long mask = BitsLong.mask$(bitIndex);
        return bits | mask;
    }

    private static final long set$(long bits, int start, int finish) {
        long mask = BitsLong.mask$(start, finish);
        return bits | mask;
    }

    private static boolean test$(long bits, boolean isSet, int bitIndex) {
        return isSet == BitsLong.access$(bits, bitIndex);
    }

    private static boolean test$(long bits, long value, int start, int finish) {
        long v = BitsLong.access$(bits, start, finish);
        return v == value;
    }

    private static final boolean access$(long bits, int bitIndex) {
        long mask = BitsLong.mask$(bitIndex);
        return (bits & mask) != 0L;
    }

    private static final long access$(long bits, int start, int finish) {
        return bits << LongLen - finish >>> LongLen - finish + start << start;
    }

    private static final long mask$(int bitIndex) {
        return 1L << bitIndex;
    }

    private static final long mask$(int start, int finish) {
        if (finish == 0) {
            return 0L;
        }
        long mask = -1L;
        return mask << LongLen - finish >>> LongLen - finish + start << start;
    }

    private static final long maskZero$(int start, int finish) {
        return BitsLong.mask$(start, finish) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static final void check(long bitIndex) {
        if (bitIndex < 0L || bitIndex >= (long)LongLen) {
            throw new IllegalArgumentException("Illegal bit index: " + bitIndex);
        }
    }

    private static final void check(long start, long finish) {
        if (start < 0L || start >= (long)LongLen) {
            throw new IllegalArgumentException("Illegal start: " + start);
        }
        if (finish < 0L || finish > (long)LongLen) {
            throw new IllegalArgumentException("Illegal finish: " + finish);
        }
        if (start > finish) {
            throw new IllegalArgumentException("Illegal range: (" + start + ", " + finish + ")");
        }
    }
}

