/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.util.Arrays;
import java.util.Comparator;

public final class AbortableComparator<E>
implements Comparator<E> {
    protected volatile boolean cancelled;
    final Comparator<? super E> baseComparator;

    public AbortableComparator(Comparator<? super E> comparator) {
        this.baseComparator = comparator;
    }

    @Override
    public int compare(E o1, E o2) {
        if (this.cancelled) {
            throw new AbandonSort();
        }
        return this.baseComparator.compare(o1, o2);
    }

    public Finish abortableSort(E[] e2) {
        try {
            Arrays.sort(e2, this);
        }
        catch (AbandonSort s2) {
            return Finish.ABORTED;
        }
        return Finish.COMPLETED;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public static enum Finish {
        COMPLETED,
        ABORTED;

    }

    public static class AbandonSort
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

