/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.assembler.AssemblerHelp;
import org.apache.jena.assembler.BadObjectException;
import org.apache.jena.assembler.JA;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.FileManager;
import org.apache.jena.vocabulary.OWL;

public class ImportManager {
    public static final ImportManager instance = new ImportManager();
    protected Map<String, Graph> cache = new HashMap<String, Graph>();

    public void clear() {
        this.cache.clear();
    }

    public Model withImports(Model model) {
        return this.withImports(FileManager.get(), model);
    }

    public Model withImports(FileManager fm, Model model) {
        return this.withImports(fm, model, new HashSet<String>());
    }

    private Model withImports(FileManager fm, Model model, Set<String> loading) {
        StmtIterator oit = model.listStatements(null, OWL.imports, (RDFNode)null);
        StmtIterator jit = model.listStatements(null, JA.imports, (RDFNode)null);
        if (oit.hasNext() || jit.hasNext()) {
            MultiUnion g2 = new MultiUnion(new Graph[]{model.getGraph()});
            this.addImportedGraphs(fm, loading, oit, g2);
            this.addImportedGraphs(fm, loading, jit, g2);
            return ModelFactory.createModelForGraph(g2);
        }
        return model;
    }

    private void addImportedGraphs(FileManager fm, Set<String> loading, StmtIterator oit, MultiUnion g2) {
        while (oit.hasNext()) {
            String path = this.getObjectURI(oit.nextStatement());
            if (!loading.add(path)) continue;
            g2.addGraph(this.graphFor(fm, loading, path));
        }
    }

    private String getObjectURI(Statement s2) {
        RDFNode ob = s2.getObject();
        if (ob.isLiteral()) {
            return AssemblerHelp.getString(s2);
        }
        if (ob.isAnon()) {
            throw new BadObjectException(s2);
        }
        return ((Resource)ob).getURI();
    }

    protected Graph graphFor(FileManager fm, Set<String> loading, String path) {
        Graph already = this.cache.get(path);
        if (already == null) {
            Graph result = this.withImports(fm, fm.loadModel(path), loading).getGraph();
            this.cache.put(path, result);
            return result;
        }
        return already;
    }
}

