/*
 * Decompiled with CFR 0.152.
 */
package de.wwu.music2rdf.util;

import de.wwu.music2rdf.core.Instrument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Util {
    public static String timeElapsed(Date startDate, Date endDate) {
        long different = endDate.getTime() - startDate.getTime();
        long secondsInMilli = 1000L;
        long minutesInMilli = secondsInMilli * 60L;
        long hoursInMilli = minutesInMilli * 60L;
        long daysInMilli = hoursInMilli * 24L;
        long elapsedDays = different / daysInMilli;
        long elapsedHours = (different %= daysInMilli) / hoursInMilli;
        long elapsedMinutes = (different %= hoursInMilli) / minutesInMilli;
        long elapsedSeconds = (different %= minutesInMilli) / secondsInMilli;
        long elapsedMilliseconds = different % secondsInMilli;
        String result = "";
        if (elapsedDays == 0L && elapsedHours != 0L) {
            result = elapsedHours + " hours, " + elapsedMinutes + " minutes, " + elapsedSeconds + "." + elapsedMilliseconds + " seconds";
        } else if (elapsedHours == 0L && elapsedMinutes != 0L) {
            result = elapsedMinutes + " minutes, " + elapsedSeconds + "." + elapsedMilliseconds + " seconds";
        } else if (elapsedMinutes == 0L && elapsedSeconds != 0L) {
            result = elapsedSeconds + "." + elapsedMilliseconds + " seconds";
        } else if (elapsedSeconds == 0L) {
            result = elapsedMilliseconds + " ms";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Instrument> getInstruments() {
        ArrayList<Instrument> result = new ArrayList<Instrument>();
        BufferedReader br = null;
        String line = "";
        String cvsSplitBy = ",";
        try {
            InputStream in = this.getClass().getResourceAsStream("/config/mediums_musicxml.csv");
            br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                Instrument instrument = new Instrument();
                String[] medium = line.split(cvsSplitBy);
                instrument.setPerformanceMediumId(medium[0]);
                instrument.setPerformanceMediumTypeId(medium[1]);
                instrument.setPerformanceMediumDescription(medium[2]);
                result.add(instrument);
            }
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
        return result;
    }

    public static File decompressMXL(String mxlFile, String outputFolder) {
        byte[] buffer = new byte[1024];
        File newFile = new File("");
        try {
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(mxlFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                if (fileName.toLowerCase().contains(".xml")) {
                    int len;
                    newFile = new File(outputFolder + File.separator + new File(mxlFile).getName().replace(".mxl", ".xml"));
                    new File(newFile.getParent()).mkdirs();
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return newFile;
    }
}

