/*
 * Decompiled with CFR 0.152.
 */
package de.wwu.music2rdf.converter;

import com.google.common.net.MediaType;
import de.wwu.music2rdf.core.Clef;
import de.wwu.music2rdf.core.Collection;
import de.wwu.music2rdf.core.Instrument;
import de.wwu.music2rdf.core.Key;
import de.wwu.music2rdf.core.Measure;
import de.wwu.music2rdf.core.Movement;
import de.wwu.music2rdf.core.MusicScore;
import de.wwu.music2rdf.core.Note;
import de.wwu.music2rdf.core.Person;
import de.wwu.music2rdf.core.ScorePart;
import de.wwu.music2rdf.core.ScoreResource;
import de.wwu.music2rdf.core.Staff;
import de.wwu.music2rdf.core.Voice;
import de.wwu.music2rdf.util.Util;
import de.wwu.music2rdf.vocabulary.Chord;
import de.wwu.music2rdf.vocabulary.DBpediaOntology;
import de.wwu.music2rdf.vocabulary.DBpediaResource;
import de.wwu.music2rdf.vocabulary.GND;
import de.wwu.music2rdf.vocabulary.InstrumentTaxonomy;
import de.wwu.music2rdf.vocabulary.MusicOWL;
import de.wwu.music2rdf.vocabulary.MusicOntology;
import de.wwu.music2rdf.vocabulary.ProvO;
import de.wwu.music2rdf.vocabulary.Tonality;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import org.apache.log4j.Logger;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MusicXML2RDF {
    private ArrayList<Clef> clefList;
    private ArrayList<Note> currentNotes;
    private ArrayList<Instrument> instruments = new Util().getInstruments();
    private ArrayList<Person> persons;
    private boolean verbose = false;
    private String outputFile = "";
    private File inputFile = null;
    private String scoreURI = "";
    private String documentTitle = "";
    private String thumbnail = "";
    private String outputFormat = "TURTLE";
    private Collection collection;
    private static Logger logger = Logger.getLogger("Converter");
    private String dateIssued = "";
    private ArrayList<Note> accidentalsOverwrite = new ArrayList();
    private ArrayList<ScoreResource> resources;

    public MusicXML2RDF() {
        this.clefList = new ArrayList();
        this.currentNotes = new ArrayList();
        this.persons = new ArrayList();
        this.resources = new ArrayList();
        this.collection = new Collection();
    }

    public void addPerson(Person person) {
        this.persons.add(person);
    }

    public void addCollection(Collection collection) {
        this.collection.setCollectionURI(collection.getCollectionURI());
        this.collection.setCollectionName(collection.getCollectionName());
    }

    public void isVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private String getAccidental(Key key, Note note) {
        ArrayList<Note> measureAccidentals = new ArrayList<Note>();
        if (key.getTonic().equals("G") && key.getMode().equals("major") || key.getTonic().equals("E") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("F", "sharp"));
        }
        if (key.getTonic().equals("D") && key.getMode().equals("major") || key.getTonic().equals("B") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("F", "sharp"));
            measureAccidentals.add(new Note("C", "sharp"));
        }
        if (key.getTonic().equals("A") && key.getMode().equals("major") || key.getTonic().equals("F") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("F", "sharp"));
            measureAccidentals.add(new Note("C", "sharp"));
            measureAccidentals.add(new Note("G", "sharp"));
        }
        if (key.getTonic().equals("E") && key.getMode().equals("major") || key.getTonic().equals("C") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("F", "sharp"));
            measureAccidentals.add(new Note("C", "sharp"));
            measureAccidentals.add(new Note("G", "sharp"));
            measureAccidentals.add(new Note("D", "sharp"));
        }
        if (key.getTonic().equals("B") && key.getMode().equals("major") || key.getTonic().equals("G") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("F", "sharp"));
            measureAccidentals.add(new Note("C", "sharp"));
            measureAccidentals.add(new Note("G", "sharp"));
            measureAccidentals.add(new Note("D", "sharp"));
            measureAccidentals.add(new Note("A", "sharp"));
        }
        if (key.getTonic().equals("Fs") && key.getMode().equals("major") || key.getTonic().equals("Ds") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("F", "sharp"));
            measureAccidentals.add(new Note("C", "sharp"));
            measureAccidentals.add(new Note("G", "sharp"));
            measureAccidentals.add(new Note("D", "sharp"));
            measureAccidentals.add(new Note("A", "sharp"));
            measureAccidentals.add(new Note("E", "sharp"));
        }
        if (key.getTonic().equals("Cs") && key.getMode().equals("major") || key.getTonic().equals("As") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("F", "sharp"));
            measureAccidentals.add(new Note("C", "sharp"));
            measureAccidentals.add(new Note("G", "sharp"));
            measureAccidentals.add(new Note("D", "sharp"));
            measureAccidentals.add(new Note("A", "sharp"));
            measureAccidentals.add(new Note("E", "sharp"));
            measureAccidentals.add(new Note("B", "sharp"));
        }
        if (key.getTonic().equals("F") && key.getMode().equals("major") || key.getTonic().equals("D") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("B", "flat"));
        }
        if (key.getTonic().equals("Bb") && key.getMode().equals("major") || key.getTonic().equals("G") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("B", "flat"));
            measureAccidentals.add(new Note("E", "flat"));
        }
        if (key.getTonic().equals("Eb") && key.getMode().equals("major") || key.getTonic().equals("C") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("B", "flat"));
            measureAccidentals.add(new Note("E", "flat"));
            measureAccidentals.add(new Note("A", "flat"));
        }
        if (key.getTonic().equals("Ab") && key.getMode().equals("major") || key.getTonic().equals("F") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("B", "flat"));
            measureAccidentals.add(new Note("E", "flat"));
            measureAccidentals.add(new Note("A", "flat"));
            measureAccidentals.add(new Note("D", "flat"));
        }
        if (key.getTonic().equals("Db") && key.getMode().equals("major") || key.getTonic().equals("Bb") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("B", "flat"));
            measureAccidentals.add(new Note("E", "flat"));
            measureAccidentals.add(new Note("A", "flat"));
            measureAccidentals.add(new Note("D", "flat"));
            measureAccidentals.add(new Note("G", "flat"));
        }
        if (key.getTonic().equals("Gb") && key.getMode().equals("major") || key.getTonic().equals("Eb") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("B", "flat"));
            measureAccidentals.add(new Note("E", "flat"));
            measureAccidentals.add(new Note("A", "flat"));
            measureAccidentals.add(new Note("D", "flat"));
            measureAccidentals.add(new Note("G", "flat"));
            measureAccidentals.add(new Note("C", "flat"));
        }
        if (key.getTonic().equals("Cb") && key.getMode().equals("major") || key.getTonic().equals("Ab") && key.getMode().equals("minor")) {
            measureAccidentals.add(new Note("B", "flat"));
            measureAccidentals.add(new Note("E", "flat"));
            measureAccidentals.add(new Note("A", "flat"));
            measureAccidentals.add(new Note("D", "flat"));
            measureAccidentals.add(new Note("G", "flat"));
            measureAccidentals.add(new Note("C", "flat"));
            measureAccidentals.add(new Note("F", "flat"));
        }
        for (int i = 0; i < this.accidentalsOverwrite.size(); ++i) {
            boolean accidentalOverwritten = false;
            for (int j = 0; j < measureAccidentals.size(); ++j) {
                if (!((Note)measureAccidentals.get(j)).getPitch().equals(this.accidentalsOverwrite.get(i).getPitch())) continue;
                ((Note)measureAccidentals.get(j)).setAccidental(this.accidentalsOverwrite.get(i).getAccidental());
                accidentalOverwritten = true;
            }
            if (accidentalOverwritten) continue;
            measureAccidentals.add(this.accidentalsOverwrite.get(i));
        }
        Iterator it = measureAccidentals.iterator();
        while (it.hasNext()) {
            Note n = (Note)it.next();
            if (!n.getAccidental().equals("natural")) continue;
            it.remove();
        }
        for (int i = 0; i < measureAccidentals.size(); ++i) {
            if (!((Note)measureAccidentals.get(i)).getPitch().equals(note.getPitch())) continue;
            note.setAccidental(((Note)measureAccidentals.get(i)).getAccidental());
        }
        return note.getAccidental();
    }

    private void updateAccidentalsList(Note note) {
        boolean accidentalExists = false;
        for (int i = 0; i < this.accidentalsOverwrite.size(); ++i) {
            if (!this.accidentalsOverwrite.get(i).getPitch().equals(note.getPitch())) continue;
            this.accidentalsOverwrite.get(i).setAccidental(note.getAccidental());
            accidentalExists = true;
        }
        if (!accidentalExists) {
            this.accidentalsOverwrite.add(note);
        }
    }

    private void createRDF(MusicScore score) {
        Resource resCollection;
        String uid = UUID.randomUUID().toString();
        String nodeBaseURI = "http://linkeddata.uni-muenster.de/node/" + uid + "_";
        Model model = ModelFactory.createDefaultModel();
        Resource resScore = model.createResource(score.getURI());
        model.setNsPrefixes(PrefixMapping.Standard);
        model.setNsPrefix("mso", "http://linkeddata.uni-muenster.de/ontology/musicscore#");
        model.setNsPrefix("chord", "http://purl.org/ontology/chord/");
        model.setNsPrefix("foaf", "http://xmlns.com/foaf/0.1/");
        model.setNsPrefix("mo", "http://purl.org/ontology/mo/");
        model.setNsPrefix("note", "http://purl.org/ontology/chord/note/");
        model.setNsPrefix("ton", "http://purl.org/ontology/tonality/");
        model.setNsPrefix("mode", "http://purl.org/ontology/tonality/mode/");
        model.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        model.setNsPrefix("dbpedia", "http://dbpedia.org/resource/");
        model.setNsPrefix("dbo", "http://dbpedia.org/property/");
        model.setNsPrefix("node", "http://linkeddata.uni-muenster.de/node/");
        model.setNsPrefix("dc-terms", "http://purl.org/dc/terms/");
        model.setNsPrefix("gndo", "http://d-nb.info/standards/elementset/gnd#");
        model.setNsPrefix("skos", "http://www.w3.org/2004/02/skos/core#");
        model.setNsPrefix("mit", "http://purl.org/ontology/mo/mit#");
        model.add(model.createStatement(resScore, RDF.type, MusicOntology.Score));
        for (int i = 0; i < this.resources.size(); ++i) {
            if (this.resources.get(i).getUrl() == null) continue;
            Resource resResource = model.createResource(nodeBaseURI + "DOC_" + i);
            model.add(model.createLiteralStatement(resResource, DBpediaOntology.url, this.resources.get(i).getUrl()));
            model.add(model.createStatement(resResource, RDF.type, DBpediaResource.Document));
            model.add(model.createStatement(resScore, DBpediaOntology.document, resResource));
            if (this.resources.get(i).getDescription().equals("")) {
                model.add(model.createLiteralStatement(resResource, RDFS.label, this.resources.get(i).getUrl()));
            } else {
                model.add(model.createLiteralStatement(resResource, RDFS.label, this.resources.get(i).getDescription()));
            }
            if (!this.resources.get(i).getType().equals("")) {
                model.add(model.createLiteralStatement(resResource, DBpediaOntology.mime, this.resources.get(i).getType()));
                continue;
            }
            model.add(model.createLiteralStatement(resResource, DBpediaOntology.mime, MediaType.ANY_TYPE.toString()));
        }
        if (this.collection.getCollectionURI() == null) {
            logger.warn("No collection provided for [" + score.getURI() + "]");
            resCollection = model.createResource("http://unknown.collection.wmss");
            model.add(model.createStatement(resCollection, ProvO.hadMember, resScore));
            model.add(model.createStatement(resCollection, RDF.type, ProvO.Collection));
            model.add(model.createLiteralStatement(resCollection, RDFS.label, "Unknown Collection"));
        } else {
            resCollection = model.createResource(this.collection.getCollectionURI());
            model.add(model.createStatement(resCollection, ProvO.hadMember, resScore));
            model.add(model.createStatement(resCollection, RDF.type, ProvO.Collection));
            model.add(model.createLiteralStatement(resCollection, RDFS.label, this.collection.getCollectionName()));
        }
        if (!this.getDateIssued().equals("")) {
            Literal issuedLiteral = model.createTypedLiteral(this.getDateIssued().replaceAll("[^\\d]", ""), (RDFDatatype)XSDDatatype.XSDdate);
            model.add(model.createLiteralStatement(resScore, DCTerms.issued, issuedLiteral));
        }
        if (this.thumbnail.equals("")) {
            logger.warn("No thumbnail provided for [" + score.getURI() + "]");
            model.add(model.createStatement(resScore, FOAF.thumbnail, model.createResource("<https://www.ulb.uni-muenster.de/imperia/md/images/ulb2/bilder/medien/telemann-noten_730x365.jpg>")));
        } else {
            model.add(model.createStatement(resScore, FOAF.thumbnail, model.createResource(this.thumbnail)));
        }
        Resource resEconder = model.createResource("https://github.com/jimjonesbr/musicowl");
        model.add(model.createStatement(resScore, ProvO.wasGeneratedBy, resEconder));
        model.add(model.createLiteralStatement(resEconder, RDFS.label, "MusicXML to RDF Converter"));
        Resource resActivity = model.createResource(score.getURI() + "_musicxml2rdf");
        if (this.persons.size() == 0) {
            logger.warn("No person provided (composer, encoder, etc.) for [" + score.getURI() + "].");
            this.persons.add(new Person("http://unknown.person.wmss", "Unknown", "Unknown"));
        }
        boolean hasEncoder = false;
        boolean hasComposer = false;
        for (int i = 0; i < this.persons.size(); ++i) {
            if (this.persons.get(i).getUri() == null) {
                logger.warn("No URI provided for [" + score.getURI() + "].");
                this.persons.get(i).setUri("http://unknown.person.wmss/" + UUID.randomUUID());
            }
            if (this.persons.get(i).getName() == null) {
                logger.warn("No name provided for [" + score.getURI() + "].");
                this.persons.get(i).setName("Unknown");
            }
            if (this.persons.get(i).getRole() == null) {
                logger.warn("No role provided for [" + score.getURI() + "].");
                this.persons.get(i).setUri("Unknown");
            }
            Resource resPerson = model.createResource(this.persons.get(i).getUri());
            if (this.persons.get(i).getRole().equals("Composer")) {
                hasComposer = true;
                model.add(model.createStatement(resScore, DC.creator, resPerson));
                model.add(model.createLiteralStatement(resScore, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, GND.Composer));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, GND.Composer));
                model.add(model.createStatement(GND.Composer, RDF.type, ProvO.Role));
                model.add(model.createLiteralStatement(GND.Composer, GND.preferredNameForTheSubjectHeading, "Composer"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Composer));
                model.add(model.createStatement(DBpediaResource.Composer, RDFS.label, "Composer"));
            }
            if (this.persons.get(i).getRole().equals("Encoder")) {
                hasEncoder = true;
                model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
                model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
                model.add(model.createStatement(resActivity, ProvO.generated, resScore));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, GND.Encoder));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, GND.Encoder));
                model.add(model.createStatement(GND.Encoder, RDF.type, ProvO.Role));
                model.add(model.createLiteralStatement(GND.Encoder, GND.preferredNameForTheSubjectHeading, "Encoder"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Encoder));
                model.add(model.createStatement(DBpediaResource.Encoder, RDFS.label, "Encoder"));
            }
            if (this.persons.get(i).getRole().equals("Lyricist")) {
                model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
                model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
                model.add(model.createStatement(resActivity, ProvO.generated, resScore));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, GND.Lyricist));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, GND.Lyricist));
                model.add(model.createStatement(GND.Lyricist, RDF.type, ProvO.Role));
                model.add(model.createLiteralStatement(GND.Lyricist, GND.preferredNameForTheSubjectHeading, "Lyricist"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Lyricist));
                model.add(model.createStatement(DBpediaResource.Lyricist, RDFS.label, "Lyricist"));
            }
            if (this.persons.get(i).getRole().equals("Arranger")) {
                model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
                model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
                model.add(model.createStatement(resActivity, ProvO.generated, resScore));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, GND.Arranger));
                model.add(model.createStatement(GND.Arranger, RDF.type, ProvO.Role));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, GND.Arranger));
                model.add(model.createLiteralStatement(GND.Arranger, GND.preferredNameForTheSubjectHeading, "Arranger"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Arranger));
                model.add(model.createStatement(DBpediaResource.Arranger, RDFS.label, "Arranger"));
            }
            if (this.persons.get(i).getRole().equals("Librettist")) {
                model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
                model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
                model.add(model.createStatement(resActivity, ProvO.generated, resScore));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, GND.Librettist));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, GND.Librettist));
                model.add(model.createStatement(GND.Librettist, RDF.type, ProvO.Role));
                model.add(model.createLiteralStatement(GND.Librettist, GND.preferredNameForTheSubjectHeading, "Librettist"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Librettist));
                model.add(model.createStatement(DBpediaResource.Librettist, RDFS.label, "Librettist"));
            }
            if (this.persons.get(i).getRole().equals("Editor")) {
                model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
                model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
                model.add(model.createStatement(resActivity, ProvO.generated, resScore));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, GND.Editor));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, GND.Editor));
                model.add(model.createStatement(GND.Editor, RDF.type, ProvO.Role));
                model.add(model.createLiteralStatement(GND.Editor, GND.preferredNameForTheSubjectHeading, "Editor"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Editor));
                model.add(model.createStatement(DBpediaResource.Editor, RDFS.label, "Editor"));
            }
            if (this.persons.get(i).getRole().equals("Performer")) {
                model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
                model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
                model.add(model.createStatement(resActivity, ProvO.generated, resScore));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, GND.Performer));
                model.add(model.createStatement(GND.Performer, RDF.type, ProvO.Role));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, GND.Performer));
                model.add(model.createLiteralStatement(GND.Performer, GND.preferredNameForTheSubjectHeading, "Performer"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Performer));
                model.add(model.createStatement(DBpediaResource.Performer, RDFS.label, "Performer"));
            }
            if (this.persons.get(i).getRole().equals("Translator")) {
                model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
                model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
                model.add(model.createStatement(resActivity, ProvO.generated, resScore));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, GND.Translator));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, GND.Translator));
                model.add(model.createStatement(GND.Translator, RDF.type, ProvO.Role));
                model.add(model.createLiteralStatement(GND.Translator, GND.preferredNameForTheSubjectHeading, "Translator"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Translator));
                model.add(model.createStatement(DBpediaResource.Translator, RDFS.label, "Translator"));
            }
            if (this.persons.get(i).getRole().equals("Dedicatee")) {
                model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
                model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
                model.add(model.createStatement(resActivity, ProvO.generated, resScore));
                model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
                model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
                model.add(model.createStatement(resPerson, ProvO.hadRole, DBpediaResource.Dedicatee));
                model.add(model.createStatement(resPerson, GND.professionOrOccupation, DBpediaResource.Dedicatee));
                model.add(model.createStatement(DBpediaResource.Dedicatee, RDF.type, ProvO.Role));
                model.add(model.createLiteralStatement(DBpediaResource.Dedicatee, GND.preferredNameForTheSubjectHeading, "Dedicatee"));
                model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Dedicatee));
                model.add(model.createStatement(DBpediaResource.Encoder, RDFS.label, "Dedicatee"));
            }
            if (!this.persons.get(i).getRole().equals("Unknown")) continue;
            model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resPerson));
            model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
            model.add(model.createStatement(resActivity, ProvO.generated, resScore));
            model.add(model.createStatement(resPerson, RDF.type, FOAF.Person));
            model.add(model.createLiteralStatement(resPerson, FOAF.name, this.persons.get(i).getName().replace("\"", "\\\"")));
            model.add(model.createStatement(resPerson, ProvO.hadRole, DBpediaResource.Unknown));
            model.add(model.createStatement(resPerson, GND.professionOrOccupation, DBpediaResource.Unknown));
            model.add(model.createStatement(DBpediaResource.Unknown, RDF.type, ProvO.Role));
            model.add(model.createLiteralStatement(DBpediaResource.Unknown, GND.preferredNameForTheSubjectHeading, "Unknown"));
            model.add(model.createStatement(resPerson, DBpediaOntology.occupation, DBpediaResource.Unknown));
            model.add(model.createStatement(DBpediaResource.Encoder, RDFS.label, "Unknown"));
        }
        if (!hasEncoder) {
            Resource resUnknownPerson = model.createResource("http://wmss.unknown.encoder");
            model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resUnknownPerson));
            model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
            model.add(model.createStatement(resActivity, ProvO.generated, resScore));
            model.add(model.createStatement(resUnknownPerson, RDF.type, FOAF.Person));
            model.add(model.createLiteralStatement(resUnknownPerson, FOAF.name, "Unknown Encoder"));
            model.add(model.createStatement(resUnknownPerson, ProvO.hadRole, GND.Composer));
            model.add(model.createStatement(GND.Encoder, RDF.type, ProvO.Role));
            model.add(model.createLiteralStatement(GND.Encoder, GND.preferredNameForTheSubjectHeading, "Encoder"));
            model.add(model.createStatement(resUnknownPerson, DBpediaOntology.occupation, DBpediaResource.Encoder));
            model.add(model.createStatement(DBpediaResource.Encoder, RDFS.label, "Encoder"));
        }
        if (!hasComposer) {
            Resource resUnknownPerson = model.createResource("http://wmss.unknown.composer");
            model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resUnknownPerson));
            model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
            model.add(model.createStatement(resActivity, ProvO.generated, resScore));
            model.add(model.createStatement(resUnknownPerson, RDF.type, FOAF.Person));
            model.add(model.createLiteralStatement(resUnknownPerson, FOAF.name, "Unknown Composer"));
            model.add(model.createStatement(resUnknownPerson, ProvO.hadRole, GND.Composer));
            model.add(model.createStatement(GND.Composer, RDF.type, ProvO.Role));
            model.add(model.createLiteralStatement(GND.Composer, GND.preferredNameForTheSubjectHeading, "Composer"));
            model.add(model.createStatement(resUnknownPerson, DBpediaOntology.occupation, DBpediaResource.Composer));
            model.add(model.createStatement(DBpediaResource.Composer, RDFS.label, "Composer"));
        }
        if (score.getURI().equals("")) {
            score.setURI("http://wmss.undefined.score/" + UUID.randomUUID().toString());
            logger.warn("No URI provided for the current score: " + score.getTitle());
        }
        if (score.getTitle().equals("")) {
            score.setTitle("Unknown Music Score Tile");
            logger.warn("No title provided for the current score: " + score.getURI());
        }
        ArrayList<Staff> staves = new ArrayList<Staff>();
        ArrayList<Voice> voices = new ArrayList<Voice>();
        ArrayList<String> notesets = new ArrayList<String>();
        ArrayList<Movement> movements = new ArrayList<Movement>();
        if (!score.getTitle().equals("") && score.getTitle() != null) {
            model.add(model.createLiteralStatement(resScore, DC.title, score.getTitle().trim().replace("\"", "\\\"")));
        }
        Resource resSoftwareAgent = model.createResource("https://github.com/jimjonesbr/musicowl");
        model.add(model.createStatement(resSoftwareAgent, RDF.type, ProvO.SoftwareAgent));
        model.add(model.createLiteralStatement(resSoftwareAgent, DBpediaOntology.version, this.getVersion()));
        model.add(model.createLiteralStatement(resSoftwareAgent, FOAF.name, "MusicXML2RDF Converter"));
        model.add(model.createStatement(resActivity, RDF.type, ProvO.Activity));
        model.add(model.createLiteralStatement(resActivity, RDFS.comment, "File convertion from MusicXML to RDF based on the MusicOWL Ontology."));
        Literal literalStasrted = model.createTypedLiteral(score.getEncodingStartTime().trim(), (RDFDatatype)XSDDatatype.XSDdateTime);
        model.add(model.createLiteralStatement(resActivity, ProvO.startedAtTime, literalStasrted));
        model.add(model.createStatement(resActivity, ProvO.wasAssociatedWith, resSoftwareAgent));
        model.add(model.createStatement(resScore, ProvO.wasGeneratedBy, resActivity));
        for (int i = 0; i < score.getParts().size(); ++i) {
            String partID = score.getParts().get(i).getId();
            int notesetCounter = 0;
            int movementCounter = 0;
            Resource resPart = null;
            for (int j = 0; j < score.getParts().get(i).getMeasures().size(); ++j) {
                if (score.getParts().get(i).getMeasures().get(j).getId().equals("1") || score.getParts().get(i).getMeasures().get(j).getId().equals("0")) {
                    resPart = model.createResource(nodeBaseURI + "MOV" + ++movementCounter + "_PART_" + partID);
                    model.add(model.createLiteralStatement(resPart, RDFS.label, partID));
                    Resource resMovement = model.createResource(nodeBaseURI + "MOV" + movementCounter);
                    model.add(model.createStatement(resScore, MusicOntology.movement, resMovement));
                    model.add(model.createStatement(resMovement, RDF.type, MusicOntology.Movement));
                    model.add(model.createLiteralStatement(resMovement, DBpediaOntology.order, movementCounter));
                    if (!score.getParts().get(i).getMeasures().get(j).getBeatUnit().equals("")) {
                        String beatUnit = this.getCapital(score.getParts().get(i).getMeasures().get(j).getBeatUnit());
                        model.add(model.createStatement(resMovement, MusicOWL.hasBeatUnit, model.createResource("http://linkeddata.uni-muenster.de/ontology/musicscore#" + beatUnit)));
                    }
                    if (score.getParts().get(i).getMeasures().get(j).getBeatsPerMinute() != 0) {
                        model.add(model.createLiteralStatement(resMovement, MusicOWL.hasBeatsPerMinute, score.getParts().get(i).getMeasures().get(j).getBeatsPerMinute()));
                    }
                    boolean addMovement = true;
                    Movement movement = new Movement();
                    movement.setId(movementCounter);
                    movement.setTitle(score.getParts().get(i).getMeasures().get(j).getTitle());
                    for (int k = 0; k < movements.size(); ++k) {
                        if (((Movement)movements.get(k)).getId() != movementCounter) continue;
                        addMovement = false;
                    }
                    if (addMovement) {
                        if (movement.getTitle() == null || movement.getTitle().equals("")) {
                            model.add(model.createLiteralStatement(resMovement, DC.title, "(no title)"));
                        } else {
                            model.add(model.createLiteralStatement(resMovement, DC.title, movement.getTitle().trim().replace("\"", "\\\"")));
                        }
                        movements.add(movement);
                    }
                    model.add(model.createStatement(resMovement, MusicOWL.hasScorePart, resPart));
                    model.add(model.createStatement(resPart, RDF.type, MusicOWL.ScorePart));
                    model.add(model.createStatement(resPart, RDF.type, MusicOntology.Instrument));
                    model.add(model.createStatement(resPart, RDF.type, SKOS.Concept));
                    model.add(model.createLiteralStatement(resPart, DC.description, score.getParts().get(i).getName().trim().replace("\"", "\\\"")));
                    model.add(model.createLiteralStatement(resPart, MusicOWL.isSolo, score.getParts().get(i).isSolo()));
                    model.add(model.createLiteralStatement(resPart, MusicOWL.isEnsemble, score.getParts().get(i).isEnsemble()));
                    if (!score.getParts().get(i).getInstrument().toLowerCase().equals("unknown")) {
                        String[] arrayInstrument = score.getParts().get(i).getInstrument().split(Pattern.quote("."));
                        String instrumentLabel = arrayInstrument[arrayInstrument.length - 1];
                        instrumentLabel = instrumentLabel.substring(0, 1).toUpperCase() + instrumentLabel.substring(1);
                        Instrument instrument = this.getInstrument(score.getParts().get(i).getInstrument());
                        model.add(model.createLiteralStatement(resPart, SKOS.prefLabel, instrument.getPerformanceMediumDescription()));
                        model.add(model.createLiteralStatement(resPart, SKOS.altLabel, instrument.getPerformanceMediumId()));
                        Resource resInstrumentBroader = model.createResource("http://purl.org/ontology/mo/mit#" + instrument.getPerformanceMediumTypeId());
                        model.add(model.createStatement(resPart, SKOS.broader, resInstrumentBroader));
                        model.add(model.createStatement(resInstrumentBroader, InstrumentTaxonomy.inScheme, InstrumentTaxonomy.Musical_instruments));
                        model.add(model.createLiteralStatement(resInstrumentBroader, SKOS.prefLabel, instrument.getPerformanceMediumTypeId()));
                    } else {
                        model.add(model.createLiteralStatement(resPart, SKOS.prefLabel, "unspecified"));
                        model.add(model.createLiteralStatement(resPart, SKOS.altLabel, "unspecidied.unspecified"));
                        Resource resInstrumentBroader = model.createResource("http://purl.org/ontology/mo/mit#unspecified");
                        model.add(model.createStatement(resPart, SKOS.broader, resInstrumentBroader));
                        model.add(model.createStatement(resInstrumentBroader, InstrumentTaxonomy.inScheme, InstrumentTaxonomy.Musical_instruments));
                        model.add(model.createLiteralStatement(resInstrumentBroader, SKOS.prefLabel, "unspecified"));
                    }
                }
                String measureID = score.getParts().get(i).getMeasures().get(j).getId();
                Resource resMeasure = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID);
                this.accidentalsOverwrite.clear();
                Key key = new Key();
                Resource resInstant = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_INSTANT_" + measureID);
                model.add(model.createStatement(resInstant, MusicOWL.hasMeasure, resMeasure));
                model.add(model.createStatement(resInstant, RDF.type, MusicOWL.Instant));
                if (j > 0) {
                    Resource resPreviousMeasure = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + score.getParts().get(i).getMeasures().get(j - 1).getId());
                    model.add(model.createStatement(resPreviousMeasure, MusicOWL.nextMeasure, resMeasure));
                    Resource resPreviousInstant = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_INSTANT_" + score.getParts().get(i).getMeasures().get(j - 1).getId());
                    model.add(model.createStatement(resPreviousInstant, MusicOWL.nextInstant, resInstant));
                }
                model.add(model.createStatement(resPart, MusicOWL.hasMeasure, resMeasure));
                model.add(model.createStatement(resMeasure, RDF.type, MusicOWL.Measure));
                model.add(model.createStatement(resMeasure, DBpediaOntology.order, score.getParts().get(i).getMeasures().get(j).getId()));
                Resource resKey = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_KEY");
                if (score.getParts().get(i).getMeasures().get(j).getKey().getMode() != null) {
                    if (score.getParts().get(i).getMeasures().get(j).getKey().getMode().equals("major")) {
                        key.setMode("major");
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("0")) {
                            key.setTonic("C");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("1")) {
                            key.setTonic("G");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("2")) {
                            key.setTonic("D");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("3")) {
                            key.setTonic("A");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("4")) {
                            key.setTonic("E");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("5")) {
                            key.setTonic("B");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("6")) {
                            key.setTonic("Fs");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("7")) {
                            key.setTonic("Cs");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-1")) {
                            key.setTonic("F");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-2")) {
                            key.setTonic("Bb");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-3")) {
                            key.setTonic("Eb");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-4")) {
                            key.setTonic("Ab");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-5")) {
                            key.setTonic("Db");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-6")) {
                            key.setTonic("Gb");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-7")) {
                            key.setTonic("Cb");
                        }
                    }
                    if (score.getParts().get(i).getMeasures().get(j).getKey().getMode().equals("minor")) {
                        key.setMode("minor");
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("0")) {
                            key.setTonic("A");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("1")) {
                            key.setTonic("E");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("2")) {
                            key.setTonic("B");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("3")) {
                            key.setTonic("Fs");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("4")) {
                            key.setTonic("Cs");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("5")) {
                            key.setTonic("Gs");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("6")) {
                            key.setTonic("Ds");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("7")) {
                            key.setTonic("Ab");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-1")) {
                            key.setTonic("D");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-2")) {
                            key.setTonic("G");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-3")) {
                            key.setTonic("C");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-4")) {
                            key.setTonic("F");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-5")) {
                            key.setTonic("Bb");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-6")) {
                            key.setTonic("Eb");
                        }
                        if (score.getParts().get(i).getMeasures().get(j).getKey().getFifths().equals("-7")) {
                            key.setTonic("Gs");
                        }
                    }
                    if (key.getTonic() == null) {
                        key.setTonic("Unknown");
                    }
                    if (key.getMode() == null) {
                        key.setMode("Unknown");
                    }
                    model.add(model.createStatement(resKey, Tonality.tonic, model.createResource("http://purl.org/ontology/chord/note/" + key.getTonic())));
                    model.add(model.createStatement(resKey, Tonality.mode, model.createResource(Tonality.NAMESPACE_MODE + key.getMode())));
                    model.add(model.createStatement(resKey, RDF.type, Tonality.Key));
                    model.add(model.createStatement(resMeasure, MusicOWL.hasKey, resKey));
                } else {
                    model.add(model.createStatement(resKey, RDF.type, Tonality.Key));
                }
                Resource resTime = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_TIME");
                model.add(model.createStatement(resMeasure, MusicOWL.hasTime, resTime));
                model.add(model.createStatement(resTime, RDF.type, MusicOWL.TimeSignature));
                if (score.getParts().get(i).getMeasures().get(j).getTime().getBeats() == null) {
                    score.getParts().get(i).getMeasures().get(j).getTime().setBeats("0");
                } else if (score.getParts().get(i).getMeasures().get(j).getTime().getBeats().equals("")) {
                    score.getParts().get(i).getMeasures().get(j).getTime().setBeats("0");
                }
                if (score.getParts().get(i).getMeasures().get(j).getTime().getBeatType() == null) {
                    score.getParts().get(i).getMeasures().get(j).getTime().setBeatType("0");
                } else if (score.getParts().get(i).getMeasures().get(j).getTime().getBeatType().equals("")) {
                    score.getParts().get(i).getMeasures().get(j).getTime().setBeatType("0");
                }
                model.add(model.createLiteralStatement(resTime, MusicOWL.hasBeats, Integer.parseInt(score.getParts().get(i).getMeasures().get(j).getTime().getBeats())));
                model.add(model.createLiteralStatement(resTime, MusicOWL.hasBeatType, Integer.parseInt(score.getParts().get(i).getMeasures().get(j).getTime().getBeatType())));
                if (score.getParts().get(i).getMeasures().get(j).getBarline() != null) {
                    Resource resBarline = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_REPEAT");
                    model.add(model.createLiteralStatement(resMeasure, MusicOWL.hasBarline, resBarline));
                    if (score.getParts().get(i).getMeasures().get(j).getBarline().equals("backward") && score.getParts().get(i).getMeasures().get(j).getBarline().equals("forward") && score.getParts().get(i).getMeasures().get(j).getBarline().equals("backward")) {
                        model.add(model.createStatement(resBarline, RDF.type, MusicOWL.EndRepeat));
                    }
                    if (score.getParts().get(i).getMeasures().get(j).getBarline().equals("forward")) {
                        model.add(model.createStatement(resBarline, RDF.type, MusicOWL.BeginRepeat));
                    }
                }
                String notesetObject = "";
                String tmpVoice = "";
                this.accidentalsOverwrite.clear();
                for (int k = 0; k < score.getParts().get(i).getMeasures().get(j).getNotes().size(); ++k) {
                    int l;
                    if (!score.getParts().get(i).getMeasures().get(j).getNotes().get(k).isChord()) {
                        ++notesetCounter;
                    }
                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getStaff() == null) {
                        score.getParts().get(i).getMeasures().get(j).getNotes().get(k).setStaff("1");
                    }
                    notesetObject = nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_ST" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getStaff() + "_V" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getVoice().getId() + "_NOTESET_" + notesetCounter;
                    Resource resNoteset = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_ST" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getStaff() + "_V" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getVoice().getId() + "_NOTESET_" + notesetCounter);
                    score.getParts().get(i).getMeasures().get(j).getNotes().get(k).setSignature(notesetObject);
                    if (this.getPreviousNoteSet(score.getParts().get(i).getMeasures().get(j).getNotes().get(k)).getSignature() != null) {
                        if (!this.getPreviousNoteSet(score.getParts().get(i).getMeasures().get(j).getNotes().get(k)).getSignature().equals(notesetObject)) {
                            Resource resPreivousNoteset = model.createResource(this.getPreviousNoteSet(score.getParts().get(i).getMeasures().get(j).getNotes().get(k)).getSignature().trim().replaceAll("[<>]", ""));
                            model.add(model.createStatement(resPreivousNoteset, MusicOWL.nextNoteSet, resNoteset));
                            this.setCurrentNoteSet(score.getParts().get(i).getMeasures().get(j).getNotes().get(k));
                        }
                    } else {
                        this.setCurrentNoteSet(score.getParts().get(i).getMeasures().get(j).getNotes().get(k));
                    }
                    Staff staff = new Staff();
                    staff.setId(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getStaff());
                    staff.getPart().setId(score.getParts().get(i).getId());
                    staff.getPart().setMovement(movementCounter);
                    boolean addStaff = true;
                    for (int l2 = 0; l2 < staves.size(); ++l2) {
                        if (!((Staff)staves.get(l2)).getId().equals(staff.getId()) || !((Staff)staves.get(l2)).getPart().getId().equals(staff.getPart().getId()) || ((Staff)staves.get(l2)).getPart().getMovement() != staff.getPart().getMovement()) continue;
                        addStaff = false;
                    }
                    Resource resStaff = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_STAFF_" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getStaff());
                    if (addStaff) {
                        staves.add(staff);
                        model.add(model.createStatement(resStaff, RDF.type, MusicOWL.Staff));
                        model.add(model.createStatement(resPart, MusicOWL.hasStaff, resStaff));
                        model.add(model.createStatement(resStaff, RDFS.label, score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getStaff()));
                    }
                    Resource resVoice = null;
                    Resource resClef = null;
                    Resource resDuration = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS" + notesetCounter + "_DURATION");
                    Voice voice = new Voice();
                    voice.getPart().setId(partID);
                    voice.getPart().setMovement(movementCounter);
                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getVoice() == null) {
                        if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).isChord()) {
                            voice.setId(tmpVoice);
                        } else {
                            voice.setId("1");
                        }
                        score.getParts().get(i).getMeasures().get(j).getNotes().get(k).setVoice(voice);
                    } else {
                        resVoice = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_VOICE_" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getVoice().getId());
                        voice.setId(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getVoice().getId());
                        tmpVoice = score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getVoice().getId();
                    }
                    boolean addVoice = true;
                    for (int l3 = 0; l3 < voices.size(); ++l3) {
                        if (!((Voice)voices.get(l3)).getId().equals(voice.getId()) || !((Voice)voices.get(l3)).getPart().getId().equals(voice.getPart().getId()) || ((Voice)voices.get(l3)).getPart().getMovement() != voice.getPart().getMovement()) continue;
                        addVoice = false;
                    }
                    if (addVoice) {
                        voices.add(voice);
                        model.add(model.createLiteralStatement(resVoice, RDFS.label, voice.getId()));
                        model.add(model.createStatement(resVoice, RDF.type, MusicOWL.Voice));
                        model.add(model.createStatement(resStaff, MusicOWL.hasVoice, resVoice));
                    }
                    boolean addNoteSet = true;
                    for (l = 0; l < notesets.size(); ++l) {
                        if (!((String)notesets.get(l)).equals(notesetObject)) continue;
                        addNoteSet = false;
                    }
                    if (addNoteSet) {
                        notesets.add(notesetObject);
                        resClef = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS_" + notesetCounter + "_CLEF");
                        model.add(model.createStatement(resVoice, MusicOWL.hasNoteSet, resNoteset));
                        model.add(model.createStatement(resNoteset, RDF.type, MusicOWL.NoteSet));
                        model.add(model.createStatement(resNoteset, MusicOWL.hasClef, resClef));
                        model.add(model.createStatement(resMeasure, MusicOWL.hasNoteSet, resNoteset));
                        if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef() != null) {
                            for (l = 0; l < score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getArticulations().size(); ++l) {
                                Resource resArticulation = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS" + notesetCounter + "_ARTICULATION_" + l);
                                model.add(model.createStatement(resNoteset, MusicOWL.hasArticulation, resArticulation));
                                model.add(model.createStatement(resArticulation, RDF.type, model.createResource("http://linkeddata.uni-muenster.de/ontology/musicscore#" + this.getCapital(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getArticulations().get(l)))));
                            }
                            if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign() != null && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine() != null) {
                                if (!score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("percussion")) {
                                    model.add(model.createStatement(resClef, MusicOWL.sign, model.createResource("http://purl.org/ontology/chord/note/" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign())));
                                    model.add(model.createLiteralStatement(resClef, MusicOWL.line, Integer.parseInt(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine())));
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("3") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("C")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.Alto));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("5") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("C")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.Baritone));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("3") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("F")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.Baritone));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("4") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("F")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.Bass));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("1") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("G")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.FrenchViolin));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("2") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("C")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.MezzoSoprano));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("1") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("C")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.Soprano));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("5") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("F")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.SubBass));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("4") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("C")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.Tenor));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getLine().equals("2") && score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("G")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.Trebble));
                                    }
                                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getClef().getSign().equals("percussion")) {
                                        model.add(model.createStatement(resClef, RDF.type, MusicOWL.Percussion));
                                    }
                                } else {
                                    model.add(model.createStatement(resClef, RDF.type, MusicOWL.Percussion));
                                }
                            } else {
                                model.add(model.createStatement(resClef, RDF.type, MusicOWL.Percussion));
                            }
                        }
                        model.add(model.createStatement(resNoteset, MusicOWL.hasDuration, resDuration));
                        if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getType() == null) {
                            if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getPitch() == null) {
                                model.add(model.createStatement(resDuration, RDF.type, MusicOWL.Whole));
                            } else {
                                model.add(model.createStatement(resDuration, RDF.type, MusicOWL.Duration));
                            }
                        } else {
                            model.add(model.createStatement(resDuration, RDF.type, model.createResource("http://linkeddata.uni-muenster.de/ontology/musicscore#" + this.getCapital(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getType()))));
                        }
                    }
                    Resource resNote = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS_" + notesetCounter + "_NOTE_" + k);
                    model.add(model.createStatement(resNoteset, MusicOWL.hasNote, resNote));
                    model.add(model.createStatement(resNote, RDF.type, Chord.Note));
                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getPitch() == null) {
                        model.add(model.createStatement(resNote, Chord.natural, Chord.Rest));
                    } else {
                        model.add(model.createStatement(resNote, Chord.natural, model.createResource("http://purl.org/ontology/chord/note/" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getPitch())));
                        model.add(model.createStatement(model.createResource("http://purl.org/ontology/chord/note/" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getPitch()), RDF.type, Chord.Natural));
                    }
                    Note note = new Note();
                    note.setPitch(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getPitch());
                    note.setAccidental(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getAccidental());
                    note.setOctave(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getOctave());
                    note.setGrace(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).isGrace());
                    if (!note.getAccidental().equals("")) {
                        if (!note.getAccidental().toLowerCase().equals("natural")) {
                            model.add(model.createStatement(resNote, Chord.modifier, model.createResource("http://purl.org/ontology/chord/" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getAccidental())));
                        }
                        this.updateAccidentalsList(note);
                    } else if (note.getPitch() != null && !this.getAccidental(key, note).equals("")) {
                        model.add(model.createStatement(resNote, Chord.modifier, model.createResource("http://purl.org/ontology/chord/" + this.getAccidental(key, note))));
                    }
                    if (note.isGrace()) {
                        Resource resGraceNote = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS_" + notesetCounter + "_N" + k + "_NA_GRACE");
                        model.add(model.createStatement(resNote, MusicOWL.hasNoteAttribute, resGraceNote));
                        model.add(model.createStatement(resGraceNote, RDF.type, MusicOWL.GraceNote));
                    }
                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getOctave() != null) {
                        model.add(model.createLiteralStatement(resNote, MusicOWL.hasOctave, Integer.parseInt(score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getOctave())));
                    }
                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).isDot()) {
                        Resource resDot = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS" + notesetCounter + "_N" + k + "_D_DOT");
                        model.add(model.createStatement(resDuration, MusicOWL.hasDurationAttribute, resDot));
                        model.add(model.createStatement(resDot, RDF.type, MusicOWL.Dot));
                    }
                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).isDoubleDot()) {
                        Resource resDoubleDot = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS" + notesetCounter + "_N" + k + "_D_DOUBLEDOT");
                        model.add(model.createStatement(resDuration, MusicOWL.hasDurationAttribute, resDoubleDot));
                        model.add(model.createStatement(resDoubleDot, RDF.type, MusicOWL.DoubleDot));
                    }
                    if (score.getParts().get(i).getMeasures().get(j).getNotes().get(k).isTripleDot()) {
                        Resource resTripleDot = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS" + notesetCounter + "_N" + k + "_D_TRIPLEDOT");
                        model.add(model.createStatement(resDuration, MusicOWL.hasDurationAttribute, resTripleDot));
                        model.add(model.createStatement(resTripleDot, RDF.type, MusicOWL.TripleDot));
                    }
                    for (int l4 = 0; l4 < score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getDynamics().size(); ++l4) {
                        Resource resDynamic = model.createResource(nodeBaseURI + "MOV" + movementCounter + "_" + partID + "_M" + measureID + "_NS" + notesetCounter + "_DYNAMIC_" + l4);
                        model.add(model.createStatement(resDynamic, RDF.type, model.createResource("http://linkeddata.uni-muenster.de/ontology/musicscore#" + score.getParts().get(i).getMeasures().get(j).getNotes().get(k).getDynamics().get(l4))));
                        model.add(model.createStatement(resNoteset, MusicOWL.hasDynamic, resDynamic));
                    }
                }
            }
        }
        try {
            String xml = new String(score.getFileContent().getBytes(StandardCharsets.UTF_8));
            xml = xml.replace("\\", "\\\\");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            model.add(model.createLiteralStatement(resScore, MusicOWL.asMusicXML, xml.replace("\"", "'")));
            Literal literalEnded = model.createTypedLiteral(sdf.format(new Date()), (RDFDatatype)XSDDatatype.XSDdateTime);
            model.add(model.createLiteralStatement(resActivity, ProvO.endedAtTime, literalEnded));
            staves = null;
            voices = null;
            notesets = null;
            model.write(new FileOutputStream(new File(this.getOutputFile())), this.getOutputFormat());
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
    }

    private Instrument getInstrument(String musicxmlInstrument) {
        Instrument result = new Instrument();
        for (int i = 0; i < this.instruments.size(); ++i) {
            if (!this.instruments.get(i).getPerformanceMediumId().equals(musicxmlInstrument)) continue;
            result.setPerformanceMediumDescription(this.instruments.get(i).getPerformanceMediumDescription());
            result.setPerformanceMediumId(this.instruments.get(i).getPerformanceMediumId());
            result.setPerformanceMediumTypeId(this.instruments.get(i).getPerformanceMediumTypeId());
        }
        return result;
    }

    private boolean isMusicXML(File file) {
        boolean result = false;
        if (FilenameUtils.getExtension(file.getName()).equals("xml") || FilenameUtils.getExtension(file.getName()).equals("mxl")) {
            result = true;
        }
        return result;
    }

    public void parseMusicXML() {
        File file;
        String musicXMLString = "";
        if (this.getOutputFile().equals("")) {
            logger.fatal("No output file provided.");
        }
        if (this.getInputFile() == null) {
            logger.fatal("No input file provided (MusicXML).");
        }
        if (this.getInputFile() == null) {
            logger.fatal("No input file provided (MusicXML).");
        }
        if (!(this.getOutputFormat().equals("") || this.getOutputFormat().toLowerCase().trim().equals("turtle") || this.getOutputFormat().toLowerCase().trim().equals("json-ld") || this.getOutputFormat().toLowerCase().trim().equals("n-triples") || this.getOutputFormat().toLowerCase().trim().equals("n-quads") || this.getOutputFormat().toLowerCase().trim().equals("trig") || this.getOutputFormat().toLowerCase().trim().equals("trix") || this.getOutputFormat().toLowerCase().trim().equals("rdf/xml") || this.getOutputFormat().toLowerCase().trim().equals("rdf/json"))) {
            logger.fatal("Invalid output format [" + this.getOutputFormat() + "]. Supported formats are: TURTLE, JSON-LD, N-TRIPLES, N-QUADS, TRIG, TRIX, RDF/XML, RDF/JSON");
        }
        if (this.isMusicXML(file = this.getInputFile())) {
            Date start;
            if (FilenameUtils.getExtension(file.getName()).equals("mxl")) {
                logger.info("Decompressing MusicXML file: " + file.getName());
                file = Util.decompressMXL(file.getAbsolutePath(), "tmp/");
            }
            try {
                logger.info("Processing " + file.getName() + " ...");
                start = new Date();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
                builder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new StringReader(""));
                    }
                });
                Document document = builder.parse(file);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(document), new StreamResult(writer));
                musicXMLString = writer.getBuffer().toString().replaceAll("\n|\r", "");
                logger.info("Loading XML file: " + Util.timeElapsed(start, new Date()));
            }
            catch (Exception e2) {
                logger.error("[Error processing MusicXML File]: " + e2.getMessage());
            }
            start = new Date();
            MusicScore score = this.createMusicScoreDocument(musicXMLString);
            score.setFileContent(musicXMLString);
            score.setOutputFileName(file.getName());
            score.setURI(this.scoreURI);
            if (!this.documentTitle.equals("")) {
                score.setTitle(this.documentTitle);
                logger.warn("The title \"" + this.documentTitle + "\" was provided and will therefore overwrite the title provided in the MusicXML document.");
            }
            logger.info("Creating MusicScore object: " + Util.timeElapsed(start, new Date()));
            start = new Date();
            this.createRDF(score);
            logger.info("Score serialization: " + Util.timeElapsed(start, new Date()) + "\n");
        } else {
            logger.error("Invalid file format: " + file.getName());
        }
    }

    private MusicScore createMusicScoreDocument(String musicXML) {
        MusicScore score = new MusicScore();
        String currentMode = "";
        String currentFifth = "";
        String currentBeatType = "";
        String currentBeat = "";
        int slurCount = 0;
        boolean slurFlag = false;
        try {
            int i;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            InputSource is = new InputSource(new StringReader(musicXML));
            Document document = builder.parse(is);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            NodeList subfields = (NodeList)xpath.evaluate("//work/work-title", document, XPathConstants.NODESET);
            if (subfields.getLength() != 0) {
                score.setTitle(subfields.item(0).getTextContent());
            }
            if (score.getTitle().equals("") && (subfields = (NodeList)xpath.evaluate("//movement-title", document, XPathConstants.NODESET)).getLength() != 0) {
                score.setTitle(subfields.item(0).getTextContent());
            }
            if ((subfields = (NodeList)xpath.evaluate("//identification/encoding/encoder", document, XPathConstants.NODESET)).getLength() != 0) {
                score.setEncoder(subfields.item(0).getTextContent());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            score.setEncodingStartTime(sdf.format(new Date()));
            subfields = (NodeList)xpath.evaluate("//score-partwise/part-list/score-part/@id", document, XPathConstants.NODESET);
            for (i = 0; i < subfields.getLength(); ++i) {
                ScorePart part = new ScorePart();
                part.setId(subfields.item(i).getTextContent());
                score.getParts().add(part);
            }
            for (i = 0; i < score.getParts().size(); ++i) {
                this.clefList = new ArrayList();
                int movementCount = 0;
                NodeList nodePartName = (NodeList)xpath.evaluate("//score-partwise/part-list/score-part[@id='" + score.getParts().get(i).getId() + "']/part-name", document, XPathConstants.NODESET);
                if (nodePartName.getLength() != 0) {
                    if (nodePartName.item(0).getTextContent().trim().equals("")) {
                        score.getParts().get(i).setName(score.getParts().get(i).getId());
                    } else {
                        score.getParts().get(i).setName(nodePartName.item(0).getTextContent());
                    }
                } else {
                    score.getParts().get(i).setName(score.getParts().get(i).getId());
                }
                NodeList nodeInstrumentName = (NodeList)xpath.evaluate("//score-partwise/part-list/score-part[@id='" + score.getParts().get(i).getId() + "']/score-instrument/instrument-sound", document, XPathConstants.NODESET);
                if (nodeInstrumentName.getLength() != 0) {
                    if (nodeInstrumentName.item(0).getTextContent().trim().equals("")) {
                        score.getParts().get(i).setInstrument("unknown");
                    } else {
                        score.getParts().get(i).setInstrument(nodeInstrumentName.item(0).getTextContent());
                    }
                } else {
                    score.getParts().get(i).setInstrument("unknown");
                }
                NodeList nodeInstrumentSolo = (NodeList)xpath.evaluate("//score-partwise/part-list/score-part[@id='" + score.getParts().get(i).getId() + "']/score-instrument/solo", document, XPathConstants.NODESET);
                if (nodeInstrumentSolo.getLength() != 0) {
                    score.getParts().get(i).setSolo(true);
                } else {
                    score.getParts().get(i).setSolo(false);
                }
                NodeList nodeInstrumentEnsemble = (NodeList)xpath.evaluate("//score-partwise/part-list/score-part[@id='" + score.getParts().get(i).getId() + "']/score-instrument/ensemble", document, XPathConstants.NODESET);
                if (nodeInstrumentEnsemble.getLength() != 0) {
                    score.getParts().get(i).setEnsemble(true);
                } else {
                    score.getParts().get(i).setEnsemble(false);
                }
                NodeList nodeMeasures = (NodeList)xpath.evaluate("//score-partwise/part[@id='" + score.getParts().get(i).getId() + "']/measure", document, XPathConstants.NODESET);
                if (nodeMeasures.getLength() == 0) continue;
                for (int j = 0; j < nodeMeasures.getLength(); ++j) {
                    Measure measure = new Measure();
                    measure.setId(nodeMeasures.item(j).getAttributes().getNamedItem("number").getNodeValue());
                    if (measure.getId().equals("1")) {
                        ++movementCount;
                        Element eElement = (Element)nodeMeasures.item(j);
                        if (eElement.getElementsByTagName("words").getLength() != 0) {
                            measure.setTitle(eElement.getElementsByTagName("words").item(0).getTextContent());
                            if (this.verbose) {
                                logger.info("[" + score.getParts().get(i).getName() + "] Parsing movement: " + movementCount + " (" + measure.getTitle() + ") ... ");
                            }
                        } else if (this.verbose) {
                            logger.info("[" + score.getParts().get(i).getName() + "] Parsing movement: " + movementCount + " ... ");
                        }
                    }
                    score.getParts().get(i).getMeasures().add(measure);
                    ArrayList<String> dynamics = new ArrayList<String>();
                    NodeList nodeMeasureElementsList = nodeMeasures.item(j).getChildNodes();
                    for (int l = 0; l < nodeMeasureElementsList.getLength(); ++l) {
                        int n;
                        int m3;
                        if (nodeMeasureElementsList.item(l).getNodeName().equals("direction")) {
                            Element elementDirection = (Element)((Object)nodeMeasureElementsList.item(l).getChildNodes());
                            for (m3 = 0; m3 < elementDirection.getChildNodes().getLength(); ++m3) {
                                int n2;
                                if (elementDirection.getElementsByTagName("dynamics").item(m3) != null) {
                                    NodeList listDynamics = elementDirection.getElementsByTagName("dynamics").item(m3).getChildNodes();
                                    for (n2 = 0; n2 < listDynamics.getLength(); ++n2) {
                                        if (listDynamics.item(n2).getNodeName().matches("#text")) continue;
                                        dynamics.add(listDynamics.item(n2).getNodeName());
                                    }
                                }
                                if (elementDirection.getElementsByTagName("direction-type").item(m3) == null || elementDirection.getElementsByTagName("metronome").item(m3) == null) continue;
                                NodeList listMetronome = elementDirection.getElementsByTagName("metronome").item(m3).getChildNodes();
                                for (n2 = 0; n2 < listMetronome.getLength(); ++n2) {
                                    if (listMetronome.item(n2).getNodeName().matches("beat-unit")) {
                                        measure.setBeatUnit(listMetronome.item(n2).getTextContent());
                                    }
                                    if (!listMetronome.item(n2).getNodeName().matches("per-minute")) continue;
                                    int perMinute = 0;
                                    if (!listMetronome.item(n2).getTextContent().toString().equals("") || listMetronome.item(n2).getTextContent().toString().matches("^[0-9]+$")) {
                                        perMinute = Integer.parseInt(listMetronome.item(n2).getTextContent().toString().replaceAll("[^\\d]", ""));
                                    }
                                    measure.setBeatsPerMinute(perMinute);
                                }
                            }
                        }
                        if (nodeMeasureElementsList.item(l).getNodeName().equals("attributes")) {
                            NodeList listAttributes = nodeMeasureElementsList.item(l).getChildNodes();
                            for (m3 = 0; m3 < listAttributes.getLength(); ++m3) {
                                if (listAttributes.item(m3).getNodeName().equals("clef")) {
                                    NodeList listClef = listAttributes.item(m3).getChildNodes();
                                    Clef clef = new Clef();
                                    for (n = 0; n < listClef.getLength(); ++n) {
                                        if (listAttributes.item(m3).getAttributes().getNamedItem("number") != null) {
                                            clef.setStaffNumber(listAttributes.item(m3).getAttributes().getNamedItem("number").getNodeValue());
                                        } else {
                                            clef.setStaffNumber("1");
                                        }
                                        if (listClef.item(n).getNodeName().equals("line")) {
                                            clef.setLine(listClef.item(n).getTextContent());
                                        }
                                        if (!listClef.item(n).getNodeName().equals("sign")) continue;
                                        clef.setSign(listClef.item(n).getTextContent());
                                    }
                                    this.addClef(clef);
                                    if (this.verbose) {
                                        logger.info("\t[Clef] Measure: " + measure.getId() + " Sign: " + clef.getSign() + " | Line: " + clef.getLine());
                                    }
                                }
                                if (listAttributes.item(m3).getNodeName().equals("time")) {
                                    NodeList listTime = listAttributes.item(m3).getChildNodes();
                                    for (int n3 = 0; n3 < listTime.getLength(); ++n3) {
                                        if (listTime.item(n3).getNodeName().equals("beats")) {
                                            currentBeat = listTime.item(n3).getTextContent();
                                        }
                                        if (!listTime.item(n3).getNodeName().equals("beat-type")) continue;
                                        currentBeatType = listTime.item(n3).getTextContent();
                                    }
                                    if (this.verbose) {
                                        logger.info("\t[Time] Measure: " + measure.getId() + " Beats: " + currentBeat + " | Beat-type: " + currentBeatType);
                                    }
                                }
                                if (!listAttributes.item(m3).getNodeName().equals("key")) continue;
                                NodeList listKey = listAttributes.item(m3).getChildNodes();
                                for (int n4 = 0; n4 < listKey.getLength(); ++n4) {
                                    if (listKey.item(n4).getNodeName().equals("fifths")) {
                                        currentFifth = listKey.item(n4).getTextContent();
                                    }
                                    if (!listKey.item(n4).getNodeName().equals("mode")) continue;
                                    currentMode = listKey.item(n4).getTextContent();
                                }
                                if (!this.verbose) continue;
                                logger.info("\t[Key] Measure: " + measure.getId() + " Mode: " + currentMode + " | Fifth: " + currentFifth);
                            }
                        }
                        measure.getKey().setMode(currentMode);
                        measure.getKey().setFifths(currentFifth);
                        measure.getTime().setBeats(currentBeat);
                        measure.getTime().setBeatType(currentBeatType);
                        if (nodeMeasureElementsList.item(l).getChildNodes().equals("barline")) {
                            NodeList listBarline = nodeMeasureElementsList.item(l).getChildNodes();
                            for (m3 = 0; m3 < listBarline.getLength(); ++m3) {
                                if (!listBarline.item(m3).getNodeName().equals("repeat")) continue;
                                measure.setBarline(listBarline.item(m3).getAttributes().getNamedItem("direction").getNodeValue());
                            }
                        }
                        Note note = new Note();
                        if (!nodeMeasureElementsList.item(l).getNodeName().equals("note")) continue;
                        NodeList listNoteElements = nodeMeasureElementsList.item(l).getChildNodes();
                        for (int m4 = 0; m4 < listNoteElements.getLength(); ++m4) {
                            if (listNoteElements.item(m4).getNodeName().equals("grace")) {
                                note.setGrace(true);
                            }
                            if (listNoteElements.item(m4).getNodeName().equals("staff")) {
                                note.setStaff(listNoteElements.item(m4).getTextContent());
                            }
                            if (!listNoteElements.item(m4).getNodeName().equals("notations")) continue;
                            NodeList listNotationElements = listNoteElements.item(m4).getChildNodes();
                            for (n = 0; n < listNotationElements.getLength(); ++n) {
                                if (listNotationElements.item(n).getNodeName().equals("slur")) {
                                    if (listNotationElements.item(n).getAttributes().getNamedItem("type").getNodeValue().equals("start")) {
                                        ++slurCount;
                                        slurFlag = true;
                                    }
                                    if (listNotationElements.item(n).getAttributes().getNamedItem("type").getNodeValue().equals("stop")) {
                                        slurFlag = false;
                                    }
                                    note.setSlur(Integer.toString(slurCount));
                                }
                                if (!listNotationElements.item(n).getNodeName().equals("articulations")) continue;
                                NodeList listAriculationElements = listNotationElements.item(n).getChildNodes();
                                for (int o = 0; o < listAriculationElements.getLength(); ++o) {
                                    if (listAriculationElements.item(o).getNodeName().matches("#text")) continue;
                                    note.getArticulations().add(listAriculationElements.item(o).getNodeName());
                                }
                            }
                        }
                        Element elementNotes = (Element)((Object)nodeMeasureElementsList.item(l).getChildNodes());
                        if (elementNotes.getElementsByTagName("chord").item(0) != null) {
                            note.setChord(true);
                        }
                        if (elementNotes.getElementsByTagName("dot").getLength() == 1) {
                            note.setDot(true);
                        }
                        if (elementNotes.getElementsByTagName("dot").getLength() == 2) {
                            note.setDoubleDot(true);
                        }
                        if (elementNotes.getElementsByTagName("dot").getLength() == 3) {
                            note.setTripleDot(true);
                        }
                        if (elementNotes.getElementsByTagName("octave").item(0) != null) {
                            note.setOctave(elementNotes.getElementsByTagName("octave").item(0).getTextContent());
                        }
                        if (elementNotes.getElementsByTagName("step").item(0) != null) {
                            note.setPitch(elementNotes.getElementsByTagName("step").item(0).getTextContent());
                        }
                        if (elementNotes.getElementsByTagName("type").item(0) != null) {
                            note.setType(elementNotes.getElementsByTagName("type").item(0).getTextContent());
                        }
                        if (elementNotes.getElementsByTagName("voice").item(0) != null) {
                            note.getVoice().setId(elementNotes.getElementsByTagName("voice").item(0).getTextContent());
                        } else {
                            note.getVoice().setId("1");
                        }
                        note.getVoice().getPart().setId(score.getParts().get(i).getId());
                        note.getVoice().setMeasure(measure.getId());
                        if (elementNotes.getElementsByTagName("accidental").item(0) != null) {
                            String accidental = elementNotes.getElementsByTagName("accidental").item(0).getTextContent();
                            if (accidental.equals("flat-flat")) {
                                accidental = "doubleflat";
                            } else if (accidental.equals("double-sharp")) {
                                accidental = "doublesharp";
                            }
                            note.setAccidental(accidental);
                        }
                        if (dynamics.size() != 0) {
                            for (int m5 = 0; m5 < dynamics.size(); ++m5) {
                                note.getDynamics().add((String)dynamics.get(m5));
                            }
                            dynamics = new ArrayList();
                        }
                        if (note.getStaff() == null) {
                            note.setStaff("1");
                        }
                        note.getClef().setLine(this.getCurrentClef(note.getStaff()).getLine());
                        note.getClef().setSign(this.getCurrentClef(note.getStaff()).getSign());
                        if (slurFlag) {
                            note.setSlur(Integer.toString(slurCount));
                        }
                        score.getParts().get(i).getMeasures().get(j).getNotes().add(note);
                    }
                }
            }
        }
        catch (SAXException e2) {
            e2.printStackTrace();
        }
        catch (ParserConfigurationException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        catch (XPathExpressionException e5) {
            e5.printStackTrace();
        }
        return score;
    }

    private void addClef(Clef clef) {
        boolean exists = false;
        for (int i = 0; i < this.clefList.size(); ++i) {
            if (!this.clefList.get(i).getStaffNumber().equals(clef.getStaffNumber())) continue;
            this.clefList.get(i).setLine(clef.getLine());
            this.clefList.get(i).setSign(clef.getSign());
            exists = true;
        }
        if (!exists) {
            this.clefList.add(clef);
        }
    }

    private Clef getCurrentClef(String staff) {
        Clef result = new Clef();
        for (int i = 0; i < this.clefList.size(); ++i) {
            if (!this.clefList.get(i).getStaffNumber().equals(staff)) continue;
            result = this.clefList.get(i);
        }
        return result;
    }

    private void setCurrentNoteSet(Note note) {
        boolean exists = false;
        for (int i = 0; i < this.currentNotes.size(); ++i) {
            if (!this.currentNotes.get(i).getVoice().getId().equals(note.getVoice().getId()) || !this.currentNotes.get(i).getStaff().equals(note.getStaff())) continue;
            this.currentNotes.get(i).setSignature(note.getSignature());
            exists = true;
        }
        if (!exists) {
            this.currentNotes.add(note);
        }
    }

    private Note getPreviousNoteSet(Note note) {
        Note result = new Note();
        for (int i = 0; i < this.currentNotes.size(); ++i) {
            if (this.currentNotes.get(i).getStaff() == null || !this.currentNotes.get(i).getStaff().equals(note.getStaff()) || !this.currentNotes.get(i).getVoice().getId().equals(note.getVoice().getId())) continue;
            result = this.currentNotes.get(i);
        }
        return result;
    }

    private String getCapital(String string) {
        if (string != null && string != "") {
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public String getOutputFile() {
        String result = "";
        if (this.getOutputFormat().toLowerCase().equals("json-ld")) {
            result = this.outputFile + ".jsonld";
        }
        if (this.getOutputFormat().toLowerCase().equals("turtle")) {
            result = this.outputFile + ".ttl";
        }
        if (this.getOutputFormat().toLowerCase().equals("n-triples")) {
            result = this.outputFile + ".nt";
        }
        if (this.getOutputFormat().toLowerCase().equals("n-quads")) {
            result = this.outputFile + ".nq";
        }
        if (this.getOutputFormat().toLowerCase().equals("trig")) {
            result = this.outputFile + ".trig";
        }
        if (this.getOutputFormat().toLowerCase().equals("rdf/json")) {
            result = this.outputFile + ".rj";
        }
        if (this.getOutputFormat().toLowerCase().equals("trix")) {
            result = this.outputFile + ".trix";
        }
        if (this.getOutputFormat().toLowerCase().equals("rdf/xml")) {
            result = this.outputFile + ".rdf";
        }
        return result;
    }

    public void setOutputFile(String outputfile) {
        this.outputFile = outputfile;
    }

    public void setInputFile(File musicxml) {
        this.inputFile = musicxml;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public String getScoreURI() {
        return this.scoreURI;
    }

    public void setScoreURI(String uri) {
        this.scoreURI = uri;
    }

    public void setDocumentTitle(String title) {
        this.documentTitle = title;
    }

    public String getDocumentTitle(String title) {
        return this.documentTitle;
    }

    public void setPersons(ArrayList<Person> persons) {
        this.persons = persons;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getDateIssued() {
        return this.dateIssued;
    }

    public void setDateIssued(String dateIssued) {
        this.dateIssued = dateIssued;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public ArrayList<ScoreResource> getResources() {
        return this.resources;
    }

    public void addResource(ScoreResource resource) {
        this.resources.add(resource);
    }

    public String getVersion() {
        String result = "";
        try (InputStream is2 = this.getClass().getClassLoader().getResourceAsStream("pom.xml");){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            org.apache.maven.model.Model model = reader.read(is2);
            result = model.getVersion();
        }
        catch (IOException is2) {
        }
        catch (XmlPullParserException e2) {
            e2.printStackTrace();
        }
        return result;
    }
}

