package de.wwu.music2rdf.example;

import javax.xml.transform.*;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

public class TransformFile {
	
    public static void main(String[] args) throws IOException, URISyntaxException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Source xslt = new StreamSource(new File("/home/jones/musixml2mei.xslt"));
        Transformer transformer = factory.newTransformer(xslt);

        Source text = new StreamSource(new File("/home/jones/sonate_facile_piano-forteF.xml"));
        transformer.transform(text, new StreamResult(new File("/home/jones/output.mei")));
    }
}