/*
 * Decompiled with CFR 0.152.
 */
package migratedb.testing.util.dependencies;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import migratedb.testing.util.dependencies.DependencyResolutionResult;
import org.apache.commons.io.FileUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\bH\u0002J%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J%\u0010\u0017\u001a\u00020\u001c*\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 *\b\u0012\u0004\u0012\u00020\u00140\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lmigratedb/testing/util/dependencies/DependencyResolver;", "", "()V", "mavenCentral", "Lorg/eclipse/aether/repository/RemoteRepository;", "repositorySystem", "Lorg/eclipse/aether/RepositorySystem;", "session", "Lorg/eclipse/aether/RepositorySystemSession;", "addToResult", "", "result", "Lmigratedb/testing/util/dependencies/DependencyResolutionResult;", "results", "", "Lorg/eclipse/aether/resolution/ArtifactResult;", "createDependencyRequest", "Lorg/eclipse/aether/resolution/DependencyRequest;", "dependencies", "", "Lorg/eclipse/aether/graph/Dependency;", "newRepositorySystem", "newSession", "resolve", "coordinates", "", "", "([Ljava/lang/String;)Ljava/util/List;", "Ljava/io/File;", "paths", "(Ljava/io/File;[Ljava/lang/String;)Ljava/io/File;", "toClassLoader", "Ljava/net/URLClassLoader;", "migratedb-testlib"})
public final class DependencyResolver {
    @NotNull
    public static final DependencyResolver INSTANCE = new DependencyResolver();
    @NotNull
    private static final RepositorySystem repositorySystem = INSTANCE.newRepositorySystem();
    @NotNull
    private static final RepositorySystemSession session = INSTANCE.newSession();
    @NotNull
    private static final RemoteRepository mavenCentral;

    private DependencyResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final URLClassLoader toClassLoader(@NotNull Collection<Dependency> $this$toClassLoader) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toClassLoader, (String)"<this>");
        Iterable $this$map$iv = $this$toClassLoader;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Dependency dependency = (Dependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getArtifact().getFile().toPath().toUri().toURL());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        Intrinsics.checkNotNull((Object)uRLArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        URL[] urls = uRLArray;
        return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Dependency> resolve(String ... coordinates) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        String[] stringArray = coordinates;
        DependencyResolver dependencyResolver = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Dependency((Artifact)new DefaultArtifact((String)it), null));
        }
        return dependencyResolver.resolve((List)destination$iv$iv);
    }

    @NotNull
    public final List<Dependency> resolve(@NotNull List<Dependency> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        DependencyResolutionResult result = new DependencyResolutionResult(null, null, null, 7, null);
        DependencyRequest depRequest = this.createDependencyRequest(dependencies);
        List list = repositorySystem.resolveDependencies(session, depRequest).getArtifactResults();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"repositorySystem.resolve\u2026pRequest).artifactResults");
        this.addToResult(result, list);
        if (!((Collection)result.getUnresolvedDependencies()).isEmpty()) {
            throw new IllegalStateException("Unresolved dependencies: " + result.getUnresolvedDependencies());
        }
        if (!result.getResolutionErrors().isEmpty()) {
            throw new IllegalStateException("Dependency resolution errors: " + result.getResolutionErrors());
        }
        return CollectionsKt.toList((Iterable)result.getResolvedDependencies());
    }

    private final DependencyRequest createDependencyRequest(List<Dependency> dependencies) {
        CollectRequest collect = new CollectRequest();
        collect.setRequestContext("integration-test");
        collect.setDependencies(dependencies);
        collect.addRepository(mavenCentral);
        RequestTrace trace = RequestTrace.newChild(null, (Object)collect);
        DependencyRequest dependencyRequest = new DependencyRequest(collect, null);
        dependencyRequest.setTrace(trace);
        collect.setTrace(RequestTrace.newChild((RequestTrace)trace, (Object)dependencyRequest));
        dependencyRequest.setRoot(repositorySystem.collectDependencies(session, collect).getRoot());
        return dependencyRequest;
    }

    private final void addToResult(DependencyResolutionResult result, Collection<ArtifactResult> results) {
        for (ArtifactResult artifactResult : results) {
            Dependency dependency;
            DependencyNode node = artifactResult.getRequest().getDependencyNode();
            if (artifactResult.isResolved()) {
                List<Dependency> list = result.getResolvedDependencies();
                Dependency dependency2 = node.getDependency();
                Intrinsics.checkNotNullExpressionValue((Object)dependency2, (String)"node.dependency");
                list.add(dependency2);
                continue;
            }
            Map<Dependency, List<Exception>> map = result.getResolutionErrors();
            Intrinsics.checkNotNullExpressionValue((Object)node.getDependency(), (String)"node.dependency");
            ArrayList arrayList = new ArrayList(artifactResult.getExceptions());
            map.put(dependency, arrayList);
        }
    }

    private final RepositorySystemSession newSession() {
        DefaultRepositorySystemSession defaultRepositorySystemSession = MavenRepositorySystemUtils.newSession();
        Intrinsics.checkNotNullExpressionValue((Object)defaultRepositorySystemSession, (String)"newSession()");
        DefaultRepositorySystemSession session = defaultRepositorySystemSession;
        File file = FileUtils.getUserDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getUserDirectory()");
        String[] stringArray = new String[]{".m2", "repository"};
        LocalRepository localRepo = new LocalRepository(this.resolve(file, stringArray));
        session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return (RepositorySystemSession)session;
    }

    private final RepositorySystem newRepositorySystem() {
        DefaultServiceLocator defaultServiceLocator = MavenRepositorySystemUtils.newServiceLocator();
        Intrinsics.checkNotNullExpressionValue((Object)defaultServiceLocator, (String)"newServiceLocator()");
        DefaultServiceLocator locator = defaultServiceLocator;
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        Object object = locator.getService(RepositorySystem.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"locator.getService(RepositorySystem::class.java)");
        return (RepositorySystem)object;
    }

    /*
     * WARNING - void declaration
     */
    private final File resolve(File $this$resolve, String ... paths) {
        String[] $this$fold$iv = paths;
        boolean $i$f$fold = false;
        File accumulator$iv = $this$resolve;
        int n = $this$fold$iv.length;
        for (int j = 0; j < n; ++j) {
            void p;
            String element$iv;
            String string = element$iv = $this$fold$iv[j];
            File f = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new File(f, (String)p);
        }
        return accumulator$iv;
    }

    static {
        RemoteRepository remoteRepository = new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build();
        Intrinsics.checkNotNullExpressionValue((Object)remoteRepository, (String)"Builder(\n        \"centra\u2026rg/maven2/\"\n    ).build()");
        mavenCentral = remoteRepository;
    }
}

